package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleDrawTypeEnum;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterProjectDrwgrpNumMapper;
import com.ejianc.business.settle.service.*;
import com.ejianc.business.settle.vo.BatchSubmitVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算中心卷册信息表
 *
 * @author generator
 */
@Controller
@RequestMapping("settlementCenterDcDrwgrpInfo")
public class SettlementCenterDcDrwgrpInfoController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService service;
    @Autowired
    private ISettlementCenterDrawPlanService drawPlanService;
    @Autowired
    private ISettlementCenterDrawPlanDetailService drawPlanDetailService;
    @Autowired
    private ISettlementCenterSystemDrwgrpService systemDrwgrpService;
    @Autowired
    private ISettlementCenterProjectMajorService projectMajorService;
    @Autowired
    private IBpmApi iBpmApi;
//    @Autowired
//    private ISettlementCenterBudgetFeeService feeService;
//    @Autowired
//    private ISettlementCenterBudgetMeasureService measureService;
//    @Autowired
//    private ISettlementCenterBudgetSubService subService;
//    @Autowired
//    private ISettlementCenterBudgetOtherService otherService;
//    @Autowired
//    private ISettlementCenterUserProjectDetailService userProjectDetailService;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;
    @Autowired
    private SettlementCenterProjectDrwgrpNumMapper numMapper;
    @Value("${common.env.base-host}")
    private String baseHost;
    private static final String PARENT_BILL_TYPE_CODE = "BT250121000000001";//系统产值单据类型编码

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdate(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
        service.saveOrUpdate(entity, false);
        CommonResponse<SettlementCenterDcDrwgrpInfoVO> commonResponse = queryDetail(entity.getId());
        SettlementCenterDcDrwgrpInfoVO vo = commonResponse.getData();
//    	SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 卷册审批完成新增数据
     */
    @RequestMapping(value = "/saveOrUpdateDcDrwgrpInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getSettlementCenterMajor() == null){
            saveOrUpdateVO.setSettlementCenterMajor(saveOrUpdateVO.getMajorId());
        }
        String sourceUnitid = saveOrUpdateVO.getSourceUnitid();
        String sourceUnitname = saveOrUpdateVO.getSourceUnitname();
        SettlementCenterDcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class);
        SettlementCenterDcDrwgrpInfoEntity exist = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, saveOrUpdateVO.getDcDrwgrpInfoId())
        );
        if (exist != null) {
            exist.setFirstNodeTime(new Date());
            exist.setOrgId(entity.getOrgId());
            exist.setOrgCode(entity.getOrgCode());
            exist.setOrgName(entity.getOrgName());
            exist.setParentOrgId(entity.getParentOrgId());
            exist.setParentOrgCode(entity.getParentOrgCode());
            exist.setParentOrgName(entity.getParentOrgName());
            exist.setProjectId(entity.getProjectId());
            exist.setProjectCode(entity.getProjectCode());
            exist.setProjectName(entity.getProjectName());
            exist.setDcDrwgrpInfoCode(entity.getDcDrwgrpInfoCode());
            exist.setDcDrwgrpInfoName(entity.getDcDrwgrpInfoName());
            service.updateById(exist);
        } else {
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = service.getOne(new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, saveOrUpdateVO.getDcDrwgrpInfoCode())
                    .eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, 0)
            );
            if (notUpgrade != null){
                entity.setWhetherUpgrade(1);
            }
            Long systemId = entity.getSystemId();
            if (systemId != null){
                logger.info("当前到图计划id为:"+systemId);
                SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = drawPlanService.selectById(systemId);
                if (settlementCenterDrawPlanEntity != null){
                    logger.info("saveOrUpdateDcDrwgrpInfo-------1");
                    List<SettlementCenterDrawPlanDetailEntity> detailList = settlementCenterDrawPlanEntity.getSettlementCenterDrawPlanDetailList();
                    SettlementCenterDrawPlanDetailEntity settlementCenterDrawPlanDetailEntity = detailList.stream().filter(e -> entity.getDcDrwgrpInfoCode().contains(e.getDrwgrpCode())).findFirst().orElse(null);
                    if (settlementCenterDrawPlanDetailEntity != null){
                        logger.info("saveOrUpdateDcDrwgrpInfo-----2");
                        settlementCenterDrawPlanDetailEntity.setEndTime(new Date());
                        drawPlanDetailService.updateById(settlementCenterDrawPlanDetailEntity);
                    }
                    SettlementCenterDrawPlanEntity drawPlanEntity = handlerDate(settlementCenterDrawPlanEntity);
                    drawPlanService.updateById(drawPlanEntity);
                }

                SettlementCenterSystemDrwgrpEntity one = systemDrwgrpService.getOne(
                        new QueryWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
                                .eq(SettlementCenterSystemDrwgrpEntity::getSystemId, systemId)
                                .eq(SettlementCenterSystemDrwgrpEntity::getDr, 0)
                                .last(" limit 0,1 ")
                );
                if (one != null){
                    //卷册加父级id
                    entity.setPid(one.getId());
                    if (StringUtils.isNotEmpty(sourceUnitid) && !one.getSourceUnitid().contains(sourceUnitid)){
                        if (StringUtils.isNotEmpty(one.getSourceUnitid())) {
                            one.setSourceUnitid(one.getSourceUnitid()+","+sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname()+","+sourceUnitname);
                        }else {
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                        systemDrwgrpService.updateById(one);
                    }
                }else {
                    one = new SettlementCenterSystemDrwgrpEntity();
                    one.setFlowState(SettleFlowStateEnum.ONE.getCode());
                    one.setFlowStateName(SettleFlowStateEnum.ONE.getName());
                    one.setFirstNodeTime(new Date());
                    one.setDesiredTime(settlementCenterDrawPlanEntity.getCalEndTime());
                    one.setSystemId(systemId);
                    one.setSystemName(settlementCenterDrawPlanEntity.getSystemName());
                    one.setOrgId(entity.getOrgId());
                    one.setOrgCode(entity.getOrgCode());
                    one.setOrgName(entity.getOrgName());
                    one.setParentOrgId(entity.getParentOrgId());
                    one.setParentOrgCode(entity.getParentOrgCode());
                    one.setParentOrgName(entity.getParentOrgName());
                    one.setProjectId(entity.getProjectId());
                    one.setProjectCode(entity.getProjectCode());
                    one.setProjectName(entity.getProjectName());
                    one.setThirdNodeUserId(settlementCenterDrawPlanEntity.getStatisticalPerson() == null ? null : settlementCenterDrawPlanEntity.getStatisticalPerson().toString());
                    one.setFourthNodeUserId(settlementCenterDrawPlanEntity.getMajorManagerPerson() == null ? null : settlementCenterDrawPlanEntity.getMajorManagerPerson().toString());
                    one.setFifthNodeUserId(settlementCenterDrawPlanEntity.getProjectResponsiblePerson());
                    one.setSixthNodeUserId(settlementCenterDrawPlanEntity.getProjectContractPerson());
                    one.setSeventhNodeUserId(settlementCenterDrawPlanEntity.getCompositePerson());
                    one.setSettlementCenterMajor(settlementCenterDrawPlanEntity.getSettlementCenterMajor().toString());
                    one.setSettlementCenterMajorName(settlementCenterDrawPlanEntity.getSettlementCenterMajorName());
                    SettlementCenterProjectMajorEntity projectMajor = projectMajorService.getOne(
                            new QueryWrapper<SettlementCenterProjectMajorEntity>().lambda()
                                    .eq(SettlementCenterProjectMajorEntity::getProjectId, settlementCenterDrawPlanEntity.getProjectId())
                                    .eq(SettlementCenterProjectMajorEntity::getSettlementCenterMajor, settlementCenterDrawPlanEntity.getSettlementCenterMajor())
                                    .eq(SettlementCenterProjectMajorEntity::getDr, 0)
                    );
                    if (projectMajor != null){
                        one.setContractId(projectMajor.getContractId());
                        one.setContractCode(projectMajor.getContractCode());
                        one.setContractMny(projectMajor.getContractTaxMny());
                    }

                    if (StringUtils.isNotEmpty(sourceUnitid) ){
                        if (StringUtils.isNotEmpty(one.getSourceUnitid()) && !one.getSourceUnitid().contains(sourceUnitid)) {
                            one.setSourceUnitid(one.getSourceUnitid()+","+sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname()+","+sourceUnitname);
                        }else if (!StringUtils.isNotEmpty(one.getSourceUnitid())){
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                    }

                    systemDrwgrpService.save(one);
                    Map<String, Object> submitParam = Maps.newHashMap();
                    submitParam.put("userId", InvocationInfoProxy.getUserid());
                    submitParam.put("billtypeId", PARENT_BILL_TYPE_CODE);
                    submitParam.put("businessKey", one.getId());
                    submitParam.put("formurl", baseHost + "/settle/#/drawingEngineering/new/card?id=" + one.getId());
                    submitParam.put("procInstName", "图纸工程量管理" + one.getId() + DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
                    submitParam.put("billOrgId", one.getOrgId());
                    submitParam.put("messageType", new String[]{"sys"});
                    iBpmApi.doSubmit(submitParam);
                    entity.setPid(one.getId());
                }
            }
            service.save(entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    public SettlementCenterDrawPlanEntity handlerDate(SettlementCenterDrawPlanEntity entity){
        if (entity != null){
            List<SettlementCenterDrawPlanDetailEntity> detailList = entity.getSettlementCenterDrawPlanDetailList();

            Date planStartTime = null;//计划到图时间最早时间
            Date planEndTime = null;//计划到图时间最晚时间
            Date realStartTime = null;//实际到图时间最早时间
            Date realEndTime = null;//实际到图时间最晚时间
            boolean hasEnd = false;//有没有实际到图时间
            boolean hasnotEnd = true;//是不是全部实际到图时间都有
            for (SettlementCenterDrawPlanDetailEntity detailEntity : detailList) {
                if (detailEntity.getEndTime() != null){
                    hasEnd = true;
                }else {
                    hasnotEnd = false;
                }
                if (planStartTime == null){
                    planStartTime = detailEntity.getStartTime();
                }else {
                    if (detailEntity.getStartTime() != null && planStartTime.after(detailEntity.getStartTime())){
                        planStartTime = detailEntity.getStartTime();
                    }
                }

                if (planEndTime == null){
                    planEndTime = detailEntity.getStartTime();
                }else {
                    if (detailEntity.getStartTime() != null && planEndTime.before(detailEntity.getStartTime())){
                        planEndTime = detailEntity.getStartTime();
                    }
                }

                if (realStartTime == null){
                    realStartTime = detailEntity.getEndTime();
                }else {
                    if (detailEntity.getEndTime() != null && realStartTime.after(detailEntity.getEndTime())){
                        realStartTime = detailEntity.getEndTime();
                    }
                }

                if (realEndTime == null){
                    realEndTime = detailEntity.getEndTime();
                }else {
                    if (detailEntity.getEndTime() != null && realEndTime.before(detailEntity.getEndTime())){
                        realEndTime = detailEntity.getEndTime();
                    }
                }
            }

            if(hasEnd){
                if (realStartTime != null){
                    entity.setCalStartTime(realStartTime);
                }
            }else {
                if (planStartTime != null){
                    entity.setCalStartTime(realStartTime);
                }
            }

            Date endTime = null;
            if (hasnotEnd){
                endTime = realEndTime;
            }else {
                endTime = planEndTime;
            }

            if (endTime != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(realEndTime);
                calendar.add(Calendar.DAY_OF_MONTH, entity.getPlanFinishDays());
                entity.setCalEndTime(calendar.getTime());
            }

        }
        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
//    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
//        SettlementCenterDcDrwgrpInfoEntity entity = service.selectById(id);
//        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(entity, SettlementCenterDcDrwgrpInfoVO.class);
//        vo.setSubTotalMny(BigDecimal.ZERO);
//        vo.setSubTotalTaxMny(BigDecimal.ZERO);
//        vo.setSubTotalTax(BigDecimal.ZERO);
//        vo.setSubTotalOutput(BigDecimal.ZERO);
//        vo.setMeasureTotalMny(BigDecimal.ZERO);
//        vo.setMeasureTotalTaxMny(BigDecimal.ZERO);
//        vo.setMeasureTotalTax(BigDecimal.ZERO);
//        vo.setMeasureTotalOutput(BigDecimal.ZERO);
//        vo.setOtherTotalMny(BigDecimal.ZERO);
//        vo.setOtherTotalTaxMny(BigDecimal.ZERO);
//        vo.setOtherTotalTax(BigDecimal.ZERO);
//        vo.setOtherTotalOutput(BigDecimal.ZERO);
//        vo.setFeeTotalMny(BigDecimal.ZERO);
//        vo.setFeeTotalTaxMny(BigDecimal.ZERO);
//        vo.setFeeTotalTax(BigDecimal.ZERO);
//        vo.setFeeTotalOutput(BigDecimal.ZERO);
//
//        Long userid = InvocationInfoProxy.getUserid();
//        logger.info("累计产值的用户id:"+userid);
//        //累计产值数据
//        List<SettlementCenterUserProjectDetailEntity> userProjectDetailEntities = userProjectDetailService.list(
//                new QueryWrapper<SettlementCenterUserProjectDetailEntity>().lambda()
//                        .eq(SettlementCenterUserProjectDetailEntity::getUserId, userid)
//                        .eq(SettlementCenterUserProjectDetailEntity::getDr, 0)
//        );
//        //母版数据
//        List<SettlementCenterBudgetSubEntity> subEntities = subService.list(
//                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
//                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo, 0)
//                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
//        );
//        List<SettlementCenterBudgetMeasureEntity> measureEntities = measureService.list(
//                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
//                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo, 0)
//                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
//        );
//        List<SettlementCenterBudgetOtherEntity> otherEntities = otherService.list(
//                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
//                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo, 0)
//                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
//        );
//        List<SettlementCenterBudgetFeeEntity> feeEntities = feeService.list(
//                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
//                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo, 0)
//                        .last(" order by CAST(detail_index AS SIGNED INTEGER) ")
//        );
//        //图纸工程量数据
//        List<SettlementCenterBudgetSubEntity> dcSubEntities = subService.list(
//                new QueryWrapper<SettlementCenterBudgetSubEntity>().lambda()
//                        .eq(SettlementCenterBudgetSubEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetSubEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo, entity.getId())
//        );
//        List<SettlementCenterBudgetMeasureEntity> dcMeasureEntities = measureService.list(
//                new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
//                        .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetMeasureEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo, entity.getId())
//        );
//        List<SettlementCenterBudgetOtherEntity> dcOtherEntities = otherService.list(
//                new QueryWrapper<SettlementCenterBudgetOtherEntity>().lambda()
//                        .eq(SettlementCenterBudgetOtherEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetOtherEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo, entity.getId())
//        );
//        List<SettlementCenterBudgetFeeEntity> dcFeeEntities = feeService.list(
//                new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
//                        .eq(SettlementCenterBudgetFeeEntity::getBudgetId, entity.getBudgeId())
//                        .eq(SettlementCenterBudgetFeeEntity::getDr, 0)
//                        .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo, entity.getId())
//        );
//        if (subEntities != null && subEntities.size() > 0) {
//            List<SettlementCenterBudgetSubVO> subVos = BeanMapper.mapList(subEntities, SettlementCenterBudgetSubVO.class);
//            BigDecimal totalMny = new BigDecimal(0);//无税金额
//            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
//            BigDecimal totalTax = new BigDecimal(0);//税额
//            BigDecimal totalOutput = new BigDecimal(0);//统计产值
//            for (SettlementCenterBudgetSubVO subVo : subVos) {
//
//                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
//                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
//                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
//                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量
//
//                totalMny = totalMny.add(subVo.getSubMny() == null ? BigDecimal.ZERO : subVo.getSubMny());
//                totalTaxMny = totalTaxMny.add(subVo.getSubTaxMny() == null ? BigDecimal.ZERO : subVo.getSubTaxMny());
//                totalTax = totalTax.add(subVo.getSubTax() == null ? BigDecimal.ZERO : subVo.getSubTax());
//                //把统计数据汇总到母版数据上
//                for (SettlementCenterBudgetSubEntity dcSubEntity : dcSubEntities) {
//                    if (dcSubEntity.getParentId().equals(subVo.getId())) {
//                        subVo.setSettlementCenterSubMny(dcSubEntity.getSettlementCenterSubMny() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubMny());
//                        subVo.setSettlementCenterSubNum(dcSubEntity.getSettlementCenterSubNum() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubNum());
//                        subVo.setSettlementCenterSubTax(dcSubEntity.getSettlementCenterSubTax() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubTax());
//                        subVo.setSettlementCenterSubTaxMny(dcSubEntity.getSettlementCenterSubTaxMny() == null ? BigDecimal.ZERO : dcSubEntity.getSettlementCenterSubTaxMny());
//                        if (StringUtils.isNotEmpty(dcSubEntity.getSubMemo())){
//                            subVo.setSubMemo(dcSubEntity.getSubMemo());
//                        }
//                        totalOutput = totalOutput.add(subVo.getSettlementCenterSubTaxMny());
//                    }
//                }
//
//                //把累计产值数据汇总到母版数据上
//                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
//                    if (subVo.getId().equals(detailEntity.getSourceId())){
//                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
//                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
//                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
//                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
//                    }
//                }
//                subVo.setSettlementCenterSubMnyTotal(settlementCenterMnyTotal);
//                subVo.setSettlementCenterSubNumTotal(settlementCenterNumTotal);
//                subVo.setSettlementCenterSubTaxTotal(settlementCenterTaxTotal);
//                subVo.setSettlementCenterSubTaxMnyTotal(settlementCenterTaxMnyTotal);
//            }
//            vo.setSubTotalMny(totalMny);
//            vo.setSubTotalTaxMny(totalTaxMny);
//            vo.setSubTotalTax(totalTax);
//            vo.setSubTotalOutput(totalOutput);
//            List<Map> subMap = BeanMapper.mapList(subVos, Map.class);
//            for (Map map : subMap) {
//                map.remove("createUserName");
//            }
//            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(subMap);
//            subVos = BeanMapper.mapList(mapList, SettlementCenterBudgetSubVO.class);
//            vo.setSubVOS(subVos);
//        }
//        if (measureEntities != null && measureEntities.size() > 0) {
//            List<SettlementCenterBudgetMeasureVO> measureVos = BeanMapper.mapList(measureEntities, SettlementCenterBudgetMeasureVO.class);
//            BigDecimal totalMny = new BigDecimal(0);//无税金额
//            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
//            BigDecimal totalTax = new BigDecimal(0);//税额
//            BigDecimal totalOutput = new BigDecimal(0);//统计产值
//            for (SettlementCenterBudgetMeasureVO measureVo : measureVos) {
//
//                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
//                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
//                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
//                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量
//
//                totalMny = totalMny.add(measureVo.getMeasureMny() == null ? BigDecimal.ZERO : measureVo.getMeasureMny());
//                totalTaxMny = totalTaxMny.add(measureVo.getMeasureTaxMny() == null ? BigDecimal.ZERO : measureVo.getMeasureTaxMny());
//                totalTax = totalTax.add(measureVo.getMeasureTax() == null ? BigDecimal.ZERO : measureVo.getMeasureTax());
//                //把统计数据汇总到母版数据上
//                for (SettlementCenterBudgetMeasureEntity dcMeasureEntity : dcMeasureEntities) {
//                    if (dcMeasureEntity.getParentId().equals(measureVo.getId())) {
//                        measureVo.setSettlementCenterMeasureMny(dcMeasureEntity.getSettlementCenterMeasureMny() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureMny());
//                        measureVo.setSettlementCenterMeasureNum(dcMeasureEntity.getSettlementCenterMeasureNum() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureNum());
//                        measureVo.setSettlementCenterMeasureTax(dcMeasureEntity.getSettlementCenterMeasureTax() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureTax());
//                        measureVo.setSettlementCenterMeasureTaxMny(dcMeasureEntity.getSettlementCenterMeasureTaxMny() == null ? BigDecimal.ZERO : dcMeasureEntity.getSettlementCenterMeasureTaxMny());
//                        if (StringUtils.isNotEmpty(dcMeasureEntity.getMeasureMemo())){
//                            measureVo.setMeasureMemo(dcMeasureEntity.getMeasureMemo());
//                        }
//                        totalOutput = totalOutput.add(measureVo.getSettlementCenterMeasureTaxMny());
//                    }
//                }
//
//                //把累计产值数据汇总到母版数据上
//                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
//                    if (measureVo.getId().equals(detailEntity.getSourceId())){
//                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
//                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
//                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
//                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
//                    }
//                }
//                measureVo.setSettlementCenterMeasureMnyTotal(settlementCenterMnyTotal);
//                measureVo.setSettlementCenterMeasureNumTotal(settlementCenterNumTotal);
//                measureVo.setSettlementCenterMeasureTaxTotal(settlementCenterTaxTotal);
//                measureVo.setSettlementCenterMeasureTaxMnyTotal(settlementCenterTaxMnyTotal);
//            }
//            vo.setMeasureTotalMny(totalMny);
//            vo.setMeasureTotalTaxMny(totalTaxMny);
//            vo.setMeasureTotalTax(totalTax);
//            vo.setMeasureTotalOutput(totalOutput);
//            List<Map> measureMap = BeanMapper.mapList(measureVos, Map.class);
//            for (Map map : measureMap) {
//                map.remove("createUserName");
//            }
//            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(measureMap);
//            measureVos = BeanMapper.mapList(mapList, SettlementCenterBudgetMeasureVO.class);
//            vo.setMeasureVOS(measureVos);
//        }
//        if (otherEntities != null && otherEntities.size() > 0) {
//            List<SettlementCenterBudgetOtherVO> otherVos = BeanMapper.mapList(otherEntities, SettlementCenterBudgetOtherVO.class);
//            BigDecimal totalMny = new BigDecimal(0);//无税金额
//            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
//            BigDecimal totalTax = new BigDecimal(0);//税额
//            BigDecimal totalOutput = new BigDecimal(0);//统计产值
//            for (SettlementCenterBudgetOtherVO otherVo : otherVos) {
//
//                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
//                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
//                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
//                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量
//
//                totalMny = totalMny.add(otherVo.getOtherMny() == null ? BigDecimal.ZERO : otherVo.getOtherMny());
//                totalTaxMny = totalTaxMny.add(otherVo.getOtherTaxMny() == null ? BigDecimal.ZERO : otherVo.getOtherTaxMny());
//                totalTax = totalTax.add(otherVo.getOtherTax() == null ? BigDecimal.ZERO : otherVo.getOtherTax());
//                //把统计数据汇总到母版数据上
//                for (SettlementCenterBudgetOtherEntity dcOtherEntity : dcOtherEntities) {
//                    if (dcOtherEntity.getParentId().equals(otherVo.getId())) {
//                        otherVo.setSettlementCenterOtherMny(dcOtherEntity.getSettlementCenterOtherMny() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherMny());
//                        otherVo.setSettlementCenterOtherNum(dcOtherEntity.getSettlementCenterOtherNum() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherNum());
//                        otherVo.setSettlementCenterOtherTax(dcOtherEntity.getSettlementCenterOtherTax() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherTax());
//                        otherVo.setSettlementCenterOtherTaxMny(dcOtherEntity.getSettlementCenterOtherTaxMny() == null ? BigDecimal.ZERO : dcOtherEntity.getSettlementCenterOtherTaxMny());
//                        if (StringUtils.isNotEmpty(dcOtherEntity.getOtherMemo())){
//                            otherVo.setOtherMemo(dcOtherEntity.getOtherMemo());
//                        }
//                        totalOutput = totalOutput.add(otherVo.getSettlementCenterOtherTaxMny());
//                    }
//                }
//
//                //把累计产值数据汇总到母版数据上
//                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
//                    if (otherVo.getId().equals(detailEntity.getSourceId())){
//                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
//                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
//                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
//                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
//                    }
//                }
//                otherVo.setSettlementCenterOtherMnyTotal(settlementCenterMnyTotal);
//                otherVo.setSettlementCenterOtherNumTotal(settlementCenterNumTotal);
//                otherVo.setSettlementCenterOtherTaxTotal(settlementCenterTaxTotal);
//                otherVo.setSettlementCenterOtherTaxMnyTotal(settlementCenterTaxMnyTotal);
//            }
//            vo.setOtherTotalMny(totalMny);
//            vo.setOtherTotalTaxMny(totalTaxMny);
//            vo.setOtherTotalTax(totalTax);
//            vo.setOtherTotalOutput(totalOutput);
//            List<Map> otherMap = BeanMapper.mapList(otherVos, Map.class);
//            for (Map map : otherMap) {
//                map.remove("createUserName");
//            }
//            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(otherMap);
//            otherVos = BeanMapper.mapList(mapList, SettlementCenterBudgetOtherVO.class);
//            vo.setOtherVOS(otherVos);
//        }
//        if (feeEntities != null && feeEntities.size() > 0) {
//            List<SettlementCenterBudgetFeeVO> feeVos = BeanMapper.mapList(feeEntities, SettlementCenterBudgetFeeVO.class);
//            BigDecimal totalMny = new BigDecimal(0);//无税金额
//            BigDecimal totalTaxMny = new BigDecimal(0);//含税金额
//            BigDecimal totalTax = new BigDecimal(0);//税额
//            BigDecimal totalOutput = new BigDecimal(0);//统计产值
//            for (SettlementCenterBudgetFeeVO feeVo : feeVos) {
//
//                BigDecimal settlementCenterMnyTotal = new BigDecimal(0); // 累计统计产值(无税)
//                BigDecimal settlementCenterTaxMnyTotal = new BigDecimal(0); // 累计统计产值(含税)
//                BigDecimal settlementCenterTaxTotal = new BigDecimal(0); // 累计统计产值税额
//                BigDecimal settlementCenterNumTotal = new BigDecimal(0); // 累计统计工程量
//
//                totalMny = totalMny.add(feeVo.getFeeMny() == null ? BigDecimal.ZERO : feeVo.getFeeMny());
//                totalTaxMny = totalTaxMny.add(feeVo.getFeeTaxMny() == null ? BigDecimal.ZERO : feeVo.getFeeTaxMny());
//                totalTax = totalTax.add(feeVo.getFeeTax() == null ? BigDecimal.ZERO : feeVo.getFeeTax());
//                //把统计数据汇总到母版数据上
//                for (SettlementCenterBudgetFeeEntity dcFeeEntity : dcFeeEntities) {
//                    if (dcFeeEntity.getParentId().equals(feeVo.getId())) {
//                        feeVo.setSettlementCenterFeeMny(dcFeeEntity.getSettlementCenterFeeMny() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeMny());
//                        feeVo.setSettlementCenterFeeNum(dcFeeEntity.getSettlementCenterFeeNum() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeNum());
//                        feeVo.setSettlementCenterFeeTax(dcFeeEntity.getSettlementCenterFeeTax() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeTax());
//                        feeVo.setSettlementCenterFeeTaxMny(dcFeeEntity.getSettlementCenterFeeTaxMny() == null ? BigDecimal.ZERO : dcFeeEntity.getSettlementCenterFeeTaxMny());
//                        if (StringUtils.isNotEmpty(dcFeeEntity.getFeeMemo())){
//                            feeVo.setFeeMemo(dcFeeEntity.getFeeMemo());
//                        }
//                        totalOutput = totalOutput.add(feeVo.getSettlementCenterFeeTaxMny());
//                    }
//                }
//
//                //把累计产值数据汇总到母版数据上
//                for (SettlementCenterUserProjectDetailEntity detailEntity : userProjectDetailEntities) {
//                    if (feeVo.getId().equals(detailEntity.getSourceId())){
//                        settlementCenterMnyTotal = settlementCenterMnyTotal.add(detailEntity.getSettlementCenterFeeMny());
//                        settlementCenterTaxMnyTotal = settlementCenterTaxMnyTotal.add(detailEntity.getSettlementCenterFeeTaxMny());
//                        settlementCenterTaxTotal = settlementCenterTaxTotal.add(detailEntity.getSettlementCenterFeeTax());
//                        settlementCenterNumTotal = settlementCenterNumTotal.add(detailEntity.getSettlementCenterFeeNum());
//                    }
//                }
//                feeVo.setSettlementCenterFeeMnyTotal(settlementCenterMnyTotal);
//                feeVo.setSettlementCenterFeeNumTotal(settlementCenterNumTotal);
//                feeVo.setSettlementCenterFeeTaxTotal(settlementCenterTaxTotal);
//                feeVo.setSettlementCenterFeeTaxMnyTotal(settlementCenterTaxMnyTotal);
//            }
//            vo.setFeeTotalMny(totalMny);
//            vo.setFeeTotalTaxMny(totalTaxMny);
//            vo.setFeeTotalTax(totalTax);
//            vo.setFeeTotalOutput(totalOutput);
//            List<Map> feeMap = BeanMapper.mapList(feeVos, Map.class);
//            for (Map map : feeMap) {
//                map.remove("createUserName");
//            }
//            List<Map<String, Object>> mapList = ResultAsTree.createTreeData(feeMap);
//            feeVos = BeanMapper.mapList(mapList, SettlementCenterBudgetFeeVO.class);
//            vo.setFeeVOS(feeVos);
//        }
//        return CommonResponse.success("查询详情数据成功！", vo);
//    }

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
        SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = service.selectById(id);
        SettlementCenterDcDrwgrpInfoVO vo = BeanMapper.map(drwgrpInfoEntity, SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDcDrwgrpInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterDcDrwgrpInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterDcDrwgrpInfoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
        fuzzyFields.add("dcDrwgrpInfoName");
//        fuzzyFields.add("firstNodeUserName");
//        fuzzyFields.add("secondNodeUserName");
        fuzzyFields.add("thirdNodeUserName");//统计人
//        fuzzyFields.add("fourthNodeUserName");
//        fuzzyFields.add("fifthNodeUserName");
//        fuzzyFields.add("sixthNodeUserName");
//        fuzzyFields.add("seventhNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.SQL,
                            "(" +
                                    "first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') " +
                                    ")")
            );
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        if (param.getParams().get("orgId") != null) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//            String authOrgIds = userContextCache.getAuthOrgIds();
            String authOrgIds = param.getParams().get("orgId").getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }

            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        CommonResponse<List<DefdocDetailVO>> defdoc = iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        List<Long> list = defdoc.getData().stream().filter(a -> a.getName().equals(SettleDrawTypeEnum.N.getName()) || a.getName().equals(SettleDrawTypeEnum.OTHER.getName()))
                .map(DefdocDetailVO::getId).collect(Collectors.toList());
        String ids = StringUtils.join(",");

        Map<String, Parameter> params = param.getParams();
        if (params.get("endTime") != null){
            String endTime = params.get("endTime").getValue().toString();
            String[] split = endTime.split(",");
            params.remove("endTime");
            Parameter parameter = new Parameter();
            parameter.setValue(
                    "  ( (discriminate_state in ("+ids+") and date_format(fifth_node_time,'%Y-%m-%d') >= "+split[0]+" and date_format(fifth_node_time,'%Y-%m-%d') <= "+split[1]+") "+
                            "or (discriminate_state not in ("+ids+") and date_format(eighth_node_time,'%Y-%m-%d') >= "+split[0]+" and date_format(eighth_node_time,'%Y-%m-%d') <= "+split[1]+")  )"
            );
            parameter.setType(QueryParam.SQL);
            params.put("endTime",parameter);
        }



        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param, false);
        long total = numMapper.queryTotalNum(null, departmentIds, commonOrgIds,null);
        param.getParams().put("flowState", new Parameter(QueryParam.IN, Arrays.asList(SettleFlowStateEnum.NINE.getCode(),SettleFlowStateEnum.TWO.getCode())));
        param.setPageSize(1);
        IPage<SettlementCenterDcDrwgrpInfoEntity> finishPage = service.queryPage(param, false);
        long finishTotal = finishPage.getTotal();


        //项目到图数
        Parameter parentOrgId = param.getParams().get("parentOrgId");
        Parameter orgId = param.getParams().get("orgId");
        param.getParams().clear();
        if (parentOrgId != null) {
            param.getParams().put("parentOrgId", parentOrgId);
        }
        if (orgId != null) {
            param.getParams().put("orgId", orgId);
        }
        IPage<SettlementCenterDcDrwgrpInfoEntity> needPage = service.queryPage(param);
        long needTotal = needPage.getTotal();

        int alterTotal = alertInfoService.count(
                new QueryWrapper<SettlementCenterAlertInfoEntity>().lambda()
                        .eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, userid)
                        .eq(SettlementCenterAlertInfoEntity::getClearFlag, 0)
        );

        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        for (SettlementCenterDcDrwgrpInfoVO record : pageData.getRecords()) {
            record.setTotal(total);
            record.setFinishTotal(finishTotal);
            record.setNeedTotal(needTotal);
            record.setAlterTotal(alterTotal);
            if (total != 0) {
                record.setPercentage((finishTotal + 0.00) / total);
            } else {
                record.setPercentage(100.00);
            }
        }

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
//        fuzzyFields.add("firstNodeUserName");
//        fuzzyFields.add("secondNodeUserName");
        fuzzyFields.add("thirdNodeUserName");//统计人
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.SQL,
                            "(" +
                                    "first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') " +
                                    ")")
            );
        }
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("orgId") != null) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//            String authOrgIds = userContextCache.getAuthOrgIds();
            String authOrgIds = param.getParams().get("orgId").getValue().toString();
            param.getParams().remove("orgId");
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        List<SettlementCenterDcDrwgrpInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDcDrwgrpInfo-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterDcDrwgrpInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> refSettlementCenterDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                     String condition,
                                                                                                     String searchObject,
                                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            logger.info("refSettlementCenterDcDrwgrpInfoData-condition:"+condition);
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (StringUtils.isNotBlank(_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, Long.parseLong(_con.getString("projectId"))));
            }
            if (StringUtils.isNotBlank(_con.getString("contractId"))) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, Long.parseLong(_con.getString("contractId"))));
            }
            if (StringUtils.isNotBlank(_con.getString("flowState"))) {
                param.getParams().put("flowState", new Parameter(QueryParam.IN, Arrays.asList(_con.getString("flowState").split(","))));
            }
            if (StringUtils.isNotBlank(_con.getString("major"))) {
                String[] majors = _con.getString("major").split(",");
                for (String major : majors) {
                    param.getParams().put("settlementCenterMajor", new Parameter(QueryParam.LIKE, major));
                }
            }
        }

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = service.queryPage(param, false);
        IPage<SettlementCenterDcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/deleteForDrwgrp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteForDrwgrp(@RequestBody List<Long> dcDrwgrpId) {
        List<SettlementCenterDcDrwgrpInfoEntity> list = service.list(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .in(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, dcDrwgrpId)
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );
        List<Long> idList = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        service.removeByIds(idList);
        detailService.remove(
                new QueryWrapper<SettlementCenterOutputDetailEntity>().lambda()
                        .in(SettlementCenterOutputDetailEntity::getPid,idList)
                        .eq(SettlementCenterOutputDetailEntity::getDr,0)
        );
        alertInfoService.remove(
                new QueryWrapper<SettlementCenterAlertInfoEntity>().lambda()
                        .in(SettlementCenterAlertInfoEntity::getInfoId,idList)

        );
//        userProjectDetailService.remove(
//                new UpdateWrapper<SettlementCenterUserProjectDetailEntity>().lambda()
//                        .in(SettlementCenterUserProjectDetailEntity::getDcDrwgrpInfo,idList)
//        );
//        feeService.remove(
//                new UpdateWrapper<SettlementCenterBudgetFeeEntity>().lambda()
//                        .in(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo,idList)
//        );
//        measureService.remove(
//                new UpdateWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
//                        .in(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo,idList)
//        );
//        otherService.remove(
//                new UpdateWrapper<SettlementCenterBudgetOtherEntity>().lambda()
//                        .in(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo,idList)
//        );
//        subService.remove(
//                new UpdateWrapper<SettlementCenterBudgetSubEntity>().lambda()
//                        .in(SettlementCenterBudgetSubEntity::getDcDrwgrpInfo,idList)
//        );

        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/addDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse addDetailData(){

        List<SettlementCenterDcDrwgrpInfoVO> infoVOS = service.queryNeedAddDetailData();
        for (SettlementCenterDcDrwgrpInfoVO infoVO : infoVOS) {
            String major = infoVO.getSettlementCenterMajor();
            if (major != null && major.contains(",")){
                /*String[] split = major.split(",");
                for (String s : split) {
                    SettlementCenterOutputDetailEntity entity = new SettlementCenterOutputDetailEntity();
                    entity.setDcDrwgrpInfoCode(infoVO.getDcDrwgrpInfoCode());
                    entity.setDrwgrpVsn(infoVO.getDrwgrpVsn());
                    entity.setDcDrwgrpInfoName(infoVO.getDcDrwgrpInfoName());
                    entity.setOrgCode(infoVO.getOrgCode());
                    entity.setOrgId(infoVO.getOrgId());
                    entity.setOrgName(infoVO.getOrgName());
                    entity.setEquipmentCost(infoVO.getEquipmentCost());
                    entity.setInstallationCost(infoVO.getInstallationCost());
                    entity.setMaterialCost(infoVO.getMaterialCost());
                    entity.setParentOrgCode(infoVO.getParentOrgCode());
                    entity.setParentOrgId(infoVO.getParentOrgId());
                    entity.setParentOrgName(infoVO.getParentOrgName());
                    entity.setPid(infoVO.getId());
                    entity.setProjectCode(infoVO.getProjectCode());
                    entity.setProjectId(infoVO.getProjectId());
                    entity.setProjectName(infoVO.getProjectName());
                    entity.setSettlementCenterMajor(Long.valueOf(s));
//                    entity.setSettlementCenterMajorName(infoVO.getSettlementCenterMajorName());
                    entity.setStatisticalOutput(infoVO.getStatisticalOutput());
                    entity.setUserName(infoVO.getThirdNodeUserName());
                    entity.setUserId(Long.valueOf(infoVO.getThirdNodeUserId()));
                    detailService.save(entity);
                }*/
            }else {
                SettlementCenterOutputDetailEntity entity = new SettlementCenterOutputDetailEntity();
                entity.setDcDrwgrpInfoCode(infoVO.getDcDrwgrpInfoCode());
                entity.setDrwgrpVsn(infoVO.getDrwgrpVsn());
                entity.setDcDrwgrpInfoName(infoVO.getDcDrwgrpInfoName());
                entity.setOrgCode(infoVO.getOrgCode());
                entity.setOrgId(infoVO.getOrgId());
                entity.setOrgName(infoVO.getOrgName());
                entity.setEquipmentCost(infoVO.getEquipmentCost());
                entity.setInstallationCost(infoVO.getInstallationCost());
                entity.setMaterialCost(infoVO.getMaterialCost());
                entity.setParentOrgCode(infoVO.getParentOrgCode());
                entity.setParentOrgId(infoVO.getParentOrgId());
                entity.setParentOrgName(infoVO.getParentOrgName());
                entity.setPid(infoVO.getId());
                entity.setProjectCode(infoVO.getProjectCode());
                entity.setProjectId(infoVO.getProjectId());
                entity.setProjectName(infoVO.getProjectName());
                entity.setSettlementCenterMajor(Long.valueOf(infoVO.getSettlementCenterMajor()));
                entity.setSettlementCenterMajorName(infoVO.getSettlementCenterMajorName());
                entity.setStatisticalOutput(infoVO.getStatisticalOutput());
                entity.setUserName(infoVO.getThirdNodeUserName());
                entity.setUserId(Long.valueOf(infoVO.getThirdNodeUserId()));
                detailService.save(entity);
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value = "/querySystemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse querySystemData(Long systemId){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<SettlementCenterDcDrwgrpInfoEntity> list = service.list(
                new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId, systemId)
                        .in(SettlementCenterDcDrwgrpInfoEntity::getBillState, Arrays.asList(1, 3))
                        .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
        );
        Date startDate = null;//第一册卷册的统计时间
        Date endDate = null;//最后卷册的统计完成时间
        CommonResponse<List<DefdocDetailVO>> defdoc = iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        BigDecimal total = new BigDecimal(0);
        List<Long> statisticPerson = new ArrayList<>();
        for (SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity : list) {
            Long discriminateState = drwgrpInfoEntity.getDiscriminateState();
            String defdocDetailName = defdoc.getData().stream().filter(a -> a.getId().equals(discriminateState)).map(DefdocDetailVO::getName).findFirst().orElse(null);

            if (SettleDrawTypeEnum.N.getName().equals(defdocDetailName)) {
                if (endDate == null || (drwgrpInfoEntity.getEighthNodeTime() != null && endDate.before(drwgrpInfoEntity.getEighthNodeTime()))) {
                    endDate = drwgrpInfoEntity.getEighthNodeTime();
                }
            }else {
                if (endDate == null || (drwgrpInfoEntity.getFifthNodeTime() != null && endDate.before(drwgrpInfoEntity.getFifthNodeTime()))) {
                    endDate = drwgrpInfoEntity.getFifthNodeTime();
                }
            }

            if (startDate == null || (drwgrpInfoEntity.getThirdNodeTime() != null && startDate.after(drwgrpInfoEntity.getThirdNodeTime()))){
                startDate = drwgrpInfoEntity.getThirdNodeTime();
            }

            if (drwgrpInfoEntity.getStatisticalOutput() != null){
                total = total.add(drwgrpInfoEntity.getStatisticalOutput());
            }

            String thirdNodeUserId = drwgrpInfoEntity.getThirdNodeUserId();
            if (thirdNodeUserId != null){
                String[] split = thirdNodeUserId.split(",");
                for (int i = 0; i < split.length; i++) {
                    String s = split[i];
                    Long l = Long.valueOf(s);
                    if (statisticPerson.contains(l)){
                        continue;
                    }
                    statisticPerson.add(l);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (startDate != null){
            String format = sdf.format(startDate);
            jsonObject.put("startDate",format);
        }else {
            jsonObject.put("startDate",null);
        }
        if (endDate != null){
            String format = sdf.format(endDate);
            jsonObject.put("endDate",format);
        }else {
            jsonObject.put("endDate",null);
        }
        jsonObject.put("total",total);
        if (statisticPerson.size() > 0) {
            CommonResponse<List<EmployeeVO>> response = employeeApi.getByIds(statisticPerson);
            if (response.isSuccess()){
                jsonObject.put("userList",response.getData());
            }else {
                logger.info("获取人员错误:"+response.getMsg()+"      参数:"+statisticPerson);
                jsonObject.put("userList",new ArrayList<>());
            }
        }else {
            jsonObject.put("userList",new ArrayList<>());
        }

        return CommonResponse.success(jsonObject);
    }

    @RequestMapping(value = "/batchSubmit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> batchSubmit(@RequestBody BatchSubmitVO vo) {
        if (vo == null || ListUtil.isEmpty(vo.getDetailList()) || StringUtils.isEmpty(vo.getBillTypeCode())) {
            return CommonResponse.error("批量提交失败！参数错误");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                Map<String, Object> submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", baseHost + "/settle/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "图纸工程量管理" + detail.getId() + DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse<String> result = iBpmApi.doSubmit(submitParam);
                if (!result.isSuccess()) {
                    return CommonResponse.error(result.getMsg());
                }
            }
            return CommonResponse.success("批量提交成功！");
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("批量提交失败！错误信息：", e);
            }
            return CommonResponse.error("批量提交失败！");
        }
    }
}
