package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * 结算中心卷册信息表
 *
 * @author generator
 */
@Service("settlementCenterDcDrwgrpInfoService")
public class SettlementCenterDcDrwgrpInfoServiceImpl extends BaseServiceImpl<SettlementCenterDcDrwgrpInfoMapper, SettlementCenterDcDrwgrpInfoEntity> implements ISettlementCenterDcDrwgrpInfoService {


    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;



    @Override
    public List<Map> getRankingListForYear(Long major,List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.getRankingListForYear(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getRankingListForMonth(Long major,List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.getRankingListForMonth(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getRankingListWithOrder(Long major,List<Long> departmentIds,List<Long> commonOrgIds,String order){
        return infoMapper.getRankingListWithOrder(major,departmentIds,commonOrgIds,order);
    }

    @Override
    public List<Map> getProjectLedgerList(String order) {
        return infoMapper.getProjectLedgerList(order);
    }

    @Override
    public List<Map> getMajorLedgerList(String order) {
        return infoMapper.getMajorLedgerList(order);
    }

    @Override
    public List<Map> getProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds,Integer pageStart, Integer pageSize) {
        return infoMapper.getProjectStatisticsLedgerList(projectIds,departmentIds,commonOrgIds,pageStart,pageSize);
    }

    @Override
    public Integer countProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds) {
        return infoMapper.countProjectStatisticsLedgerList(projectIds,departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> queryAllProject(List<Long> departmentIds,List<Long> commonOrgIds) {
        return infoMapper.queryAllProject(departmentIds,commonOrgIds);
    }

    @Override
    public List<Map> getMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds,Integer pageStart, Integer pageSize) {
        return infoMapper.getMajorStatisticsLedgerList(major,departmentIds,commonOrgIds,pageStart,pageSize);
    }

    @Override
    public Integer countMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return infoMapper.countMajorStatisticsLedgerList(major,departmentIds,commonOrgIds);
    }

    @Override
    public List<SettlementCenterDcDrwgrpInfoVO> queryNeedAddDetailData() {
        return infoMapper.queryNeedAddDetailData();
    }
}
