package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleDrawTypeEnum;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.mapper.SettlementCenterProjectDrwgrpNumMapper;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.jacoco.agent.rt.internal_035b120.core.internal.flow.IFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("projectStatistics")
public class ProjectStatisticsController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private SettlementCenterProjectDrwgrpNumMapper numMapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value = "/statisticalData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse statisticalData(String projectId) {
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> resultMap = new HashMap<>();
        if (commonOrgIds.size() == 0 && (projectId == null || projectId.equals(""))) {

            BigDecimal sumOutput = new BigDecimal(0);


            resultMap.put("needStatistCount", 0);//需统计卷册份数
            resultMap.put("finishCount", 0);//已完成统计卷册份数
            //卷册统计完成率
            resultMap.put("finishRate", 1);

            resultMap.put("sumOutput", sumOutput);//累计完成统计产值
            resultMap.put("monthOutput",new BigDecimal(0));//本月累计完成统计产值
            resultMap.put("yearOutput",new BigDecimal(0));//本年累计完成统计产值
            resultMap.put("contractMny",new BigDecimal(0));//合同金额
            resultMap.put("replyMny",new BigDecimal(0));//批复金额
            resultMap.put("allCount",new BigDecimal(0));//所有卷册份数
            resultMap.put("totalNum",0);//项目总卷册数
            return CommonResponse.success(resultMap);
        }

        CommonResponse<List<DefdocDetailVO>> defdoc = iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        Long defdocDetailId = defdoc.getData().stream().filter(a -> a.getName().equals(SettleDrawTypeEnum.N.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
        if (defdocDetailId == null){
            return CommonResponse.error("自定义档案错误");
        }
        int needStatistCount = 0;//需要统计份数
        int finishCount = 0;//完成统计份数
        int allCount = 0;//所有卷册份数
        int unDoneCount = 0;//未完成份数
        long num = 0L;//总卷册数
        BigDecimal sumOutput = new BigDecimal(0);
        BigDecimal monthOutput = new BigDecimal(0);
        BigDecimal yearOutput = new BigDecimal(0);
        BigDecimal contractMny = new BigDecimal(0);
        BigDecimal replyMny = new BigDecimal(0);
        if (projectId == null || projectId.equals("")) {
            needStatistCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDiscriminateState, defdocDetailId)
//                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds)
            );

            finishCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                            .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
//                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds)
            );


            allCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
//                        .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectId)
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getParentOrgId, commonOrgIds)
            );
            Map<String, BigDecimal> map = infoMapper.selectSumOutput(null,commonOrgIds);
            num = numMapper.queryTotalNum(null, null, commonOrgIds,null);

            if (map != null){
                sumOutput = map.get("sumOutput");
                yearOutput = map.get("yearOutput");
                monthOutput = map.get("monthOutput");
            }

            Map<String, BigDecimal> queryContractMny = infoMapper.queryContractMny(null, commonOrgIds);
            logger.info("查询的合同金额数据为:"+(queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
            if (queryContractMny != null){
                contractMny = queryContractMny.get("contractMny");
                replyMny = queryContractMny.get("replyMny");
            }
        }else {
            List<String> projectIds = Arrays.asList(projectId.split(","));
            needStatistCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDiscriminateState, defdocDetailId)
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectIds)
            );

            finishCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                            .in(SettlementCenterDcDrwgrpInfoEntity::getFlowState, Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode()))
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectIds)
            );


            allCount = dcDrwgrpInfoService.count(
                    new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                            .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                            .in(SettlementCenterDcDrwgrpInfoEntity::getProjectId, projectIds)
            );
            num = numMapper.queryTotalNum(projectIds, null, null,null);
            Map<String, BigDecimal> map = infoMapper.selectSumOutput(projectIds,null);

            if (map != null){
                sumOutput = map.get("sumOutput");
                monthOutput = map.get("monthOutput");
                yearOutput = map.get("yearOutput");
            }
            Map<String, BigDecimal> queryContractMny = infoMapper.queryContractMny(projectIds, null);
            logger.info("查询的合同金额数据为:"+(queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
            if (queryContractMny != null){
                contractMny = queryContractMny.get("contractMny");
                replyMny = queryContractMny.get("replyMny");
            }
        }



        resultMap.put("needStatistCount",needStatistCount);//需统计卷册份数
        resultMap.put("finishCount",finishCount);//已完成统计卷册份数
        resultMap.put("allCount",allCount);//所有卷册份数
        //卷册统计完成率
        if (allCount != 0) {
            resultMap.put("finishRate", (finishCount + 0.00) / allCount);
        }else {
            resultMap.put("finishRate", 1);
        }
        resultMap.put("contractMny",contractMny);//合同金额
        resultMap.put("replyMny",replyMny);//批复金额
        resultMap.put("sumOutput",sumOutput);//累计完成统计产值
        resultMap.put("monthOutput",monthOutput);//本月累计完成统计产值
        resultMap.put("yearOutput",yearOutput);//本年累计完成统计产值
        resultMap.put("totalNum",num);//项目总卷册数
        return CommonResponse.success(resultMap);
    }

    /**
     * @Description 项目工程量统计一览表- 工作任务完成情况清单 -未完成
     * @Return
     */
    @RequestMapping(value = "/queryProjectJobUndoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobUndoneList(Long projectId, Integer pageNum, Integer pageSize) {
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });

        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNum);
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.EQ, 0));
        }

        IPage<SettlementCenterDcDrwgrpInfoEntity> page = dcDrwgrpInfoService.queryPage(queryParam);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Description 项目工程量统计一览表- 工作任务完成情况清单 -已完成
     * @Return
     */
    @RequestMapping(value = "/queryProjectJobDoneList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoEntity>> queryProjectJobDoneList(Long projectId, Integer pageNum, Integer pageSize) {
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });


        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNum);
        queryParam.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.EQ, 0));
        }
        IPage<SettlementCenterDcDrwgrpInfoEntity> page = dcDrwgrpInfoService.queryPage(queryParam);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param
     * @Description 工作任务完成情况清单导出(未完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportUndone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportUndone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> beans = new HashMap<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.NINE.getCode()));
        queryParam.getParams().put("flowState",new Parameter(QueryParam.NE, SettleFlowStateEnum.TWO.getCode()));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.EQ, 0));
        }
        List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.queryList(queryParam);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 工作任务完成情况清单导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportDone", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDone(Long projectId, HttpServletResponse response, Integer pageNum, Integer pageSize) {
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        Map<String, Object> beans = new HashMap<>();

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("flowState",new Parameter(QueryParam.SQL, "(flow_state = 9 or flow_state = 2)"));
        if (projectId != null) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if (commonOrgIds.size() > 0) {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.EQ, 0));
        }
        List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.queryList(queryParam);

        beans.put("records", list);
        ExcelExport.getInstance().export("TaskCompletedByYear-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description
     * @Return
     */
    @RequestMapping(value = "/queryProjectLedgerList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryProjectLedgerList(String projectId, Integer pageNum, Integer pageSize) {
        Map resultMap = new HashMap();
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });

        int pageStart = pageSize * (pageNum - 1);//分页开始坐标
        List<Map> projectStatisticsLedgerList = new ArrayList<>();
        int total = 0;
        if (projectId != null && !projectId.equals("")) {
            List<String> projectIds = Arrays.asList(projectId.split(","));
            projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(projectIds, null, null,pageStart,pageSize);
            total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(projectIds,null,null);
        }else {
            if (commonOrgIds.size() > 0) {
                projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(null, null, commonOrgIds, pageStart, pageSize);
                total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(null, null, commonOrgIds);
            }else {
                projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(null, null, Arrays.asList(0L), pageStart, pageSize);
                total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(null, null, Arrays.asList(0L));
            }
        }

        //将合同金额组合进返回数据中
        Map<String, BigDecimal> map1 = new HashMap<>();
        for (Map map : projectStatisticsLedgerList) {
            String project_id = map.get("project_id").toString();
            BigDecimal bigDecimal = map1.get(project_id);
            if (bigDecimal == null){
                Map<String, BigDecimal> map2 = infoMapper.selectSumOutput(Arrays.asList(project_id), null);
                if (map2 != null){
                    BigDecimal contractMny = map2.get("contractMny");
                    if (contractMny == null){
                        map1.put(project_id,contractMny);
                        map.put("contract_mny",contractMny);
                    }else {
                        map1.put(project_id,BigDecimal.ZERO);
                        map.put("contract_mny",BigDecimal.ZERO);
                    }

                }
            }else {
                map.put("contract_mny",bigDecimal);
            }
        }

        resultMap.put("records",projectStatisticsLedgerList);
        resultMap.put("pages",total % pageSize > 0 ? total/pageSize + 1:total/pageSize);
        resultMap.put("size",pageSize);
        resultMap.put("total",total);
        resultMap.put("current",pageNum);

        return CommonResponse.success("查询列表数据成功！",resultMap);
    }

    @RequestMapping(value = "/queryAllProject",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryProjectLedgerList() {
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        List<Map> allProject = new ArrayList<>();
        if (commonOrgIds.size() > 0){
            allProject = dcDrwgrpInfoService.queryAllProject(null,commonOrgIds);
        }else {
            allProject = dcDrwgrpInfoService.queryAllProject(departmentIds,null);
        }
        if (allProject == null){
            allProject = new ArrayList<>();
        }
        return CommonResponse.success(allProject);
    }

    /**
     * @param
     * @Description 统计台账导出(已完成清单)
     * @Return
     */
    @RequestMapping(value = "/excelExportProjectLedger", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportProjectLedger(String projectId, Integer pageNum, Integer pageSize, HttpServletResponse response) {
        Map resultMap = new HashMap();
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });

        int pageStart = pageSize * (pageNum - 1);//分页开始坐标
        List<Map> projectStatisticsLedgerList = new ArrayList<>();
        int total = 0;
        if (projectId != null && !projectId.equals("")) {
            List<String> projectIds = Arrays.asList(projectId.split(","));
            projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(projectIds, null, null,pageStart,pageSize);
            total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(projectIds,null,null);
        }else {
            if (commonOrgIds.size() > 0) {
                projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(null, null, commonOrgIds, pageStart, pageSize);
                total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(null, null, commonOrgIds);
            }else {
                projectStatisticsLedgerList = dcDrwgrpInfoService.getProjectStatisticsLedgerList(null, null, Arrays.asList(0L), pageStart, pageSize);
                total = dcDrwgrpInfoService.countProjectStatisticsLedgerList(null, null, Arrays.asList(0L));
            }
        }

        //将合同金额组合进返回数据中
        Map<String, BigDecimal> map1 = new HashMap<>();
        for (Map map : projectStatisticsLedgerList) {
            String project_id = map.get("project_id").toString();
            BigDecimal bigDecimal = map1.get(project_id);
            if (bigDecimal == null){
                Map<String, BigDecimal> map2 = infoMapper.selectSumOutput(Arrays.asList(project_id), null);
                if (map2 != null){
                    BigDecimal contractMny = map2.get("contractMny");
                    if (contractMny == null){
                        map1.put(project_id,contractMny);
                        map.put("contract_mny",contractMny);
                    }else {
                        map1.put(project_id,BigDecimal.ZERO);
                        map.put("contract_mny",BigDecimal.ZERO);
                    }

                }
            }else {
                map.put("contract_mny",bigDecimal);
            }
        }

        for (Map map : projectStatisticsLedgerList) {
            Object total_amount = map.get("total_amount");
            if (total_amount != null){
                BigDecimal totalAmount = new BigDecimal(total_amount.toString()).divide(new BigDecimal(10000),2, RoundingMode.HALF_UP);
                map.put("total_amount",totalAmount);
            }
            Object year_total_amount = map.get("year_total_amount");
            if (year_total_amount != null){
                BigDecimal yearTotalAmount = new BigDecimal(year_total_amount.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("year_total_amount",yearTotalAmount);
            }
            Object month_total_amount = map.get("month_total_amount");
            if (month_total_amount != null){
                BigDecimal monthTotalAmount = new BigDecimal(month_total_amount.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("month_total_amount",monthTotalAmount);
            }
            Object total_material_cost = map.get("total_material_cost");
            if (total_material_cost != null){
                BigDecimal totalMaterialCost = new BigDecimal(total_material_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_material_cost",totalMaterialCost);
            }
            Object total_equipment_cost = map.get("total_equipment_cost");
            if (total_equipment_cost != null){
                BigDecimal totalEquipmentCost = new BigDecimal(total_equipment_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_equipment_cost",totalEquipmentCost);
            }
            Object total_installation_cost = map.get("total_installation_cost");
            if (total_installation_cost != null){
                BigDecimal totalInstallationCost = new BigDecimal(total_installation_cost.toString()).divide(new BigDecimal(10000),2,RoundingMode.HALF_UP);
                map.put("total_installation_cost",totalInstallationCost);
            }
        }

        resultMap.put("records",projectStatisticsLedgerList);

        ExcelExport.getInstance().export("ProjectOutputDetail-export.xlsx", resultMap, response);
    }


    @RequestMapping(value = "/reportProcess",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> reportProcess(String projectId){
        String orgId = ""+InvocationInfoProxy.getOrgId();
        List<OrgVO> orgVOList =  (List<OrgVO>) getRespData(iOrgApi.findAllByIds(Arrays.stream(orgId.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");

        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (3 == org.getOrgType()) {
                commonOrgIds.add(org.getId());
            }
        });
        Map<String,List<Map<String,Object>>> result = new HashMap<>();
        List<Map<String,Object>> outputMonth = new ArrayList<>();
        List<Map<String,Object>> replyMonth = new ArrayList<>();
        BigDecimal contractMny = new BigDecimal(0);
        if (projectId != null && !projectId.equals("")) {
            List<String> projectIds = Arrays.asList(projectId.split(","));
            outputMonth = infoMapper.selectOutputEveryMonth(projectIds,null,null);
            replyMonth = infoMapper.selectReplyEveryMonth(projectIds,null,null);
            Map<String, BigDecimal> queryContractMny = infoMapper.queryContractMny(projectIds, null);
            logger.info("查询的合同金额数据为:"+(queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
            if (queryContractMny != null){
                contractMny = queryContractMny.get("contractMny");

            }
        }else {
            if (commonOrgIds.size() > 0) {
                outputMonth = infoMapper.selectOutputEveryMonth(null, null, commonOrgIds);
                replyMonth = infoMapper.selectReplyEveryMonth(null, null, commonOrgIds);
                Map<String, BigDecimal> queryContractMny = infoMapper.queryContractMny(null, commonOrgIds);
                logger.info("查询的合同金额数据为:"+(queryContractMny == null ? "null" : JSON.toJSONString(queryContractMny)));
                if (queryContractMny != null){
                    contractMny = queryContractMny.get("contractMny");
                }
            }else {
                outputMonth = infoMapper.selectOutputEveryMonth(null, null, Arrays.asList(0L));
                replyMonth = infoMapper.selectReplyEveryMonth(null, null, Arrays.asList(0L));
            }
        }
        if (contractMny.equals(BigDecimal.ZERO)){
            for (Map<String, Object> map : outputMonth) {
                map.put("contractMny",BigDecimal.ZERO.toString());
                map.put("rate",BigDecimal.ONE.toString());
            }
            for (Map<String, Object> map : replyMonth) {
                map.put("contractMny",BigDecimal.ZERO.toString());
                map.put("rate",BigDecimal.ONE.toString());
            }
        }else {
            for (Map<String, Object> map : outputMonth) {
                Object o = map.get("totalOutput");
                map.put("contractMny",contractMny.toString());
                if (o != null){
                    map.put("rate",(new BigDecimal(o.toString()).divide(contractMny,4,RoundingMode.HALF_UP)).toString());
                }
            }
            for (Map<String, Object> map : replyMonth) {
                Object o = map.get("totalReply");
                map.put("contractMny",contractMny.toString());
                if (o != null){
                    map.put("rate",(new BigDecimal(o.toString()).divide(contractMny,4,RoundingMode.HALF_UP)).toString());
                }
            }
        }
        result.put("output",outputMonth);
        result.put("reply",replyMonth);

        return CommonResponse.success(result);

    }

}
