package com.ejianc.business.settle.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterCompareDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterCompareEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpVO;
import com.ejianc.business.settle.service.ISettlementCenterCompareDetailService;
import com.ejianc.business.settle.service.ISettlementCenterCompareService;
import com.ejianc.business.settle.vo.SettlementCenterCompareDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.service.ISettlementCenterSystemDrwgrpService;


/**
 * 结算中心系统产值表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlementCenterSystemDrwgrp")
public class SettlementCenterSystemDrwgrpController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISettlementCenterSystemDrwgrpService service;
    @Autowired
    private ISettlementCenterCompareService compareService;
    @Autowired
    private ISettlementCenterCompareDetailService compareDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterSystemDrwgrpVO> saveOrUpdate(@RequestBody SettlementCenterSystemDrwgrpVO saveOrUpdateVO) {
    	SettlementCenterSystemDrwgrpEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterSystemDrwgrpEntity.class);

    	service.saveOrUpdate(entity, false);
        SettlementCenterSystemDrwgrpEntity e = service.selectById(entity.getId());
    	SettlementCenterSystemDrwgrpVO vo = BeanMapper.map(e, SettlementCenterSystemDrwgrpVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterSystemDrwgrpVO> queryDetail(Long id) {
    	SettlementCenterSystemDrwgrpEntity entity = service.selectById(id);
    	SettlementCenterSystemDrwgrpVO vo = BeanMapper.map(entity, SettlementCenterSystemDrwgrpVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterSystemDrwgrpVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SettlementCenterSystemDrwgrpVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterSystemDrwgrpVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterSystemDrwgrpVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        CommonResponse<List<RoleVO>> roles = roleApi.queryRoleByNameAndCode("结算中心综合管理员", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && roles.getData().size() > 0) {
            RoleVO roleVO = roles.getData().get(0);
            CommonResponse<List<RoleVO>> userRoles = roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && userRoles.getData().size() > 0) {
                for (RoleVO role : userRoles.getData()) {
                    if (role.getId().equals(roleVO.getId())) {
                        flag = true;
                    }
                }
            }
        }

        if (!flag) {
            param.getParams().put("thirdNodeUserId",
                    new Parameter(
                            QueryParam.SQL,
                            "(" +
                                    "third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or " +
                                    "seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') " +
                                    ")")
            );
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementCenterSystemDrwgrpEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterSystemDrwgrpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterSystemDrwgrpVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementCenterSystemDrwgrpEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterSystemDrwgrp-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterSystemDrwgrpData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterSystemDrwgrpVO>> refSettlementCenterSystemDrwgrpData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementCenterSystemDrwgrpEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterSystemDrwgrpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterSystemDrwgrpVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/exportNumDetail")
    @ResponseBody
     public void exportNumDetail(String systemName, HttpServletResponse response) {
        SettlementCenterCompareEntity one = compareService.getOne(
                new QueryWrapper<SettlementCenterCompareEntity>().lambda()
                        .eq(SettlementCenterCompareEntity::getSystemName, systemName)
                        .eq(SettlementCenterCompareEntity::getDr, BaseVO.DR_UNDELETE)
                        .last(" limit 0,1 ")
        );
        List<SettlementCenterCompareDetailEntity> list = new ArrayList<>();
        if (one != null){
            list = compareDetailService.list(
                    new QueryWrapper<SettlementCenterCompareDetailEntity>().lambda()
                            .eq(SettlementCenterCompareDetailEntity::getPid, one.getId())
                            .eq(SettlementCenterCompareDetailEntity::getDr, BaseVO.DR_UNDELETE)
            );
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterSystemNumDetail-export.xlsx", beans, response);
     }

     @RequestMapping(value = "/numDetailImport")
     @ResponseBody
     public CommonResponse<JSONObject> numDetailImport(HttpServletRequest request, HttpServletResponse response){
         return service.numDetailImport(request,response);
     }

}
