/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanEntity;
import com.ejianc.business.settle.bean.SettlementCenterOutputDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.enums.SettleDrawTypeEnum;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterProjectDrwgrpNumMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanDetailService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanService;
import com.ejianc.business.settle.service.ISettlementCenterOutputDetailService;
import com.ejianc.business.settle.service.ISettlementCenterProjectMajorService;
import com.ejianc.business.settle.service.ISettlementCenterSystemDrwgrpService;
import com.ejianc.business.settle.vo.BatchSubmitVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlementCenterDcDrwgrpInfo"})
public class SettlementCenterDcDrwgrpInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService service;
    @Autowired
    private ISettlementCenterDrawPlanService drawPlanService;
    @Autowired
    private ISettlementCenterDrawPlanDetailService drawPlanDetailService;
    @Autowired
    private ISettlementCenterSystemDrwgrpService systemDrwgrpService;
    @Autowired
    private ISettlementCenterProjectMajorService projectMajorService;
    @Autowired
    private IBpmApi iBpmApi;
    @Autowired
    private ISettlementCenterAlertInfoService alertInfoService;
    @Autowired
    private ISettlementCenterOutputDetailService detailService;
    @Autowired
    private SettlementCenterProjectDrwgrpNumMapper numMapper;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String PARENT_BILL_TYPE_CODE = "BT250121000000001";
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdate(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        SettlementCenterDcDrwgrpInfoEntity entity = (SettlementCenterDcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CommonResponse<SettlementCenterDcDrwgrpInfoVO> commonResponse = this.queryDetail(entity.getId());
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)commonResponse.getData();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateDcDrwgrpInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(@RequestBody SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        return this.service.saveOrUpdateDcDrwgrpInfo(saveOrUpdateVO);
    }

    public SettlementCenterDrawPlanEntity handlerDate(SettlementCenterDrawPlanEntity entity) {
        if (entity != null) {
            List<SettlementCenterDrawPlanDetailEntity> detailList = entity.getSettlementCenterDrawPlanDetailList();
            Date planStartTime = null;
            Date planEndTime = null;
            Date realStartTime = null;
            Date realEndTime = null;
            boolean hasEnd = false;
            boolean hasnotEnd = true;
            for (SettlementCenterDrawPlanDetailEntity detailEntity : detailList) {
                if (detailEntity.getEndTime() != null) {
                    hasEnd = true;
                } else {
                    hasnotEnd = false;
                }
                if (planStartTime == null) {
                    planStartTime = detailEntity.getStartTime();
                } else if (detailEntity.getStartTime() != null && planStartTime.after(detailEntity.getStartTime())) {
                    planStartTime = detailEntity.getStartTime();
                }
                if (planEndTime == null) {
                    planEndTime = detailEntity.getStartTime();
                } else if (detailEntity.getStartTime() != null && planEndTime.before(detailEntity.getStartTime())) {
                    planEndTime = detailEntity.getStartTime();
                }
                if (realStartTime == null) {
                    realStartTime = detailEntity.getEndTime();
                } else if (detailEntity.getEndTime() != null && realStartTime.after(detailEntity.getEndTime())) {
                    realStartTime = detailEntity.getEndTime();
                }
                if (realEndTime == null) {
                    realEndTime = detailEntity.getEndTime();
                    continue;
                }
                if (detailEntity.getEndTime() == null || !realEndTime.before(detailEntity.getEndTime())) continue;
                realEndTime = detailEntity.getEndTime();
            }
            if (hasEnd) {
                if (realStartTime != null) {
                    entity.setCalStartTime(realStartTime);
                }
            } else if (planStartTime != null) {
                entity.setCalStartTime(realStartTime);
            }
            Date endTime = null;
            endTime = hasnotEnd ? realEndTime : planEndTime;
            if (endTime != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(realEndTime);
                calendar.add(5, entity.getPlanFinishDays());
                entity.setCalEndTime(calendar.getTime());
            }
        }
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> queryDetail(Long id) {
        SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.service.selectById(id));
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)BeanMapper.map((Object)((Object)drwgrpInfoEntity), SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDcDrwgrpInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
        fuzzyFields.add("dcDrwgrpInfoName");
        fuzzyFields.add("thirdNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        CommonResponse roles = this.roleApi.queryRoleByNameAndCode("\u7ed3\u7b97\u4e2d\u5fc3\u7efc\u5408\u7ba1\u7406\u5458", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && ((List)roles.getData()).size() > 0) {
            RoleVO roleVO = (RoleVO)((List)roles.getData()).get(0);
            CommonResponse userRoles = this.roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && ((List)userRoles.getData()).size() > 0) {
                for (RoleVO role : (List)userRoles.getData()) {
                    if (!role.getId().equals(roleVO.getId())) continue;
                    flag = true;
                }
            }
        }
        if (!flag) {
            param.getParams().put("thirdNodeUserId", new Parameter("sql", (Object)("(first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') )")));
        }
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        if (param.getParams().get("orgId") != null) {
            String authOrgIds = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        CommonResponse defdoc = this.iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        List list = ((List)defdoc.getData()).stream().filter(a -> a.getName().equals(SettleDrawTypeEnum.N.getName()) || a.getName().equals(SettleDrawTypeEnum.OTHER.getName())).map(BaseVO::getId).collect(Collectors.toList());
        String ids = StringUtils.join((Object[])new String[]{","});
        Map params = param.getParams();
        if (params.get("endTime") != null) {
            String endTime = ((Parameter)params.get("endTime")).getValue().toString();
            String[] split = endTime.split(",");
            params.remove("endTime");
            Parameter parameter = new Parameter();
            parameter.setValue((Object)("  ( (discriminate_state in (" + ids + ") and date_format(fifth_node_time,'%Y-%m-%d') >= " + split[0] + " and date_format(fifth_node_time,'%Y-%m-%d') <= " + split[1] + ") or (discriminate_state not in (" + ids + ") and date_format(eighth_node_time,'%Y-%m-%d') >= " + split[0] + " and date_format(eighth_node_time,'%Y-%m-%d') <= " + split[1] + ")  )"));
            parameter.setType("sql");
            params.put("endTime", parameter);
        }
        IPage page = this.service.queryPage(param, false);
        long total = this.numMapper.queryTotalNum(null, departmentIds, commonOrgIds, null);
        param.getParams().put("flowState", new Parameter("in", Arrays.asList(SettleFlowStateEnum.NINE.getCode(), SettleFlowStateEnum.TWO.getCode())));
        param.setPageSize(1);
        IPage finishPage = this.service.queryPage(param, false);
        long finishTotal = finishPage.getTotal();
        Parameter parentOrgId = (Parameter)param.getParams().get("parentOrgId");
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        param.getParams().clear();
        if (parentOrgId != null) {
            param.getParams().put("parentOrgId", parentOrgId);
        }
        if (orgId != null) {
            param.getParams().put("orgId", orgId);
        }
        IPage needPage = this.service.queryPage(param);
        long needTotal = needPage.getTotal();
        int alterTotal = this.alertInfoService.count((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, (Object)userid)).eq(SettlementCenterAlertInfoEntity::getClearFlag, (Object)0));
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        for (SettlementCenterDcDrwgrpInfoVO record : pageData.getRecords()) {
            record.setTotal(Long.valueOf(total));
            record.setFinishTotal(Long.valueOf(finishTotal));
            record.setNeedTotal(Long.valueOf(needTotal));
            record.setAlterTotal(Integer.valueOf(alterTotal));
            if (total != 0L) {
                record.setPercentage(Double.valueOf(((double)finishTotal + 0.0) / (double)total));
                continue;
            }
            record.setPercentage(Double.valueOf(100.0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("dcDrwgrpInfoCode");
        fuzzyFields.add("thirdNodeUserName");
        Long userid = InvocationInfoProxy.getUserid();
        boolean flag = false;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse roles = this.roleApi.queryRoleByNameAndCode("\u7ed3\u7b97\u4e2d\u5fc3\u7efc\u5408\u7ba1\u7406\u5458", "SETTLE-0001");
        if (roles.isSuccess() && roles.getData() != null && ((List)roles.getData()).size() > 0) {
            RoleVO roleVO = (RoleVO)((List)roles.getData()).get(0);
            CommonResponse userRoles = this.roleApi.queryRoleByUserId(userid);
            if (userRoles.isSuccess() && userRoles.getData() != null && ((List)userRoles.getData()).size() > 0) {
                for (RoleVO role : (List)userRoles.getData()) {
                    if (!role.getId().equals(roleVO.getId())) continue;
                    flag = true;
                }
            }
        }
        if (!flag) {
            param.getParams().put("thirdNodeUserId", new Parameter("sql", (Object)("(first_node_user_id like CONCAT('%','" + userid.toString() + "','%') or second_node_user_id like CONCAT('%','" + userid.toString() + "','%') or third_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fourth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or fifth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or sixth_node_user_id like CONCAT('%','" + userid.toString() + "','%') or seventh_node_user_id like CONCAT('%','" + userid.toString() + "','%') )")));
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("orgId") != null) {
            String authOrgIds = ((Parameter)param.getParams().get("orgId")).getValue().toString();
            param.getParams().remove("orgId");
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDcDrwgrpInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettlementCenterDcDrwgrpInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDcDrwgrpInfoVO>> refSettlementCenterDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            this.logger.info("refSettlementCenterDcDrwgrpInfoData-condition:" + condition);
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (StringUtils.isNotBlank((CharSequence)_con.getString("projectId"))) {
                param.getParams().put("projectId", new Parameter("eq", (Object)Long.parseLong(_con.getString("projectId"))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("contractId"))) {
                param.getParams().put("contractId", new Parameter("eq", (Object)Long.parseLong(_con.getString("contractId"))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("flowState"))) {
                param.getParams().put("flowState", new Parameter("in", Arrays.asList(_con.getString("flowState").split(","))));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("major"))) {
                String[] majors;
                for (String major : majors = _con.getString("major").split(",")) {
                    param.getParams().put("settlementCenterMajor", new Parameter("like", (Object)major));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettlementCenterDcDrwgrpInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/deleteForDrwgrp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteForDrwgrp(@RequestBody List<Long> dcDrwgrpId) {
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, dcDrwgrpId)).eq(BaseEntity::getDr, (Object)0));
        List idList = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.service.removeByIds(idList);
        this.detailService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SettlementCenterOutputDetailEntity::getPid, idList)).eq(BaseEntity::getDr, (Object)0));
        this.alertInfoService.remove((Wrapper)new QueryWrapper().lambda().in(SettlementCenterAlertInfoEntity::getInfoId, idList));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse addDetailData() {
        List<SettlementCenterDcDrwgrpInfoVO> infoVOS = this.service.queryNeedAddDetailData();
        for (SettlementCenterDcDrwgrpInfoVO infoVO : infoVOS) {
            String major = infoVO.getSettlementCenterMajor();
            if (major != null && major.contains(",")) continue;
            SettlementCenterOutputDetailEntity entity = new SettlementCenterOutputDetailEntity();
            entity.setDcDrwgrpInfoCode(infoVO.getDcDrwgrpInfoCode());
            entity.setDrwgrpVsn(infoVO.getDrwgrpVsn());
            entity.setDcDrwgrpInfoName(infoVO.getDcDrwgrpInfoName());
            entity.setOrgCode(infoVO.getOrgCode());
            entity.setOrgId(infoVO.getOrgId());
            entity.setOrgName(infoVO.getOrgName());
            entity.setEquipmentCost(infoVO.getEquipmentCost());
            entity.setInstallationCost(infoVO.getInstallationCost());
            entity.setMaterialCost(infoVO.getMaterialCost());
            entity.setParentOrgCode(infoVO.getParentOrgCode());
            entity.setParentOrgId(infoVO.getParentOrgId());
            entity.setParentOrgName(infoVO.getParentOrgName());
            entity.setPid(infoVO.getId());
            entity.setProjectCode(infoVO.getProjectCode());
            entity.setProjectId(infoVO.getProjectId());
            entity.setProjectName(infoVO.getProjectName());
            entity.setSettlementCenterMajor(Long.valueOf(infoVO.getSettlementCenterMajor()));
            entity.setSettlementCenterMajorName(infoVO.getSettlementCenterMajorName());
            entity.setStatisticalOutput(infoVO.getStatisticalOutput());
            entity.setUserName(infoVO.getThirdNodeUserName());
            entity.setUserId(Long.valueOf(infoVO.getThirdNodeUserId()));
            this.detailService.save((Object)entity);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/querySystemData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse querySystemData(Long systemId) {
        String format;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date planStartDate = null;
        Date planEndDate = null;
        Date startDate = null;
        Date endDate = null;
        CommonResponse defdoc = this.iDefdocApi.getDefDocByDefCode("settlement_center_drwgrp_type");
        BigDecimal total = new BigDecimal(0);
        ArrayList<Long> statisticPerson = new ArrayList<Long>();
        SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = (SettlementCenterDrawPlanEntity)((Object)this.drawPlanService.selectById(systemId));
        List list = this.drawPlanDetailService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterDrawPlanDetailEntity::getPid, (Object)systemId)).eq(BaseEntity::getDr, (Object)0));
        SettlementCenterSystemDrwgrpEntity one = (SettlementCenterSystemDrwgrpEntity)((Object)this.systemDrwgrpService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterSystemDrwgrpEntity::getSystemId, (Object)systemId)).eq(BaseEntity::getDr, (Object)0)).last(" limit 0,1 ")));
        if (settlementCenterDrawPlanEntity != null && settlementCenterDrawPlanEntity.getCalStartTime() != null) {
            startDate = settlementCenterDrawPlanEntity.getCalStartTime();
            statisticPerson.add(settlementCenterDrawPlanEntity.getStatisticalPerson());
        }
        if (one != null && one.getEighthNodeTime() != null) {
            endDate = one.getEighthNodeTime();
            total = one.getStatisticalOutput();
        }
        for (SettlementCenterDrawPlanDetailEntity detailEntity : list) {
            if (planStartDate == null) {
                planStartDate = detailEntity.getStartTime();
            }
            if (planEndDate == null) {
                planEndDate = detailEntity.getStartTime();
            }
            if (detailEntity.getStartTime().before(planStartDate)) {
                planStartDate = detailEntity.getStartTime();
            }
            if (!detailEntity.getStartTime().after(planEndDate)) continue;
            planEndDate = detailEntity.getStartTime();
        }
        JSONObject jsonObject = new JSONObject();
        if (startDate != null) {
            format = sdf.format(startDate);
            jsonObject.put("startDate", (Object)format);
        } else {
            jsonObject.put("startDate", null);
        }
        if (endDate != null) {
            format = sdf.format(endDate);
            jsonObject.put("endDate", (Object)format);
        } else {
            jsonObject.put("endDate", null);
        }
        if (planStartDate != null) {
            format = sdf.format(planStartDate);
            jsonObject.put("planStartDate", (Object)format);
        } else {
            jsonObject.put("planStartDate", null);
        }
        if (planEndDate != null) {
            format = sdf.format(planEndDate);
            jsonObject.put("planEndDate", (Object)format);
        } else {
            jsonObject.put("planEndDate", null);
        }
        jsonObject.put("total", (Object)total);
        if (statisticPerson.size() > 0) {
            CommonResponse response = this.employeeApi.getByIds(statisticPerson);
            if (response.isSuccess()) {
                jsonObject.put("userList", response.getData());
            } else {
                this.logger.info("\u83b7\u53d6\u4eba\u5458\u9519\u8bef:" + response.getMsg() + "      \u53c2\u6570:" + statisticPerson);
                jsonObject.put("userList", new ArrayList());
            }
        } else {
            jsonObject.put("userList", new ArrayList());
        }
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/batchSubmit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> batchSubmit(@RequestBody BatchSubmitVO vo) {
        if (vo == null || ListUtil.isEmpty(vo.getDetailList()) || StringUtils.isEmpty((CharSequence)vo.getBillTypeCode())) {
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u53c2\u6570\u9519\u8bef");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                HashMap submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", this.baseHost + "/settle/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "\u56fe\u7eb8\u5de5\u7a0b\u91cf\u7ba1\u7406" + detail.getId() + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse result = this.iBpmApi.doSubmit((Map)submitParam);
                if (result.isSuccess()) continue;
                return CommonResponse.error((String)result.getMsg());
            }
            return CommonResponse.success((String)"\u6279\u91cf\u63d0\u4ea4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }
}

