/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterBudgetOtherEntity;
import com.ejianc.business.settle.bean.SettlementCenterBudgetOtherVO;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.mapper.SettlementCenterBudgetOtherMapper;
import com.ejianc.business.settle.service.ISettlementCenterBudgetOtherService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="settlementCenterBudgetOtherService")
public class SettlementCenterBudgetOtherServiceImpl
extends BaseServiceImpl<SettlementCenterBudgetOtherMapper, SettlementCenterBudgetOtherEntity>
implements ISettlementCenterBudgetOtherService {
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImport(Long settlementCenterDcDrwgrpInfoId, HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ArrayList<SettlementCenterBudgetOtherVO> successList = new ArrayList<SettlementCenterBudgetOtherVO>();
        ArrayList<SettlementCenterBudgetOtherVO> errorList = new ArrayList<SettlementCenterBudgetOtherVO>();
        List<Object> rtErrorList = new ArrayList();
        boolean isFailed = false;
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0 && result.size() > 10000) {
            return CommonResponse.error((String)"\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
        }
        SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.dcDrwgrpInfoService.selectById(settlementCenterDcDrwgrpInfoId));
        for (int i = 1; i < result.size(); ++i) {
            SettlementCenterBudgetOtherVO vo;
            StringBuilder errmessage = new StringBuilder("");
            boolean flag = true;
            List data = (List)result.get(i);
            String index = (String)data.get(0);
            String code = (String)data.get(1);
            String name = (String)data.get(2);
            String otherNum = (String)data.get(5);
            String memo = (String)data.get(6);
            if (!StringUtils.isNotEmpty((CharSequence)otherNum)) continue;
            SettlementCenterBudgetOtherEntity one = (SettlementCenterBudgetOtherEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterBudgetOtherEntity::getBudgetId, (Object)drwgrpInfoEntity.getBudgeId())).eq(SettlementCenterBudgetOtherEntity::getDetailIndex, (Object)index)).eq(SettlementCenterBudgetOtherEntity::getOtherCode, (Object)code)).eq(SettlementCenterBudgetOtherEntity::getOtherName, (Object)name)).eq(SettlementCenterBudgetOtherEntity::getDcDrwgrpInfo, (Object)0)));
            if (one != null) {
                one.setParentId(one.getId());
                one.setId(IdWorker.getId());
                if (StringUtils.isEmpty((CharSequence)otherNum)) {
                    flag = false;
                    errmessage.append("[\u7edf\u8ba1\u5de5\u7a0b\u91cf]\u4e3a\u7a7a;");
                }
                flag = false;
                if (false) {
                    vo = (SettlementCenterBudgetOtherVO)BeanMapper.map((Object)((Object)one), SettlementCenterBudgetOtherVO.class);
                    vo.setErrorMessage(errmessage.toString());
                    vo.setRowIndex(Integer.valueOf(i));
                    errorList.add(vo);
                    continue;
                }
                one.setSettlementCenterOtherNum(new BigDecimal(otherNum));
                if (one.getOtherTaxPrice() != null && !one.getOtherTaxPrice().equals(BigDecimal.ZERO)) {
                    one.setSettlementCenterOtherTaxMny(new BigDecimal(otherNum).multiply(one.getOtherTaxPrice()));
                } else {
                    one.setSettlementCenterOtherTaxMny(BigDecimal.ZERO);
                }
                if (one.getSettlementCenterOtherTaxMny() != null && !one.getSettlementCenterOtherTaxMny().equals(BigDecimal.ZERO) && one.getOtherTaxRate() != null && !one.getOtherTaxRate().equals(BigDecimal.ZERO)) {
                    one.setSettlementCenterOtherMny(one.getSettlementCenterOtherTaxMny().divide(new BigDecimal(1).add(new BigDecimal(0.01).multiply(one.getOtherTaxRate())), 2, RoundingMode.HALF_DOWN));
                    one.setSettlementCenterOtherTax(one.getSettlementCenterOtherMny().multiply(one.getOtherTaxRate()).multiply(new BigDecimal(0.01)));
                } else {
                    one.setSettlementCenterOtherMny(BigDecimal.ZERO);
                    one.setSettlementCenterOtherTax(BigDecimal.ZERO);
                }
                one.setDcDrwgrpInfo(drwgrpInfoEntity.getId());
                if (StringUtils.isNotEmpty((CharSequence)memo)) {
                    one.setOtherMemo(memo);
                }
                vo = (SettlementCenterBudgetOtherVO)BeanMapper.map((Object)((Object)one), SettlementCenterBudgetOtherVO.class);
                successList.add(vo);
                continue;
            }
            vo = new SettlementCenterBudgetOtherVO();
            this.logger.info("\u7b2c" + i + "\u884c\u6570\u636e:" + StringUtils.join((Iterable)data, (String)","));
            vo.setRowIndex(Integer.valueOf(i));
            vo.setErrorMessage("\u660e\u7ec6\u672a\u627e\u5230");
            errorList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(SettlementCenterBudgetOtherVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        return success;
    }
}

