package com.ejianc.business.settle.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 人员项目明细
 * 
 * @author generator
 * 
 */
 @TableName("settlement_center_user_project_detail")
public class SettlementCenterUserProjectDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="user_id")
    private Long userId; // 人员id
    @TableField(value="user_name")
    private String userName; // 用户名称
    @TableField(value="user_code")
    private String userCode; // 用户账号
    @TableField(value="org_id")
    private Long orgId; // 经理部组织ID
    @TableField(value="org_name")
    private String orgName; // 经理部组织ID
    @TableField(value="settlement_center_fee_num")
    private BigDecimal settlementCenterFeeNum; // 统计工程量
    @TableField(value="settlement_center_fee_tax_mny")
    private BigDecimal settlementCenterFeeTaxMny; // 统计产值(含税)
    @TableField(value="settlement_center_fee_mny")
    private BigDecimal settlementCenterFeeMny; // 统计产值(无税)
    @TableField(value="settlement_center_fee_tax")
    private BigDecimal settlementCenterFeeTax; // 统计产值税额
    @TableField(value="budget_id")
    private Long budgetId; // 预算书主键
    @TableField(value="dc_drwgrp_info")
    private Long dcDrwgrpInfo; // 'settlement_center_dc_drwgrp_info主键
    @TableField(value="source_id")
    private Long sourceId; // 明细表id
    @TableField(value="source_type")
    private Integer sourceType; // 明细表类别0:fee 1:sub 2:other 3:measure
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="settlement_center_major")
    private Long settlementCenterMajor; // 结算中心专业
    @TableField(value="dc_drwgrp_info_code")
    private String dcDrwgrpInfoCode; // 卷册编码
    @TableField(value="drwgrp_vsn")
    private String drwgrpVsn; // 卷册版本
    @TableField(value="dc_drwgrp_info_name")
    private String dcDrwgrpInfoName; // 卷册名称
    @TableField(value="settlement_center_major_name")
    private String settlementCenterMajorName; // 结算中心专业名称
    @TableField(value="source_name")
    private String sourceName; // 明细名称
    
    
    

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getSettlementCenterFeeNum() {
        return settlementCenterFeeNum;
    }

    public void setSettlementCenterFeeNum(BigDecimal settlementCenterFeeNum) {
        this.settlementCenterFeeNum = settlementCenterFeeNum;
    }

    public BigDecimal getSettlementCenterFeeTaxMny() {
        return settlementCenterFeeTaxMny;
    }

    public void setSettlementCenterFeeTaxMny(BigDecimal settlementCenterFeeTaxMny) {
        this.settlementCenterFeeTaxMny = settlementCenterFeeTaxMny;
    }

    public BigDecimal getSettlementCenterFeeMny() {
        return settlementCenterFeeMny;
    }

    public void setSettlementCenterFeeMny(BigDecimal settlementCenterFeeMny) {
        this.settlementCenterFeeMny = settlementCenterFeeMny;
    }

    public BigDecimal getSettlementCenterFeeTax() {
        return settlementCenterFeeTax;
    }

    public void setSettlementCenterFeeTax(BigDecimal settlementCenterFeeTax) {
        this.settlementCenterFeeTax = settlementCenterFeeTax;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Long getDcDrwgrpInfo() {
        return dcDrwgrpInfo;
    }

    public void setDcDrwgrpInfo(Long dcDrwgrpInfo) {
        this.dcDrwgrpInfo = dcDrwgrpInfo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getSettlementCenterMajor() {
        return settlementCenterMajor;
    }

    public void setSettlementCenterMajor(Long settlementCenterMajor) {
        this.settlementCenterMajor = settlementCenterMajor;
    }

    public String getDcDrwgrpInfoCode() {
        return dcDrwgrpInfoCode;
    }

    public void setDcDrwgrpInfoCode(String dcDrwgrpInfoCode) {
        this.dcDrwgrpInfoCode = dcDrwgrpInfoCode;
    }

    public String getDrwgrpVsn() {
        return drwgrpVsn;
    }

    public void setDrwgrpVsn(String drwgrpVsn) {
        this.drwgrpVsn = drwgrpVsn;
    }

    public String getDcDrwgrpInfoName() {
        return dcDrwgrpInfoName;
    }

    public void setDcDrwgrpInfoName(String dcDrwgrpInfoName) {
        this.dcDrwgrpInfoName = dcDrwgrpInfoName;
    }

    public String getSettlementCenterMajorName() {
        return settlementCenterMajorName;
    }

    public void setSettlementCenterMajorName(String settlementCenterMajorName) {
        this.settlementCenterMajorName = settlementCenterMajorName;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
}
