/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"overview"})
public class OverviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;

    @RequestMapping(value={"/statisticalData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse statisticalData() {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        List list = this.dcDrwgrpInfoService.list((Wrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0));
        BigDecimal totalOutputForYear = new BigDecimal(0);
        BigDecimal totalOutputAll = new BigDecimal(0);
        BigDecimal totalOutputForLastMonth = new BigDecimal(0);
        BigDecimal totalOutputForMonth = new BigDecimal(0);
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> distributedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishedForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForLastMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> finishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> planFinishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> statisticalFinishForMonth = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        ArrayList<SettlementCenterDcDrwgrpInfoEntity> statisticalFinishForYear = new ArrayList<SettlementCenterDcDrwgrpInfoEntity>();
        HashMap<Integer, BigDecimal> outputEveryMonth = new HashMap<Integer, BigDecimal>();
        for (SettlementCenterDcDrwgrpInfoEntity entity : list) {
            Date planFinishDate;
            Date distributedDate;
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName())) {
                Date finishDate = entity.getEighthNodeTime();
                totalOutputAll = totalOutputAll.add(entity.getStatisticalOutput());
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    totalOutputForYear = totalOutputForYear.add(entity.getStatisticalOutput());
                    statisticalFinishForYear.add(entity);
                    Integer month = DateUtil.month((Date)finishDate) + 1;
                    if (outputEveryMonth.get(month) == null) {
                        outputEveryMonth.put(month, entity.getStatisticalOutput());
                    } else {
                        outputEveryMonth.put(month, ((BigDecimal)outputEveryMonth.get(month)).add(entity.getStatisticalOutput()));
                    }
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    totalOutputForMonth = totalOutputForMonth.add(entity.getStatisticalOutput());
                    statisticalFinishForMonth.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    totalOutputForLastMonth = totalOutputForLastMonth.add(entity.getStatisticalOutput());
                }
            }
            if (entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName()) || entity.getFlowStateName().equals(SettleFlowStateEnum.TWO.getName())) {
                distributedDate = entity.getThirdNodeTime();
                Date finishDate = null;
                finishDate = entity.getFlowStateName().equals(SettleFlowStateEnum.NINE.getName()) ? entity.getEighthNodeTime() : entity.getFifthNodeTime();
                if (DateUtil.year((Date)finishDate) == DateUtil.thisYear()) {
                    finishedForYear.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                    finishForMonth.add(entity);
                }
                if (DateUtil.beginOfMonth((Date)finishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                    finishedForLastMonth.add(entity);
                }
            }
            if ((distributedDate = entity.getThirdNodeTime()) != null && DateUtil.year((Date)distributedDate) == DateUtil.thisYear()) {
                distributedForYear.add(entity);
            }
            if ((planFinishDate = entity.getDesiredTime()) == null) continue;
            if (DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)new Date()))) {
                planFinishForMonth.add(entity);
            }
            if (DateUtil.beginOfMonth((Date)planFinishDate).equals((Object)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()))) {
                planFinishForLastMonth.add(entity);
            }
            if (DateUtil.year((Date)planFinishDate) != DateUtil.thisYear()) continue;
            planFinishForYear.add(entity);
        }
        resultMap.put("totalOutputForYear", totalOutputForYear);
        resultMap.put("totalOutputAll", totalOutputAll);
        resultMap.put("totalOutputForLastMonth", totalOutputForLastMonth);
        resultMap.put("totalOutputWithOutMonth", totalOutputForYear.subtract(totalOutputForMonth));
        resultMap.put("totalOutputForMonth", totalOutputForMonth);
        resultMap.put("distributedForYearCount", Integer.valueOf(distributedForYear.size()));
        resultMap.put("finishedForYearCount", Integer.valueOf(finishedForYear.size()));
        resultMap.put("finishedForLastMonthCount", Integer.valueOf(finishedForLastMonth.size()));
        resultMap.put("planFinishForLastMonthCount", Integer.valueOf(planFinishForLastMonth.size()));
        resultMap.put("finishForMonthCount", Integer.valueOf(finishForMonth.size()));
        resultMap.put("planFinishForMonthCount", Integer.valueOf(planFinishForMonth.size()));
        if (planFinishForLastMonth.size() == 0) {
            resultMap.put("finishRateForLastMonth", Integer.valueOf(1));
        } else {
            resultMap.put("finishRateForLastMonth", Double.valueOf(((double)finishedForLastMonth.size() + 0.0) / (double)planFinishForLastMonth.size()));
        }
        if (planFinishForMonth.size() == 0) {
            resultMap.put("finishRateForMonth", Integer.valueOf(1));
        } else {
            resultMap.put("finishRateForMonth", Double.valueOf(((double)finishForMonth.size() + 0.0) / (double)planFinishForMonth.size()));
        }
        if (planFinishForYear.size() == 0) {
            resultMap.put("finishRateForYear", Integer.valueOf(1));
        } else {
            resultMap.put("finishRateForYear", Double.valueOf(((double)finishedForYear.size() + 0.0) / (double)planFinishForYear.size()));
        }
        resultMap.put("outputEveryMonth", outputEveryMonth);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/getRankingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse getRankingList() {
        HashMap<String, List<Map>> resultMap = new HashMap<String, List<Map>>();
        List<Map> rankingListForYear = this.dcDrwgrpInfoService.getRankingListForYear(null, null, null);
        List<Map> rankingListForMonth = this.dcDrwgrpInfoService.getRankingListForMonth(null, null, null);
        resultMap.put("rankingListForYear", rankingListForYear);
        resultMap.put("rankingListForMonth", rankingListForMonth);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/getRankingListWithOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse getRankingListWithOrder(Integer orderType) {
        HashMap resultMap = new HashMap();
        List<Object> rankingListWithOrder = new ArrayList();
        rankingListWithOrder = orderType == 1 ? this.dcDrwgrpInfoService.getRankingListWithOrder(null, null, null, "total_amount") : (orderType == 2 ? this.dcDrwgrpInfoService.getRankingListWithOrder(null, null, null, "year_total_amount") : this.dcDrwgrpInfoService.getRankingListWithOrder(null, null, null, "month_total_amount"));
        resultMap.put("rankingList", rankingListWithOrder);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/getProjectLedgerList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse getProjectLedgerList(Integer orderType) {
        HashMap resultMap = new HashMap();
        List<Object> projectLedgerList = new ArrayList();
        projectLedgerList = orderType == 1 ? this.dcDrwgrpInfoService.getProjectLedgerList("total_amount") : (orderType == 2 ? this.dcDrwgrpInfoService.getProjectLedgerList("year_total_amount") : this.dcDrwgrpInfoService.getProjectLedgerList("month_total_amount"));
        resultMap.put("projectLedgerList", projectLedgerList);
        return CommonResponse.success(resultMap);
    }

    @RequestMapping(value={"/getMajorLedgerList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse getMajorLedgerList(Integer orderType) {
        HashMap resultMap = new HashMap();
        List<Object> majorLedgerList = new ArrayList();
        majorLedgerList = orderType == 1 ? this.dcDrwgrpInfoService.getMajorLedgerList("total_amount") : (orderType == 2 ? this.dcDrwgrpInfoService.getMajorLedgerList("year_total_amount") : this.dcDrwgrpInfoService.getMajorLedgerList("month_total_amount"));
        resultMap.put("majorLedgerList", majorLedgerList);
        return CommonResponse.success(resultMap);
    }
}

