/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.mapper.SettlementCenterAlertInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterAlertInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementCenterAlertInfoService")
public class SettlementCenterAlertInfoServiceImpl
extends BaseServiceImpl<SettlementCenterAlertInfoMapper, SettlementCenterAlertInfoEntity>
implements ISettlementCenterAlertInfoService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SettlementCenterAlertInfoMapper mapper;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService infoService;

    @Override
    public void saveLastAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        String thirdNodeUserId = alert.getThirdNodeUserId();
        if (StringUtils.isNotEmpty((CharSequence)thirdNodeUserId)) {
            CommonResponse response = this.bpmApi.queryHistoryById(alert.getId());
            if (!response.isSuccess() || response.getData() == null || ((List)response.getData()).size() <= 0) {
                this.logger.info(alert.getId() + "\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u9519\u8bef");
                this.logger.info(response.getMsg());
                return;
            }
            String[] split = thirdNodeUserId.split(",");
            for (int i = 0; i < split.length; ++i) {
                List list;
                String s = split[i];
                SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
                entity.setAlertLastTime(new Date());
                entity.setAlertNowTime(alert.getDesiredTime());
                entity.setProjectId(alert.getProjectId());
                entity.setAlertType(0);
                entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
                entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
                entity.setProjectCode(alert.getProjectCode());
                entity.setProjectName(alert.getProjectName());
                entity.setThirdNodeUserId(Long.parseLong(s));
                entity.setInfoId(alert.getId());
                entity.setInfoCode(alert.getDcDrwgrpInfoCode());
                entity.setClearFlag(0);
                entity.setMajorName(alert.getSettlementCenterMajorName());
                CommonResponse userByUserId = this.userApi.findUserByUserId(Long.valueOf(Long.parseLong(s)));
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    entity.setThirdNodeUserName(((UserVO)userByUserId.getData()).getUserName());
                } else {
                    entity.setThirdNodeUserName(alert.getThirdNodeUserName().split(",")[i]);
                }
                this.logger.info("\u5f53\u524d\u9884\u8b66\u4eba:" + entity.getThirdNodeUserName() + ";\u5f53\u524d\u9884\u8b66\u4ebaID:" + entity.getThirdNodeUserId());
                entity.setOrgId(alert.getOrgId());
                entity.setOrgCode(alert.getOrgCode());
                entity.setOrgName(alert.getOrgName());
                entity.setParentOrgId(alert.getParentOrgId());
                entity.setParentOrgCode(alert.getParentOrgCode());
                entity.setParentOrgName(alert.getParentOrgName());
                boolean flag = false;
                for (BpmApproveHistoryInfo datum : (List)response.getData()) {
                    if (!"\u7ed3\u7b97\u4e2d\u5fc3\u4e13\u804c".equals(datum.getApproveNode()) || !datum.getApprover().equals(entity.getThirdNodeUserName()) || !"\u5ba1\u6279\u4e2d".equals(datum.getApprovalOutcome())) continue;
                    flag = true;
                }
                if (!flag || (list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, (Object)entity.getThirdNodeUserId())).eq(SettlementCenterAlertInfoEntity::getAlertType, (Object)0)).eq(SettlementCenterAlertInfoEntity::getInfoId, (Object)alert.getId()))) != null && list.size() > 0) continue;
                this.saveOrUpdate((Object)entity);
            }
        }
    }

    @Override
    public List<SettlementCenterAlertInfoEntity> selectByUserId(Long thirdNodeUserId, Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.mapper.selectAlertList(thirdNodeUserId, major, commonOrgIds, departmentIds);
    }

    @Override
    public void saveNowAlert(SettlementCenterDcDrwgrpInfoEntity alert) {
        String thirdNodeUserId = alert.getThirdNodeUserId();
        if (StringUtils.isNotEmpty((CharSequence)thirdNodeUserId)) {
            CommonResponse response = this.bpmApi.queryHistoryById(alert.getId());
            if (!response.isSuccess() || response.getData() == null || ((List)response.getData()).size() <= 0) {
                this.logger.info(alert.getId() + "\u83b7\u53d6\u5ba1\u6279\u4fe1\u606f\u9519\u8bef");
                this.logger.info(response.getMsg());
                return;
            }
            String[] split = thirdNodeUserId.split(",");
            for (int i = 0; i < split.length; ++i) {
                List list;
                String s = split[i];
                SettlementCenterAlertInfoEntity entity = new SettlementCenterAlertInfoEntity();
                entity.setAlertNowTime(alert.getDesiredTime());
                entity.setAlertLastTime(new Date());
                entity.setProjectId(alert.getProjectId());
                entity.setAlertType(1);
                entity.setSettlementCenterMajor(alert.getSettlementCenterMajor());
                entity.setDcDrwgrpInfoName(alert.getDcDrwgrpInfoName());
                entity.setProjectCode(alert.getProjectCode());
                entity.setProjectName(alert.getProjectName());
                entity.setThirdNodeUserId(Long.parseLong(s));
                entity.setInfoId(alert.getId());
                entity.setInfoCode(alert.getDcDrwgrpInfoCode());
                entity.setClearFlag(0);
                entity.setMajorName(alert.getSettlementCenterMajorName());
                CommonResponse userByUserId = this.userApi.findUserByUserId(Long.valueOf(Long.parseLong(s)));
                if (userByUserId.isSuccess() && userByUserId.getData() != null) {
                    entity.setThirdNodeUserName(((UserVO)userByUserId.getData()).getUserName());
                } else {
                    entity.setThirdNodeUserName(alert.getThirdNodeUserName().split(",")[i]);
                }
                this.logger.info("\u5f53\u524d\u9884\u8b66\u4eba:" + entity.getThirdNodeUserName() + ";\u5f53\u524d\u9884\u8b66\u4ebaID:" + entity.getThirdNodeUserId());
                entity.setOrgId(alert.getOrgId());
                entity.setOrgCode(alert.getOrgCode());
                entity.setOrgName(alert.getOrgName());
                entity.setParentOrgId(alert.getParentOrgId());
                entity.setParentOrgCode(alert.getParentOrgCode());
                entity.setParentOrgName(alert.getParentOrgName());
                boolean flag = false;
                for (BpmApproveHistoryInfo datum : (List)response.getData()) {
                    if (!"\u7ed3\u7b97\u4e2d\u5fc3\u4e13\u804c".equals(datum.getApproveNode()) || !datum.getApprover().equals(entity.getThirdNodeUserName()) || !"\u5ba1\u6279\u4e2d".equals(datum.getApprovalOutcome())) continue;
                    flag = true;
                }
                if (!flag || (list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterAlertInfoEntity::getThirdNodeUserId, (Object)entity.getThirdNodeUserId())).eq(SettlementCenterAlertInfoEntity::getAlertType, (Object)1)).eq(SettlementCenterAlertInfoEntity::getInfoId, (Object)alert.getId()))) != null && list.size() > 0) continue;
                this.saveOrUpdate((Object)entity);
            }
        }
    }
}

