/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterBudgetFeeEntity;
import com.ejianc.business.settle.bean.SettlementCenterBudgetFeeVO;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.mapper.SettlementCenterBudgetFeeMapper;
import com.ejianc.business.settle.service.ISettlementCenterBudgetFeeService;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="settlementCenterBudgetFeeService")
public class SettlementCenterBudgetFeeServiceImpl
extends BaseServiceImpl<SettlementCenterBudgetFeeMapper, SettlementCenterBudgetFeeEntity>
implements ISettlementCenterBudgetFeeService {
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> excelImport(Long settlementCenterDcDrwgrpInfoId, HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ArrayList<SettlementCenterBudgetFeeVO> successList = new ArrayList<SettlementCenterBudgetFeeVO>();
        ArrayList<SettlementCenterBudgetFeeVO> errorList = new ArrayList<SettlementCenterBudgetFeeVO>();
        List<Object> rtErrorList = new ArrayList();
        boolean isFailed = false;
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0 && result.size() > 10000) {
            return CommonResponse.error((String)"\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
        }
        SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.dcDrwgrpInfoService.selectById(settlementCenterDcDrwgrpInfoId));
        for (int i = 1; i < result.size(); ++i) {
            SettlementCenterBudgetFeeVO vo;
            StringBuilder errmessage = new StringBuilder("");
            boolean flag = true;
            List data = (List)result.get(i);
            String index = (String)data.get(0);
            String code = (String)data.get(1);
            String name = (String)data.get(2);
            String feeNum = (String)data.get(5);
            String memo = (String)data.get(6);
            if (!StringUtils.isNotEmpty((CharSequence)feeNum)) continue;
            SettlementCenterBudgetFeeEntity one = (SettlementCenterBudgetFeeEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterBudgetFeeEntity::getBudgetId, (Object)drwgrpInfoEntity.getBudgeId())).eq(SettlementCenterBudgetFeeEntity::getDetailIndex, (Object)index)).eq(SettlementCenterBudgetFeeEntity::getFeeCode, (Object)code)).eq(SettlementCenterBudgetFeeEntity::getFeeName, (Object)name)).eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo, (Object)0)));
            if (one != null) {
                if (StringUtils.isEmpty((CharSequence)feeNum)) {
                    flag = false;
                    errmessage.append("[\u7edf\u8ba1\u5de5\u7a0b\u91cf]\u4e3a\u7a7a;");
                }
                flag = false;
                if (false) {
                    vo = (SettlementCenterBudgetFeeVO)BeanMapper.map((Object)((Object)one), SettlementCenterBudgetFeeVO.class);
                    vo.setErrorMessage(errmessage.toString());
                    vo.setRowIndex(Integer.valueOf(i));
                    errorList.add(vo);
                    continue;
                }
                one.setParentId(one.getId());
                one.setId(IdWorker.getId());
                one.setSettlementCenterFeeNum(new BigDecimal(feeNum));
                if (one.getFeeTaxPrice() != null) {
                    one.setSettlementCenterFeeTaxMny(new BigDecimal(feeNum).multiply(one.getFeeTaxPrice()));
                } else {
                    one.setSettlementCenterFeeTaxMny(BigDecimal.ZERO);
                }
                if (one.getSettlementCenterFeeTaxMny() != null && !one.getSettlementCenterFeeTaxMny().equals(BigDecimal.ZERO) && one.getFeeTaxRate() != null && !one.getFeeTaxRate().equals(BigDecimal.ZERO)) {
                    one.setSettlementCenterFeeMny(one.getSettlementCenterFeeTaxMny().divide(new BigDecimal(1).add(new BigDecimal(0.01).multiply(one.getFeeTaxRate())), 2, RoundingMode.HALF_DOWN));
                    one.setSettlementCenterFeeTax(one.getSettlementCenterFeeMny().multiply(one.getFeeTaxRate()).multiply(new BigDecimal(0.01)));
                } else {
                    one.setSettlementCenterFeeMny(BigDecimal.ZERO);
                    one.setSettlementCenterFeeTax(BigDecimal.ZERO);
                }
                one.setDcDrwgrpInfo(drwgrpInfoEntity.getId());
                if (StringUtils.isNotEmpty((CharSequence)memo)) {
                    one.setFeeMemo(memo);
                }
                vo = (SettlementCenterBudgetFeeVO)BeanMapper.map((Object)((Object)one), SettlementCenterBudgetFeeVO.class);
                successList.add(vo);
                continue;
            }
            vo = new SettlementCenterBudgetFeeVO();
            this.logger.info("\u7b2c" + i + "\u884c\u6570\u636e:" + StringUtils.join((Iterable)data, (String)","));
            vo.setRowIndex(Integer.valueOf(i));
            vo.setErrorMessage("\u660e\u7ec6\u672a\u627e\u5230");
            errorList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(SettlementCenterBudgetFeeVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse success = CommonResponse.success((Object)json);
        return success;
    }
}

