/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanEntity;
import com.ejianc.business.settle.bean.SettlementCenterProjectMajorEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.mapper.SettlementCenterDcDrwgrpInfoMapper;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanDetailService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanService;
import com.ejianc.business.settle.service.ISettlementCenterProjectMajorService;
import com.ejianc.business.settle.service.ISettlementCenterSystemDrwgrpService;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="settlementCenterDcDrwgrpInfoService")
public class SettlementCenterDcDrwgrpInfoServiceImpl
extends BaseServiceImpl<SettlementCenterDcDrwgrpInfoMapper, SettlementCenterDcDrwgrpInfoEntity>
implements ISettlementCenterDcDrwgrpInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBpmApi iBpmApi;
    @Autowired
    private SettlementCenterDcDrwgrpInfoMapper infoMapper;
    @Autowired
    private ISettlementCenterDrawPlanService drawPlanService;
    @Autowired
    private ISettlementCenterDrawPlanDetailService drawPlanDetailService;
    @Autowired
    private ISettlementCenterSystemDrwgrpService systemDrwgrpService;
    @Autowired
    private ISettlementCenterProjectMajorService projectMajorService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String PARENT_BILL_TYPE_CODE = "BT250121000000001";

    @Override
    public List<Map> getRankingListForYear(Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.infoMapper.getRankingListForYear(major, departmentIds, commonOrgIds);
    }

    @Override
    public List<Map> getRankingListForMonth(Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.infoMapper.getRankingListForMonth(major, departmentIds, commonOrgIds);
    }

    @Override
    public List<Map> getRankingListWithOrder(Long major, List<Long> departmentIds, List<Long> commonOrgIds, String order) {
        return this.infoMapper.getRankingListWithOrder(major, departmentIds, commonOrgIds, order);
    }

    @Override
    public List<Map> getProjectLedgerList(String order) {
        return this.infoMapper.getProjectLedgerList(order);
    }

    @Override
    public List<Map> getMajorLedgerList(String order) {
        return this.infoMapper.getMajorLedgerList(order);
    }

    @Override
    public List<Map> getProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds, Integer pageStart, Integer pageSize) {
        return this.infoMapper.getProjectStatisticsLedgerList(projectIds, departmentIds, commonOrgIds, pageStart, pageSize);
    }

    @Override
    public Integer countProjectStatisticsLedgerList(List<String> projectIds, List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.infoMapper.countProjectStatisticsLedgerList(projectIds, departmentIds, commonOrgIds);
    }

    @Override
    public List<Map> queryAllProject(List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.infoMapper.queryAllProject(departmentIds, commonOrgIds);
    }

    @Override
    public List<Map> getMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds, Integer pageStart, Integer pageSize) {
        return this.infoMapper.getMajorStatisticsLedgerList(major, departmentIds, commonOrgIds, pageStart, pageSize);
    }

    @Override
    public Integer countMajorStatisticsLedgerList(Long major, List<Long> departmentIds, List<Long> commonOrgIds) {
        return this.infoMapper.countMajorStatisticsLedgerList(major, departmentIds, commonOrgIds);
    }

    @Override
    public List<SettlementCenterDcDrwgrpInfoVO> queryNeedAddDetailData() {
        return this.infoMapper.queryNeedAddDetailData();
    }

    @Override
    public CommonResponse<SettlementCenterDcDrwgrpInfoVO> saveOrUpdateDcDrwgrpInfo(SettlementCenterDcDrwgrpInfoVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getSettlementCenterMajor() == null) {
            saveOrUpdateVO.setSettlementCenterMajor(saveOrUpdateVO.getMajorId());
        }
        String sourceUnitid = saveOrUpdateVO.getSourceUnitid();
        String sourceUnitname = saveOrUpdateVO.getSourceUnitname();
        SettlementCenterDcDrwgrpInfoEntity entity = (SettlementCenterDcDrwgrpInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementCenterDcDrwgrpInfoEntity.class));
        SettlementCenterDcDrwgrpInfoEntity exist = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoId, (Object)saveOrUpdateVO.getDcDrwgrpInfoId())).eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId, (Object)saveOrUpdateVO.getSystemId())));
        if (exist != null) {
            exist.setOrgId(entity.getOrgId());
            exist.setOrgCode(entity.getOrgCode());
            exist.setOrgName(entity.getOrgName());
            exist.setParentOrgId(entity.getParentOrgId());
            exist.setParentOrgCode(entity.getParentOrgCode());
            exist.setParentOrgName(entity.getParentOrgName());
            exist.setProjectId(entity.getProjectId());
            exist.setProjectCode(entity.getProjectCode());
            exist.setProjectName(entity.getProjectName());
            exist.setDcDrwgrpInfoCode(entity.getDcDrwgrpInfoCode());
            exist.setDcDrwgrpInfoName(entity.getDcDrwgrpInfoName());
            this.updateById((Object)exist);
        } else {
            Long systemId;
            SettlementCenterDcDrwgrpInfoEntity notUpgrade = (SettlementCenterDcDrwgrpInfoEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, (Object)saveOrUpdateVO.getDcDrwgrpInfoCode())).eq(SettlementCenterDcDrwgrpInfoEntity::getWhetherUpgrade, (Object)0)).eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId, (Object)saveOrUpdateVO.getSystemId())));
            if (notUpgrade != null) {
                entity.setWhetherUpgrade(1);
            }
            if ((systemId = entity.getSystemId()) != null) {
                SettlementCenterSystemDrwgrpEntity one;
                this.logger.info("\u5f53\u524d\u5230\u56fe\u8ba1\u5212id\u4e3a:" + systemId);
                SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = (SettlementCenterDrawPlanEntity)((Object)this.drawPlanService.selectById(systemId));
                if (settlementCenterDrawPlanEntity != null) {
                    this.logger.info("saveOrUpdateDcDrwgrpInfo-------1");
                    List<SettlementCenterDrawPlanDetailEntity> detailList = settlementCenterDrawPlanEntity.getSettlementCenterDrawPlanDetailList();
                    SettlementCenterDrawPlanDetailEntity settlementCenterDrawPlanDetailEntity = detailList.stream().filter(e -> entity.getDcDrwgrpInfoCode().contains(e.getDrwgrpCode())).findFirst().orElse(null);
                    if (settlementCenterDrawPlanDetailEntity != null) {
                        this.logger.info("saveOrUpdateDcDrwgrpInfo-----2");
                        settlementCenterDrawPlanDetailEntity.setEndTime(saveOrUpdateVO.getDrawArriveDate() == null ? new Date() : saveOrUpdateVO.getDrawArriveDate());
                        this.drawPlanDetailService.updateById((Object)settlementCenterDrawPlanDetailEntity);
                    }
                    SettlementCenterDrawPlanEntity drawPlanEntity = this.handlerDate(settlementCenterDrawPlanEntity);
                    this.drawPlanService.updateById((Object)drawPlanEntity);
                }
                if ((one = (SettlementCenterSystemDrwgrpEntity)((Object)this.systemDrwgrpService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterSystemDrwgrpEntity::getSystemId, (Object)systemId)).eq(BaseEntity::getDr, (Object)0)).last(" limit 0,1 ")))) != null) {
                    entity.setPid(one.getId());
                    if (StringUtils.isNotEmpty((CharSequence)sourceUnitid) && (one.getSourceUnitid() == null || !one.getSourceUnitid().contains(sourceUnitid))) {
                        if (StringUtils.isNotEmpty((CharSequence)one.getSourceUnitid())) {
                            one.setSourceUnitid(one.getSourceUnitid() + "," + sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname() + "," + sourceUnitname);
                        } else {
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                        this.systemDrwgrpService.updateById((Object)one);
                    }
                } else {
                    one = new SettlementCenterSystemDrwgrpEntity();
                    one.setFlowState(SettleFlowStateEnum.ONE.getCode());
                    one.setFlowStateName(SettleFlowStateEnum.ONE.getName());
                    one.setFirstNodeTime(new Date());
                    one.setDesiredTime(settlementCenterDrawPlanEntity.getCalEndTime());
                    one.setSystemId(systemId);
                    one.setSystemName(settlementCenterDrawPlanEntity.getSystemName());
                    one.setOrgId(entity.getOrgId());
                    one.setOrgCode(entity.getOrgCode());
                    one.setOrgName(entity.getOrgName());
                    one.setParentOrgId(entity.getParentOrgId());
                    one.setParentOrgCode(entity.getParentOrgCode());
                    one.setParentOrgName(entity.getParentOrgName());
                    one.setProjectId(entity.getProjectId());
                    one.setProjectCode(entity.getProjectCode());
                    one.setProjectName(entity.getProjectName());
                    one.setThirdNodeUserId(settlementCenterDrawPlanEntity.getStatisticalPerson() == null ? null : settlementCenterDrawPlanEntity.getStatisticalPerson().toString());
                    one.setFourthNodeUserId(settlementCenterDrawPlanEntity.getMajorManagerPerson() == null ? null : settlementCenterDrawPlanEntity.getMajorManagerPerson().toString());
                    one.setFifthNodeUserId(settlementCenterDrawPlanEntity.getProjectResponsiblePerson());
                    one.setSixthNodeUserId(settlementCenterDrawPlanEntity.getProjectContractPerson());
                    one.setSeventhNodeUserId(settlementCenterDrawPlanEntity.getCompositePerson());
                    one.setSettlementCenterMajor(settlementCenterDrawPlanEntity.getSettlementCenterMajor().toString());
                    one.setSettlementCenterMajorName(settlementCenterDrawPlanEntity.getSettlementCenterMajorName());
                    SettlementCenterProjectMajorEntity projectMajor = (SettlementCenterProjectMajorEntity)((Object)this.projectMajorService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SettlementCenterProjectMajorEntity::getProjectId, (Object)settlementCenterDrawPlanEntity.getProjectId())).eq(SettlementCenterProjectMajorEntity::getSettlementCenterMajor, (Object)settlementCenterDrawPlanEntity.getSettlementCenterMajor())).eq(BaseEntity::getDr, (Object)0)));
                    if (projectMajor != null) {
                        one.setContractId(projectMajor.getContractId());
                        one.setContractCode(projectMajor.getContractCode());
                        one.setContractMny(projectMajor.getContractTaxMny());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)sourceUnitid)) {
                        if (StringUtils.isNotEmpty((CharSequence)one.getSourceUnitid()) && !one.getSourceUnitid().contains(sourceUnitid)) {
                            one.setSourceUnitid(one.getSourceUnitid() + "," + sourceUnitid);
                            one.setSourceUnitname(one.getSourceUnitname() + "," + sourceUnitname);
                        } else if (!StringUtils.isNotEmpty((CharSequence)one.getSourceUnitid())) {
                            one.setSourceUnitid(sourceUnitid);
                            one.setSourceUnitname(sourceUnitname);
                        }
                    }
                    this.systemDrwgrpService.save((Object)one);
                    this.doCommit(one);
                    entity.setPid(one.getId());
                }
            }
            this.save((Object)entity);
        }
        SettlementCenterDcDrwgrpInfoVO vo = (SettlementCenterDcDrwgrpInfoVO)BeanMapper.map((Object)((Object)entity), SettlementCenterDcDrwgrpInfoVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_UNCOMMITTED)
    public void doCommit(SettlementCenterSystemDrwgrpEntity one) {
        HashMap submitParam = Maps.newHashMap();
        submitParam.put("userId", InvocationInfoProxy.getUserid());
        submitParam.put("billtypeId", PARENT_BILL_TYPE_CODE);
        submitParam.put("businessKey", one.getId());
        submitParam.put("formurl", this.baseHost + "/settle/#/drawingEngineering/new/card?id=" + one.getId());
        submitParam.put("procInstName", "\u56fe\u7eb8\u5de5\u7a0b\u91cf\u7ba1\u7406" + one.getId() + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        submitParam.put("billOrgId", one.getOrgId());
        submitParam.put("messageType", new String[]{"sys"});
        CommonResponse stringCommonResponse = this.iBpmApi.doSubmit((Map)submitParam);
        this.logger.info("saveOrUpdateDcDrwgrpInfo:stringCommonResponse:" + stringCommonResponse.getMsg());
    }

    public SettlementCenterDrawPlanEntity handlerDate(SettlementCenterDrawPlanEntity entity) {
        if (entity != null) {
            List<SettlementCenterDrawPlanDetailEntity> detailList = entity.getSettlementCenterDrawPlanDetailList();
            Date planStartTime = null;
            Date planEndTime = null;
            Date realStartTime = null;
            Date realEndTime = null;
            boolean hasEnd = false;
            boolean hasnotEnd = true;
            for (SettlementCenterDrawPlanDetailEntity detailEntity : detailList) {
                if (detailEntity.getEndTime() != null) {
                    hasEnd = true;
                } else {
                    hasnotEnd = false;
                }
                if (planStartTime == null) {
                    planStartTime = detailEntity.getStartTime();
                } else if (detailEntity.getStartTime() != null && planStartTime.after(detailEntity.getStartTime())) {
                    planStartTime = detailEntity.getStartTime();
                }
                if (planEndTime == null) {
                    planEndTime = detailEntity.getStartTime();
                } else if (detailEntity.getStartTime() != null && planEndTime.before(detailEntity.getStartTime())) {
                    planEndTime = detailEntity.getStartTime();
                }
                if (realStartTime == null) {
                    realStartTime = detailEntity.getEndTime();
                } else if (detailEntity.getEndTime() != null && realStartTime.after(detailEntity.getEndTime())) {
                    realStartTime = detailEntity.getEndTime();
                }
                if (realEndTime == null) {
                    realEndTime = detailEntity.getEndTime();
                    continue;
                }
                if (detailEntity.getEndTime() == null || !realEndTime.before(detailEntity.getEndTime())) continue;
                realEndTime = detailEntity.getEndTime();
            }
            if (hasEnd) {
                if (realStartTime != null) {
                    entity.setCalStartTime(realStartTime);
                }
            } else if (planStartTime != null) {
                entity.setCalStartTime(realStartTime);
            }
            Date endTime = null;
            endTime = hasnotEnd ? realEndTime : planEndTime;
            if (endTime != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(realEndTime);
                calendar.add(5, entity.getPlanFinishDays());
                entity.setCalEndTime(calendar.getTime());
            }
        }
        return entity;
    }
}

