/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailEntity;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailVO;
import com.ejianc.business.settle.mapper.SettlementCenterDrawPlanDetailMapper;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="settlementCenterDrawPlanDetailService")
public class SettlementCenterDrawPlanDetailServiceImpl
extends BaseServiceImpl<SettlementCenterDrawPlanDetailMapper, SettlementCenterDrawPlanDetailEntity>
implements ISettlementCenterDrawPlanDetailService {
    @Override
    public CommonResponse<JSONObject> planDetailImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        LinkedList<SettlementCenterDrawPlanDetailVO> successList = new LinkedList<SettlementCenterDrawPlanDetailVO>();
        LinkedList<SettlementCenterDrawPlanDetailVO> errorList = new LinkedList<SettlementCenterDrawPlanDetailVO>();
        if (result != null && result.size() > 0) {
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                String warnType = "";
                boolean importFlag = true;
                SettlementCenterDrawPlanDetailVO vo = new SettlementCenterDrawPlanDetailVO();
                String drwgrpCode = (String)datas.get(0);
                String drwgrpName = (String)datas.get(1);
                String startTimeStr = (String)datas.get(2);
                vo.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isNotEmpty((CharSequence)drwgrpCode)) {
                    vo.setDrwgrpCode(drwgrpCode);
                } else {
                    warnType = warnType + "\u3010\u5377\u518c\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a;";
                    importFlag = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)drwgrpName)) {
                    vo.setDrwgrpName(drwgrpName);
                } else {
                    warnType = warnType + "\u3010\u5377\u518c\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a;";
                    importFlag = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)startTimeStr)) {
                    try {
                        Date parse = sdf.parse(startTimeStr);
                        vo.setStartTime(parse);
                    }
                    catch (ParseException e) {
                        warnType = warnType + "\u3010\u5f00\u59cb\u65f6\u95f4\u3011\u683c\u5f0f\u9519\u8bef(yyyy-MM-dd);";
                        importFlag = false;
                    }
                } else {
                    warnType = warnType + "\u3010\u5f00\u59cb\u65f6\u95f4\u3011\u4e0d\u80fd\u4e3a\u7a7a;";
                    importFlag = false;
                }
                vo.setImportFlag(Boolean.valueOf(importFlag));
                vo.setWarnType(warnType);
                if (importFlag) {
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("successNum", (Object)successList.size());
        json.put("errorNum", (Object)0);
        return CommonResponse.success((Object)json);
    }
}

