package com.ejianc.business.settle.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 结算中心卷册信息表
 *
 * @author generator
 */
@Mapper
public interface SettlementCenterDcDrwgrpInfoMapper extends BaseCrudMapper<SettlementCenterDcDrwgrpInfoEntity> {
    List<Map> getRankingListForYear(@Param("major") Long major,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    List<Map> getRankingListForMonth(@Param("major") Long major,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    List<SettlementCenterDcDrwgrpInfoEntity> selectByConditionUndoneThisYear(Page<SettlementCenterDcDrwgrpInfoEntity> page, Long thirdNodeUserId);

    List<SettlementCenterDcDrwgrpInfoEntity> selectByConditionDoneThisYear(Page<SettlementCenterDcDrwgrpInfoEntity> page, Long thirdNodeUserId);

    List<Map<String, BigDecimal>> selectActionMap(@Param("thirdNodeUserId") Long thirdNodeUserId, @Param("major") Long major);

    Map<String, BigDecimal> selectSumOutput(@Param("projectIds") List<String> projectIds,@Param("commonOrgIds") List<Long> commonOrgIds);

    Object selectRankYear(@Param("thirdNodeUserId") Long thirdNodeUserId);

    Object selectRankLastMonth(@Param("thirdNodeUserId") Long thirdNodeUserId);

    Object selectRankThisMinth(@Param("thirdNodeUserId") Long thirdNodeUserId);

    List<Map> getRankingListWithOrder(@Param("major")Long major,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds,@Param("order")String order);

    List<Map> getProjectLedgerList(@Param("order")String order);
    List<Map> getMajorLedgerList(@Param("order")String order);

    List<Map> getProjectStatisticsLedgerList(@Param("projectIds")List<String> projectIds,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds,@Param("pageStart")Integer pageStart,@Param("pageSize") Integer pageSize);
    Integer countProjectStatisticsLedgerList(@Param("projectIds")List<String> projectIds,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    List<Map> queryAllProject(@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    List<Map> getMajorStatisticsLedgerList(@Param("major")Long major,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds,@Param("pageStart")Integer pageStart,@Param("pageSize") Integer pageSize);
    Integer countMajorStatisticsLedgerList(@Param("major")Long major,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    Map<String, BigDecimal> queryContractMny(@Param("projectIds") List<String> projectIds,@Param("commonOrgIds") List<Long> commonOrgIds);

    List<Map<String,Object>> selectOutputEveryMonth(@Param("projectIds")List<String> projectIds,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);
    List<Map<String,Object>> selectReplyEveryMonth(@Param("projectIds")List<String> projectIds,@Param("departmentIds")List<Long> departmentIds,@Param("commonOrgIds")List<Long> commonOrgIds);

    List<SettlementCenterDcDrwgrpInfoVO> queryNeedAddDetailData();
}
