package com.ejianc.business.settle.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.business.settle.service.ISettlementCenterDrawPlanDetailService;
import com.ejianc.business.ztpc.billcode.api.IDcDrwgrpInfoApi;
import com.ejianc.business.ztpc.billcode.bean.DcDrwgrpInfoVO;
import com.ejianc.business.ztpc.billcode.bean.QueryDrwgrpParam;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.settle.service.ISettlementCenterDrawPlanService;

/**
 * 图纸到图计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlementCenterDrawPlan")
public class SettlementCenterDrawPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISettlementCenterDrawPlanService service;
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrwgrpInfoApi dcDrwgrpInfoApi;
    @Autowired
    private ISettlementCenterDrawPlanDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> saveOrUpdate(@RequestBody SettlementCenterDrawPlanVO saveOrUpdateVO) {
    	SettlementCenterDrawPlanEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementCenterDrawPlanEntity.class);
        Map<String,Integer> numMap = new HashMap<>();
        for (SettlementCenterDrawPlanDetailEntity detailEntity : entity.getSettlementCenterDrawPlanDetailList()) {
            if ("del".equals(detailEntity.getRowState())){
                continue;
            }
            Integer i = numMap.get(detailEntity.getDrwgrpCode());
            if (i != null && i > 0){
                return CommonResponse.error(detailEntity.getDrwgrpCode()+"卷册编码重复");
            }
            numMap.put(detailEntity.getDrwgrpCode(),1);
            detailEntity.setOrgId(entity.getOrgId());
            detailEntity.setOrgCode(entity.getOrgCode());
            detailEntity.setOrgName(entity.getOrgName());
            detailEntity.setParentOrgId(entity.getParentOrgId());
            detailEntity.setParentOrgCode(entity.getParentOrgCode());
            detailEntity.setParentOrgName(entity.getParentOrgName());
            detailEntity.setProjectId(entity.getProjectId());
            detailEntity.setProjectCode(entity.getProjectCode());
            detailEntity.setProjectName(entity.getProjectName());
            detailEntity.setSettlementCenterMajor(entity.getSettlementCenterMajor());
            detailEntity.setSettlementCenterMajorName(entity.getSettlementCenterMajorName());
        }
    	service.saveOrUpdate(entity, false);
        SettlementCenterDrawPlanVO vo = BeanMapper.map(entity, SettlementCenterDrawPlanVO.class);
        CommonResponse<SettlementCenterDrawPlanVO> planVOCommonResponse = queryDetail(entity.getId());
    	return CommonResponse.success("保存或修改单据成功！", planVOCommonResponse.getData());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> queryDetail(Long id) {
        SettlementCenterDrawPlanEntity entity = service.selectById(id);
        SettlementCenterDrawPlanVO vo = BeanMapper.map(entity, SettlementCenterDrawPlanVO.class);
        List<SettlementCenterDrawPlanDetailVO> detailList = vo.getSettlementCenterDrawPlanDetailList();

        if (detailList != null && detailList.size() > 0) {
            List<String> collect = detailList.stream().map(SettlementCenterDrawPlanDetailVO::getDrwgrpCode).collect(Collectors.toList());
            QueryDrwgrpParam param = new QueryDrwgrpParam();
            param.setProjectId(vo.getProjectId());
            param.setCodeList(collect);
            CommonResponse<List<DcDrwgrpInfoVO>> listCommonResponse = dcDrwgrpInfoApi.queryListByProjectAndCodes(param);
            for (SettlementCenterDrawPlanDetailVO detailVO : detailList) {
                //查询计划卷册是否在图纸工程量中存在
                List<SettlementCenterDcDrwgrpInfoEntity> list = dcDrwgrpInfoService.list(
                        new QueryWrapper<SettlementCenterDcDrwgrpInfoEntity>().lambda()
                                .eq(SettlementCenterDcDrwgrpInfoEntity::getDr, 0)
                                .eq(SettlementCenterDcDrwgrpInfoEntity::getProjectId, vo.getProjectId())
                                .eq(SettlementCenterDcDrwgrpInfoEntity::getSystemId,vo.getId())
                                .like(SettlementCenterDcDrwgrpInfoEntity::getDcDrwgrpInfoCode, detailVO.getDrwgrpCode())
                );
                if (list != null && list.size() > 0) {
                    detailVO.setSettleFlag(true);
                } else {
                    detailVO.setSettleFlag(false);
                }

                //查询计划卷册是否在图纸库中存在
                detailVO.setDrawFlag(false);
                if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null && listCommonResponse.getData().size() > 0) {
                    for (DcDrwgrpInfoVO datum : listCommonResponse.getData()) {
                        String drwgrpCode = datum.getDrwgrpCode();
                        String code = detailVO.getDrwgrpCode();
                        if (drwgrpCode.endsWith(code)){
                            detailVO.setDrawFlag(true);
                        }
                    }
                }
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementCenterDrawPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SettlementCenterDrawPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementCenterDrawPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDrawPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("systemName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementCenterDrawPlanEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterDrawPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDrawPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementCenterDrawPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementCenterDrawPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSettlementCenterDrawPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementCenterDrawPlanVO>> refSettlementCenterDrawPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String projectId = _con.getString("projectId");
            if (StringUtils.isNotEmpty(projectId)){
                param.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
            }

            String majorId = _con.getString("majorId");
            if (StringUtils.isNotEmpty(majorId)){
                param.getParams().put("projectMajorId",new Parameter(QueryParam.EQ,majorId));
            }
        }else {
            return CommonResponse.success("查询参照数据成功！",null);
        }

        IPage<SettlementCenterDrawPlanEntity> page = service.queryPage(param,false);
        IPage<SettlementCenterDrawPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementCenterDrawPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/pullSettlementCenterDcDrwgrpInfoByPlan")
    @ResponseBody
    public CommonResponse pullSettlementCenterDcDrwgrpInfoByPlan(Long planId) {
        SettlementCenterDrawPlanEntity entity = service.selectById(planId);
        SettlementCenterDrawPlanVO vo = BeanMapper.map(entity, SettlementCenterDrawPlanVO.class);
        List<SettlementCenterDrawPlanDetailVO> detailList = vo.getSettlementCenterDrawPlanDetailList();
        List<String> codesList = detailList.stream().map(SettlementCenterDrawPlanDetailVO::getDrwgrpCode).collect(Collectors.toList());
        QueryDrwgrpParam param = new QueryDrwgrpParam();
        param.setProjectId(vo.getProjectId());
        param.setCodeList(codesList);
        CommonResponse<List<DcDrwgrpInfoVO>> listCommonResponse = dcDrwgrpInfoApi.queryListByProjectAndCodes(param);
        logger.info("图纸库匹配数据:" + JSON.toJSONString(listCommonResponse));
        List<DcDrwgrpInfoVO> data = listCommonResponse.getData();
        if (!listCommonResponse.isSuccess()) {
            return CommonResponse.error("获取到图计划信息失败!");
        }
        if (data != null && data.size() > 0) {
            logger.info("推送卷册数据开始------------");
            for (DcDrwgrpInfoVO dcDrwgrpInfo : data) {
                SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO = new SettlementCenterDcDrwgrpInfoVO();
                settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoId(dcDrwgrpInfo.getId());
                settlementCenterDcDrwgrpInfoVO.setDrawArriveDate(dcDrwgrpInfo.getDrawArriveDate());
                settlementCenterDcDrwgrpInfoVO.setDrwgrpVsn(dcDrwgrpInfo.getDrwgrpVsn());
                settlementCenterDcDrwgrpInfoVO.setSourceUnitid(dcDrwgrpInfo.getSourceUnitid() == null ? "" : dcDrwgrpInfo.getSourceUnitid().toString());
                settlementCenterDcDrwgrpInfoVO.setSourceUnitname(dcDrwgrpInfo.getSourceUnitname());
                settlementCenterDcDrwgrpInfoVO.setFirstNodeTime(new Date());
                settlementCenterDcDrwgrpInfoVO.setOrgId(dcDrwgrpInfo.getOrgId());
                settlementCenterDcDrwgrpInfoVO.setOrgCode(dcDrwgrpInfo.getOrgCode());
                settlementCenterDcDrwgrpInfoVO.setOrgName(dcDrwgrpInfo.getOrgName());
                settlementCenterDcDrwgrpInfoVO.setParentOrgId(dcDrwgrpInfo.getParentOrgId());
                settlementCenterDcDrwgrpInfoVO.setParentOrgCode(dcDrwgrpInfo.getParentOrgCode());
                settlementCenterDcDrwgrpInfoVO.setParentOrgName(dcDrwgrpInfo.getParentOrgName());
                settlementCenterDcDrwgrpInfoVO.setProjectId(dcDrwgrpInfo.getProjectId());
                settlementCenterDcDrwgrpInfoVO.setProjectCode(dcDrwgrpInfo.getProjectCode());
                settlementCenterDcDrwgrpInfoVO.setProjectName(dcDrwgrpInfo.getProjectName());
                settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoCode(dcDrwgrpInfo.getDrwgrpCode());
                settlementCenterDcDrwgrpInfoVO.setFlowState(SettleFlowStateEnum.ONE.getCode());
                settlementCenterDcDrwgrpInfoVO.setFlowStateName(SettleFlowStateEnum.ONE.getName());
                settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoName(dcDrwgrpInfo.getDrwgrpName());
                settlementCenterDcDrwgrpInfoVO.setWhetherUpgrade(0);
                settlementCenterDcDrwgrpInfoVO.setTenantId(InvocationInfoProxy.getTenantid());
                settlementCenterDcDrwgrpInfoVO.setSystemId(planId);
                settlementCenterDcDrwgrpInfoVO.setMajorId(vo.getSettlementCenterMajor() == null ? null : vo.getSettlementCenterMajor() + "");
                settlementCenterDcDrwgrpInfoVO.setSettlementCenterMajorName(vo.getSettlementCenterMajorName());
                logger.info("推送卷册中---------------------" + settlementCenterDcDrwgrpInfoVO.getDcDrwgrpInfoCode());
                dcDrwgrpInfoService.saveOrUpdateDcDrwgrpInfo(settlementCenterDcDrwgrpInfoVO);
            }
        }
            logger.info("推送卷册结束---------------");
            return CommonResponse.success();
        }

    @RequestMapping(value = "/pullSettlementCenterDcDrwgrpInfoByPlanSystem")
    @ResponseBody
    public CommonResponse pullSettlementCenterDcDrwgrpInfoByPlanSystem() {
        List<SettlementCenterDrawPlanEntity> list = service.list();
        for (SettlementCenterDrawPlanEntity drawPlanEntity : list) {
            Long planId = drawPlanEntity.getId();
            SettlementCenterDrawPlanEntity entity = service.selectById(planId);
            SettlementCenterDrawPlanVO vo = BeanMapper.map(entity, SettlementCenterDrawPlanVO.class);
            List<SettlementCenterDrawPlanDetailVO> detailList = vo.getSettlementCenterDrawPlanDetailList();
            List<String> codesList = detailList.stream().map(SettlementCenterDrawPlanDetailVO::getDrwgrpCode).collect(Collectors.toList());
            QueryDrwgrpParam param = new QueryDrwgrpParam();
            param.setProjectId(vo.getProjectId());
            param.setCodeList(codesList);
            CommonResponse<List<DcDrwgrpInfoVO>> listCommonResponse = dcDrwgrpInfoApi.queryListByProjectAndCodes(param);
            logger.info("图纸库匹配数据:" + JSON.toJSONString(listCommonResponse));
            List<DcDrwgrpInfoVO> data = listCommonResponse.getData();
            if (!listCommonResponse.isSuccess()) {
                return CommonResponse.error("获取到图计划信息失败!");
            }
            if (data != null && data.size() > 0) {
                logger.info("推送卷册数据开始------------");
                for (DcDrwgrpInfoVO dcDrwgrpInfo : data) {
                    SettlementCenterDcDrwgrpInfoVO settlementCenterDcDrwgrpInfoVO = new SettlementCenterDcDrwgrpInfoVO();
                    settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoId(dcDrwgrpInfo.getId());
                    settlementCenterDcDrwgrpInfoVO.setDrawArriveDate(dcDrwgrpInfo.getDrawArriveDate());
                    settlementCenterDcDrwgrpInfoVO.setDrwgrpVsn(dcDrwgrpInfo.getDrwgrpVsn());
                    settlementCenterDcDrwgrpInfoVO.setSourceUnitid(dcDrwgrpInfo.getSourceUnitid() == null ? "" : dcDrwgrpInfo.getSourceUnitid().toString());
                    settlementCenterDcDrwgrpInfoVO.setSourceUnitname(dcDrwgrpInfo.getSourceUnitname());
                    settlementCenterDcDrwgrpInfoVO.setFirstNodeTime(new Date());
                    settlementCenterDcDrwgrpInfoVO.setOrgId(dcDrwgrpInfo.getOrgId());
                    settlementCenterDcDrwgrpInfoVO.setOrgCode(dcDrwgrpInfo.getOrgCode());
                    settlementCenterDcDrwgrpInfoVO.setOrgName(dcDrwgrpInfo.getOrgName());
                    settlementCenterDcDrwgrpInfoVO.setParentOrgId(dcDrwgrpInfo.getParentOrgId());
                    settlementCenterDcDrwgrpInfoVO.setParentOrgCode(dcDrwgrpInfo.getParentOrgCode());
                    settlementCenterDcDrwgrpInfoVO.setParentOrgName(dcDrwgrpInfo.getParentOrgName());
                    settlementCenterDcDrwgrpInfoVO.setProjectId(dcDrwgrpInfo.getProjectId());
                    settlementCenterDcDrwgrpInfoVO.setProjectCode(dcDrwgrpInfo.getProjectCode());
                    settlementCenterDcDrwgrpInfoVO.setProjectName(dcDrwgrpInfo.getProjectName());
                    settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoCode(dcDrwgrpInfo.getDrwgrpCode());
                    settlementCenterDcDrwgrpInfoVO.setFlowState(SettleFlowStateEnum.ONE.getCode());
                    settlementCenterDcDrwgrpInfoVO.setFlowStateName(SettleFlowStateEnum.ONE.getName());
                    settlementCenterDcDrwgrpInfoVO.setDcDrwgrpInfoName(dcDrwgrpInfo.getDrwgrpName());
                    settlementCenterDcDrwgrpInfoVO.setWhetherUpgrade(0);
                    settlementCenterDcDrwgrpInfoVO.setTenantId(InvocationInfoProxy.getTenantid());
                    settlementCenterDcDrwgrpInfoVO.setSystemId(planId);
                    settlementCenterDcDrwgrpInfoVO.setMajorId(vo.getSettlementCenterMajor() == null ? null : vo.getSettlementCenterMajor() + "");
                    settlementCenterDcDrwgrpInfoVO.setSettlementCenterMajorName(vo.getSettlementCenterMajorName());
                    logger.info("推送卷册中---------------------" + settlementCenterDcDrwgrpInfoVO.getDcDrwgrpInfoCode());
                    dcDrwgrpInfoService.saveOrUpdateDcDrwgrpInfo(settlementCenterDcDrwgrpInfoVO);
                }
            }
            logger.info("推送卷册结束---------------");
        }
        return CommonResponse.success();
    }


    @RequestMapping(value = "/queryDetailForDrwgrp", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementCenterDrawPlanVO> queryDetailForDrwgrp(Long id){
        SettlementCenterDrawPlanEntity settlementCenterDrawPlanEntity = service.selectById(id);
        SettlementCenterDrawPlanVO vo = BeanMapper.map(settlementCenterDrawPlanEntity, SettlementCenterDrawPlanVO.class);
        return CommonResponse.success(vo);
    }

    /**
     * 获取到图计划卷册明细接口
     * @param planId
     * @return
     */
    @RequestMapping(value = "/queryDetailList",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettlementCenterDrawPlanDetailVO>> queryDetailList(Long planId){
        List<SettlementCenterDrawPlanDetailEntity> list = detailService.list(
                new QueryWrapper<SettlementCenterDrawPlanDetailEntity>().lambda()
                        .eq(SettlementCenterDrawPlanDetailEntity::getDr, 0)
                        .eq(SettlementCenterDrawPlanDetailEntity::getPid, planId)
        );
        if (ListUtil.isEmpty(list)){
            return CommonResponse.success();
        }else {
            List<SettlementCenterDrawPlanDetailVO> voList = BeanMapper.mapList(list, SettlementCenterDrawPlanDetailVO.class);
            return CommonResponse.success(voList);
        }
    }
}
