package com.ejianc.business.settle.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.settle.bean.SettlementCenterAlertInfoEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.bean.SettlementCenterSystemDrwgrpEntity;
import com.ejianc.business.settle.enums.SettleFlowStateEnum;
import com.ejianc.business.settle.service.ISettlementCenterSystemDrwgrpService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

@Service("settlementCenterSystemDrwgrp") 
public class SettlementCenterSystemDrwgrpBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISettlementCenterSystemDrwgrpService service;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		service.update(
				new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
						.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
						.set(SettlementCenterSystemDrwgrpEntity::getSecondNodeTime,new Date())
						.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.FOUR.getCode())
						.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName,SettleFlowStateEnum.FOUR.getName())
		);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("beforeInApprovalBack，开始回写状态，sign:"+sign+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		if ("node_b".equals(sign)){
			Long userid = InvocationInfoProxy.getUserid();
			//专职人员节点
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
							.set(SettlementCenterSystemDrwgrpEntity::getThirdNodeTime,new Date())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.FIVE.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName,SettleFlowStateEnum.FIVE.getName())
							.set(SettlementCenterSystemDrwgrpEntity::getFifthNodeTime,null)
							.set(SettlementCenterSystemDrwgrpEntity::getSixthNodeTime,null)
							.set(SettlementCenterSystemDrwgrpEntity::getSeventhNodeTime,null)
							.set(SettlementCenterSystemDrwgrpEntity::getEighthNodeTime,null)
			);
		}else if ("node_c".equals(sign)){
			//专业主管节点
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
							.set(SettlementCenterSystemDrwgrpEntity::getFourthNodeTime,new Date())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.TEN.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName,SettleFlowStateEnum.TEN.getName())
			);
		}else if ("node_d".equals(sign)){
			//结算中心项目负责人复审节点
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
							.set(SettlementCenterSystemDrwgrpEntity::getFifthNodeTime,new Date())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.TEN.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName, SettleFlowStateEnum.TEN.getName())
			);
		}else if ("node_e".equals(sign)){
			//项目合同主管节点
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
							.set(SettlementCenterSystemDrwgrpEntity::getSixthNodeTime,new Date())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.TEN.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName, SettleFlowStateEnum.TEN.getName())
			);
		}else if ("node_f".equals(sign)){
			//综合管理员节点
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
							.set(SettlementCenterSystemDrwgrpEntity::getSeventhNodeTime,new Date())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.TEN.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName, SettleFlowStateEnum.TEN.getName())
			);
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		service.update(
				new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
						.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
						.set(SettlementCenterSystemDrwgrpEntity::getEighthNodeTime,new Date())
						.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.NINE.getCode())
						.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName, SettleFlowStateEnum.NINE.getName())
		);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		service.update(
				new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
						.eq(SettlementCenterSystemDrwgrpEntity::getId,billId)
						.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.ONE.getCode())
						.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName,SettleFlowStateEnum.ONE.getName())
						.set(SettlementCenterSystemDrwgrpEntity::getStatisticalOutput, BigDecimal.ZERO)
						.set(SettlementCenterSystemDrwgrpEntity::getSecondNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getThirdNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getFourthNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getFifthNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getSixthNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getSeventhNodeTime,null)
						.set(SettlementCenterSystemDrwgrpEntity::getEighthNodeTime,null)
		);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 审批驳回事件
	 * @param businessParam
	 */
	@Override
	public void approveReject(CommonBusinessParam businessParam) {
		logger.info("审批驳回事件:businessParam-"+"【"+ JSONUtil.toJsonStr(businessParam) +"】");
		if (businessParam.getRejectTaskName() != null && businessParam.getRejectTaskName().contains("提交")){
			service.update(
					new UpdateWrapper<SettlementCenterSystemDrwgrpEntity>().lambda()
							.eq(SettlementCenterSystemDrwgrpEntity::getId,businessParam.getBillId())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowState, SettleFlowStateEnum.ONE.getCode())
							.set(SettlementCenterSystemDrwgrpEntity::getFlowStateName,SettleFlowStateEnum.ONE.getName())
			);
		}
	}
}
