package com.ejianc.business.settle.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 图纸核减情况
 * 
 * @author generator
 * 
 */
public class SettlementCenterExaminationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectMajorId; // 项目专业id
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String settlementCenterMajorName; // 结算中心专业名称
    private Long settlementCenterMajor; // 结算中心专业
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long systemId; // 系统id

    @JsonFormat(pattern = "yyyy-MM-dd" ,timezone = "GTM+8")
    private Date planStartTime; // 计划开始时间
    @JsonFormat(pattern = "yyyy-MM-dd" ,timezone = "GTM+8")
    private Date planEndTime; // 计划结束时间
    @JsonFormat(pattern = "yyyy-MM-dd" ,timezone = "GTM+8")
    private Date startTime; // 开始时间
    @JsonFormat(pattern = "yyyy-MM-dd" ,timezone = "GTM+8")
    private Date endTime; // 结束时间
    private BigDecimal submitTaxMny; // 上报金额
    private BigDecimal approveTaxMny; // 审核金额
    private BigDecimal approveSubtractRate; // 核减率
    private String statistics; // 统计人


    @ReferSerialTransfer(referCode = "project_major")
    public Long getProjectMajorId() {
        return projectMajorId;
    }

    @ReferDeserialTransfer
    public void setProjectMajorId(Long projectMajorId) {
        this.projectMajorId = projectMajorId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getSettlementCenterMajorName() {
        return settlementCenterMajorName;
    }

    public void setSettlementCenterMajorName(String settlementCenterMajorName) {
        this.settlementCenterMajorName = settlementCenterMajorName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSettlementCenterMajor() {
        return settlementCenterMajor;
    }


    @ReferDeserialTransfer
    public void setSettlementCenterMajor(Long settlementCenterMajor) {
        this.settlementCenterMajor = settlementCenterMajor;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "draw_plan")
    public Long getSystemId() {
        return systemId;
    }

    @ReferDeserialTransfer
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    public Date getPlanStartTime() {
        return planStartTime;
    }

    public void setPlanStartTime(Date planStartTime) {
        this.planStartTime = planStartTime;
    }
    public Date getPlanEndTime() {
        return planEndTime;
    }

    public void setPlanEndTime(Date planEndTime) {
        this.planEndTime = planEndTime;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public BigDecimal getSubmitTaxMny() {
        return submitTaxMny;
    }

    public void setSubmitTaxMny(BigDecimal submitTaxMny) {
        this.submitTaxMny = submitTaxMny;
    }
    public BigDecimal getApproveTaxMny() {
        return approveTaxMny;
    }

    public void setApproveTaxMny(BigDecimal approveTaxMny) {
        this.approveTaxMny = approveTaxMny;
    }
    public BigDecimal getApproveSubtractRate() {
        return approveSubtractRate;
    }

    public void setApproveSubtractRate(BigDecimal approveSubtractRate) {
        this.approveSubtractRate = approveSubtractRate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public String getStatistics() {
        return statistics;
    }

    @ReferDeserialTransfer
    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }
    
}
