package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterBudgetFeeVO;
import com.ejianc.business.settle.bean.SettlementCenterBudgetFeeVO;
import com.ejianc.business.settle.bean.SettlementCenterDcDrwgrpInfoEntity;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settle.mapper.SettlementCenterBudgetFeeMapper;
import com.ejianc.business.settle.bean.SettlementCenterBudgetFeeEntity;
import com.ejianc.business.settle.service.ISettlementCenterBudgetFeeService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 其他费用
 * 
 * @author generator
 * 
 */
@Service("settlementCenterBudgetFeeService")
public class SettlementCenterBudgetFeeServiceImpl extends BaseServiceImpl<SettlementCenterBudgetFeeMapper, SettlementCenterBudgetFeeEntity> implements ISettlementCenterBudgetFeeService{
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public CommonResponse<JSONObject> excelImport(Long settlementCenterDcDrwgrpInfoId, HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        MultipartFile mf = null;
        List<SettlementCenterBudgetFeeVO> successList = new ArrayList<>();
        List<SettlementCenterBudgetFeeVO> errorList = new ArrayList<>();
        List<SettlementCenterBudgetFeeVO> rtErrorList = new ArrayList<>();

        boolean isFailed = false;
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            mf = entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("信息超过10000条，请分批上传！");
                }
            }
            SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = dcDrwgrpInfoService.selectById(settlementCenterDcDrwgrpInfoId);
            for (int i = 1; i < result.size(); i++) {
                StringBuilder errmessage = new StringBuilder("");
                boolean flag = true;
                List<String> data = result.get(i);
                String index = data.get(0);
                String code = data.get(1);
                String name = data.get(2);
                String feeNum = data.get(5);//统计工程量
                String memo = data.get(6);//备注
                if (StringUtils.isNotEmpty(feeNum)) {
                    SettlementCenterBudgetFeeEntity one = this.getOne(
                            new QueryWrapper<SettlementCenterBudgetFeeEntity>().lambda()
                                    .eq(SettlementCenterBudgetFeeEntity::getBudgetId, drwgrpInfoEntity.getBudgeId())
                                    .eq(SettlementCenterBudgetFeeEntity::getDetailIndex, index)
                                    .eq(SettlementCenterBudgetFeeEntity::getFeeCode, code)
                                    .eq(SettlementCenterBudgetFeeEntity::getFeeName, name)
                                    .eq(SettlementCenterBudgetFeeEntity::getDcDrwgrpInfo,0)
                    );
                    if (one != null) {
                        if (StringUtils.isEmpty(feeNum)){
                            flag = false;
                            errmessage.append("[统计工程量]为空;");
                        }
                        if (flag = false){
                            SettlementCenterBudgetFeeVO vo = BeanMapper.map(one, SettlementCenterBudgetFeeVO.class);
                            vo.setErrorMessage(errmessage.toString());
                            vo.setRowIndex(i);
                            errorList.add(vo);
                            continue;
                        }
                        one.setParentId(one.getId());
                        one.setId(IdWorker.getId());
                        one.setSettlementCenterFeeNum(new BigDecimal(feeNum));
                        if (one.getFeeTaxPrice() != null) {
                            //统计产值(含税)
                            one.setSettlementCenterFeeTaxMny(new BigDecimal(feeNum).multiply(one.getFeeTaxPrice()));
                        }else {
                            one.setSettlementCenterFeeTaxMny(BigDecimal.ZERO);
                        }
                        if (one.getSettlementCenterFeeTaxMny() != null && !one.getSettlementCenterFeeTaxMny().equals(BigDecimal.ZERO)
                                && one.getFeeTaxRate() != null && !one.getFeeTaxRate().equals(BigDecimal.ZERO)
                        ){
                            //统计产值(无税)
                            one.setSettlementCenterFeeMny(one.getSettlementCenterFeeTaxMny().divide(new BigDecimal(1).add(new BigDecimal(0.01).multiply(one.getFeeTaxRate())),2, RoundingMode.HALF_DOWN));
                            //税额
                            one.setSettlementCenterFeeTax(one.getSettlementCenterFeeMny().multiply(one.getFeeTaxRate()).multiply(new BigDecimal(0.01)));

                        }else {
                            one.setSettlementCenterFeeMny(BigDecimal.ZERO);
                            one.setSettlementCenterFeeTax(BigDecimal.ZERO);
                        }
                        one.setDcDrwgrpInfo(drwgrpInfoEntity.getId());
                        if (StringUtils.isNotEmpty(memo)){
                            one.setFeeMemo(memo);
                        }
                        SettlementCenterBudgetFeeVO vo = BeanMapper.map(one, SettlementCenterBudgetFeeVO.class);
                        successList.add(vo);
                    }else {
                        SettlementCenterBudgetFeeVO vo = new SettlementCenterBudgetFeeVO();
                        logger.info("第"+i+"行数据:"+ StringUtils.join(data,","));
                        vo.setRowIndex(i);
                        vo.setErrorMessage("明细未找到");
                        errorList.add(vo);
                    }

                }

            }


        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(SettlementCenterBudgetFeeVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        return success;
    }
}
