package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.service.ISettlementCenterDcDrwgrpInfoService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settle.mapper.SettlementCenterBudgetMeasureMapper;
import com.ejianc.business.settle.bean.SettlementCenterBudgetMeasureEntity;
import com.ejianc.business.settle.service.ISettlementCenterBudgetMeasureService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 设备及安装工程
 * 
 * @author generator
 * 
 */
@Service("settlementCenterBudgetMeasureService")
public class SettlementCenterBudgetMeasureServiceImpl extends BaseServiceImpl<SettlementCenterBudgetMeasureMapper, SettlementCenterBudgetMeasureEntity> implements ISettlementCenterBudgetMeasureService{
    @Autowired
    private ISettlementCenterDcDrwgrpInfoService dcDrwgrpInfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public CommonResponse<JSONObject> excelImport(Long settlementCenterDcDrwgrpInfoId, HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();

        MultipartFile mf = null;
        List<SettlementCenterBudgetMeasureVO> successList = new ArrayList<>();
        List<SettlementCenterBudgetMeasureVO> errorList = new ArrayList<>();
        List<SettlementCenterBudgetMeasureVO> rtErrorList = new ArrayList<>();
        boolean isFailed = false;
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            mf = entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("信息超过10000条，请分批上传！");
                }
            }
            SettlementCenterDcDrwgrpInfoEntity drwgrpInfoEntity = dcDrwgrpInfoService.selectById(settlementCenterDcDrwgrpInfoId);
            for (int i = 1; i < result.size(); i++) {
                StringBuilder errmessage = new StringBuilder("");
                boolean flag = true;
                List<String> data = result.get(i);
                String index = data.get(0);
                String code = data.get(1);
                String name = data.get(2);
                String measureNum = data.get(5);//统计工程量
                String memo = data.get(6);//备注
                if (StringUtils.isNotEmpty(measureNum)) {
                    SettlementCenterBudgetMeasureEntity one = this.getOne(
                            new QueryWrapper<SettlementCenterBudgetMeasureEntity>().lambda()
                                    .eq(SettlementCenterBudgetMeasureEntity::getBudgetId, drwgrpInfoEntity.getBudgeId())
                                    .eq(SettlementCenterBudgetMeasureEntity::getDetailIndex, index)
                                    .eq(SettlementCenterBudgetMeasureEntity::getMeasureCode, code)
                                    .eq(SettlementCenterBudgetMeasureEntity::getMeasureName, name)
                                    .eq(SettlementCenterBudgetMeasureEntity::getDcDrwgrpInfo,0)
                    );
                    if (one != null) {
                        if (StringUtils.isEmpty(measureNum)){
                            flag = false;
                            errmessage.append("[统计工程量]为空;");
                        }
                        
                        if (flag = false){
                            SettlementCenterBudgetMeasureVO vo = BeanMapper.map(one, SettlementCenterBudgetMeasureVO.class);
                            vo.setErrorMessage(errmessage.toString());
                            vo.setRowIndex(i);
                            errorList.add(vo);
                            continue;
                        }
                        one.setParentId(one.getId());
                        one.setId(IdWorker.getId());
                        BigDecimal settlementCenterMeasureNum = new BigDecimal(measureNum);
                        one.setSettlementCenterMeasureNum(settlementCenterMeasureNum);
                        BigDecimal settlementCenterMeasureTaxMny = BigDecimal.ZERO;
                        if (one.getMeasurePriceEquipment() != null && !one.getMeasurePriceEquipment().equals(BigDecimal.ZERO)) {
                            settlementCenterMeasureTaxMny = settlementCenterMeasureTaxMny.add(settlementCenterMeasureNum.multiply(one.getMeasurePriceEquipment()));
                        }
                        if (one.getMeasurePriceInstall() != null && !one.getMeasurePriceInstall().equals(BigDecimal.ZERO)) {
                            settlementCenterMeasureTaxMny = settlementCenterMeasureTaxMny.add(settlementCenterMeasureNum.multiply(one.getMeasurePriceInstall()));
                        }
                        if (one.getMeasurePriceMaterial() != null && !one.getMeasurePriceMaterial().equals(BigDecimal.ZERO)) {
                            settlementCenterMeasureTaxMny = settlementCenterMeasureTaxMny.add(settlementCenterMeasureNum.multiply(one.getMeasurePriceMaterial()));
                        }
                        //统计产值(含税)
                        one.setSettlementCenterMeasureTaxMny(settlementCenterMeasureTaxMny);

                        if (one.getSettlementCenterMeasureTaxMny() != null && !one.getSettlementCenterMeasureTaxMny().equals(BigDecimal.ZERO)
                                && one.getMeasureTaxRate() != null && !one.getMeasureTaxRate().equals(BigDecimal.ZERO)
                        ){
                            //统计产值(无税)
                            one.setSettlementCenterMeasureMny(one.getSettlementCenterMeasureTaxMny().divide(new BigDecimal(1).add(new BigDecimal(0.01).multiply(one.getMeasureTaxRate())),2, RoundingMode.HALF_DOWN));
                            //税额
                            one.setSettlementCenterMeasureTax(one.getSettlementCenterMeasureMny().multiply(one.getMeasureTaxRate()).multiply(new BigDecimal(0.01)));

                        }else {
                            one.setSettlementCenterMeasureMny(BigDecimal.ZERO);
                            one.setSettlementCenterMeasureTax(BigDecimal.ZERO);
                        }
                        if (StringUtils.isNotEmpty(memo)){
                            one.setMeasureMemo(memo);
                        }
                        one.setDcDrwgrpInfo(drwgrpInfoEntity.getId());
                        SettlementCenterBudgetMeasureVO vo = BeanMapper.map(one, SettlementCenterBudgetMeasureVO.class);
                        successList.add(vo);
                    }else {
                        SettlementCenterBudgetMeasureVO vo = new SettlementCenterBudgetMeasureVO();
                        logger.info("第"+i+"行数据:"+ StringUtils.join(data,","));
                        vo.setRowIndex(i);
                        vo.setErrorMessage("明细未找到");
                        errorList.add(vo);
                    }

                }

            }


        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        rtErrorList = errorList.stream().sorted(Comparator.comparing(SettlementCenterBudgetMeasureVO::getRowIndex)).collect(Collectors.toList());
        json.put("errorList", rtErrorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        return success;
    }
}
