package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.settle.bean.SettlementCenterDrawPlanDetailVO;
import com.ejianc.business.settle.vo.SettlementCenterCompareDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.settle.mapper.SettlementCenterCompareDetailMapper;
import com.ejianc.business.settle.bean.SettlementCenterCompareDetailEntity;
import com.ejianc.business.settle.service.ISettlementCenterCompareDetailService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 结算中心系统工程量速查对照表明细
 * 
 * @author generator
 * 
 */
@Service("settlementCenterCompareDetailService")
public class SettlementCenterCompareDetailServiceImpl extends BaseServiceImpl<SettlementCenterCompareDetailMapper, SettlementCenterCompareDetailEntity> implements ISettlementCenterCompareDetailService{

    @Override
    public CommonResponse<JSONObject> compareDetailImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<SettlementCenterCompareDetailVO> successList = new LinkedList<>();
            List<SettlementCenterCompareDetailVO> errorList = new LinkedList<>();
            if (result != null && result.size() > 0) {
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    String warnType = "";
                    boolean importFlag = true;
                    SettlementCenterCompareDetailVO vo = new SettlementCenterCompareDetailVO();
                    String incomeIndex = datas.get(0);
                    String incomeCode = datas.get(1);
                    String incomeName = datas.get(2);
                    String incomeDetailRules = datas.get(3);
                    String incomeDetailUnit = datas.get(4);
//                    String incomeContractNum = datas.get(5);
//                    String incomeDrawNum = datas.get(6);
                    String prosubIndex = datas.get(7);
                    String prosubCode = datas.get(8);
                    String prosubName = datas.get(9);
                    String prosubDetailRules = datas.get(10);
                    String prosubDetailUnit = datas.get(11);
//                    String prosubContractNum = datas.get(12);
//                    String prosubDrawNum = datas.get(13);

                    if (StringUtils.isNotEmpty(incomeIndex) && StringUtils.isNotEmpty(incomeIndex.trim())){
                        vo.setIncomeIndex(incomeIndex.trim());
                    }

                    if (StringUtils.isNotEmpty(incomeCode) && StringUtils.isNotEmpty(incomeCode.trim())){
                        vo.setIncomeCode(incomeCode.trim());
                    }

                    if (StringUtils.isNotEmpty(incomeName) && StringUtils.isNotEmpty(incomeName.trim())){
                        vo.setIncomeName(incomeName.trim());
                    }

                    if (StringUtils.isNotEmpty(incomeDetailRules) && StringUtils.isNotEmpty(incomeDetailRules.trim())){
                        vo.setIncomeDetailRules(incomeDetailRules.trim());
                    }

                    if (StringUtils.isNotEmpty(incomeDetailUnit) && StringUtils.isNotEmpty(incomeDetailUnit.trim())){
                        vo.setIncomeDetailUnit(incomeDetailUnit.trim());
                    }
//                    if (StringUtils.isNotEmpty(incomeContractNum) && StringUtils.isNotEmpty(incomeContractNum.trim())){
//                        vo.setIncomeContractNum(new BigDecimal(incomeContractNum));
//                    }
//                    if (StringUtils.isNotEmpty(incomeDrawNum) && StringUtils.isNotEmpty(incomeDrawNum.trim())){
//                        vo.setIncomeDrawNum(new BigDecimal(incomeDrawNum));
//                    }

                    if (StringUtils.isNotEmpty(prosubIndex) && StringUtils.isNotEmpty(prosubIndex.trim())){
                        vo.setProsubIndex(prosubIndex.trim());
                    }

                    if (StringUtils.isNotEmpty(prosubCode) && StringUtils.isNotEmpty(prosubCode.trim())){
                        vo.setProsubCode(prosubCode.trim());
                    }

                    if (StringUtils.isNotEmpty(prosubName) && StringUtils.isNotEmpty(prosubName.trim())){
                        vo.setProsubName(prosubName.trim());
                    }

                    if (StringUtils.isNotEmpty(prosubDetailRules) && StringUtils.isNotEmpty(prosubDetailRules.trim())){
                        vo.setProsubDetailRules(prosubDetailRules.trim());
                    }

                    if (StringUtils.isNotEmpty(prosubDetailUnit) && StringUtils.isNotEmpty(prosubDetailUnit.trim())){
                        vo.setProsubDetailUnit(prosubDetailUnit.trim());
                    }

//                    if (StringUtils.isNotEmpty(prosubContractNum) && StringUtils.isNotEmpty(prosubContractNum.trim())){
//                        vo.setProsubContractNum(new BigDecimal(prosubContractNum));
//                    }

//                    if (StringUtils.isNotEmpty(prosubDrawNum) && StringUtils.isNotEmpty(prosubDrawNum.trim())){
//                        vo.setProsubDrawNum(new BigDecimal(prosubDrawNum));
//                    }


                    vo.setId(IdWorker.getId());

                    vo.setImportFlag(importFlag);
                    vo.setWarnType(warnType);
                    if (importFlag){
                        successList.add(vo);
                    }else {
                        errorList.add(vo);
                    }
                }
            }

            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            json.put("successNum", successList.size());
            json.put("errorNum", 0);
            return CommonResponse.success(json);
        }
    }
}
