package com.ejianc.business.settlementmanage.api;

import com.ejianc.business.settlementmanage.hystrix.SettlementHystrix;
import com.ejianc.business.settlementmanage.vo.SettlementCountersignVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-settlementmanage-web", url="${common.env.feign-client-url}", path="ejc-settlementmanage-web", fallback = SettlementHystrix.class)
public interface ISettlementApi {

	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/settlementCountersign/querySettleById")
    CommonResponse<SettlementCountersignVO> querySettleById(@RequestParam Long contractId);
}
