package com.ejianc.business.settlementmanage.api;

import com.ejianc.business.settlementmanage.hystrix.CostManageHystrix;
import com.ejianc.business.settlementmanage.hystrix.SettlementHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(name= "ejc-settlementmanage-web", url="${common.env.feign-client-url}", path="ejc-settlementmanage-web", fallback = CostManageHystrix.class)
public interface ICostManageApi {

    /**
     * 成本管理-成本核算:部品部件及材料费
     * @param projectId
     * @param time
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryCostaccountPartmaterial")
    CommonResponse<BigDecimal> queryCostaccountPartmaterial(@RequestParam("projectId") Long projectId, @RequestParam("time") String time);

    /**
     * 成本管理-成本核算:机械费
     * @param projectId
     * @param time
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryCostaccountMechanical")
    CommonResponse<BigDecimal> queryCostaccountMechanical(@RequestParam("projectId") Long projectId,@RequestParam("time") String time);

    /**
     * 成本管理-项目部商务经理月度报告：竣工工程结算额
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryProjectreportSettlement")
    CommonResponse<BigDecimal> queryProjectreportSettlement(@RequestParam("contractId") Long contractId);
}
