package com.ejianc.business.settlementmanage.api;

import com.ejianc.business.settlementmanage.hystrix.SettlementBookHystrix;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookSumVo;
import com.ejianc.business.settlementmanage.vo.SubDetailVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-settlementmanage-web", url="${common.env.feign-client-url}", path="ejc-settlementmanage-web", fallback = SettlementBookHystrix.class)
public interface ISettlementBookApi {

	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/settlementBookStatementDetail/queryActualCost")
    CommonResponse<List<SettlementBookStatementDetailVO>> queryActualCost(@RequestParam("projectId") Long projectId,
																		  @RequestParam("subitemCode") String subitemCode,
																		  @RequestParam("section") String section,
																		  @RequestParam("reportingMonth") String reportingMonth);


	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/settlementBookStatementDetail/queryActualSumCost")
	CommonResponse<SettlementBookSumVo> queryActualSumCost(@RequestParam("projectId") Long projectId,
																 @RequestParam("reportingMonth") String reportingMonth);


	@GetMapping(value = "/api/settlementBookStatementDetail/getAccruingAmountsTax")
	CommonResponse<SubDetailVo> getAccruingAmountsTax(@RequestParam(value = "projectId") Long projectId, @RequestParam Date reportingMonth);

}
