package com.ejianc.business.settlementmanage.api;

import com.ejianc.business.settlementmanage.hystrix.CostManageHystrix;
import com.ejianc.business.settlementmanage.hystrix.SettlementHystrix;
import com.ejianc.business.settlementmanage.vo.CostManageVO;
import com.ejianc.business.settlementmanage.vo.LaborCostRequestVO;
import com.ejianc.business.settlementmanage.vo.LaborCostVO;
import com.ejianc.business.settlementmanage.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@FeignClient(name= "ejc-settlementmanage-web", url="${common.env.feign-client-url}", path="ejc-settlementmanage-web", fallback = CostManageHystrix.class)
public interface ICostManageApi {

    /**
     * 成本管理-成本核算:部品部件及材料费
     * @param projectId
     * @param time
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryCostaccountPartmaterial")
    CommonResponse<BigDecimal> queryCostaccountPartmaterial(@RequestParam("projectId") Long projectId, @RequestParam("time") String time);

    /**
     * 成本管理-成本核算:机械费
     * @param projectId
     * @param time
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryCostaccountMechanical")
    CommonResponse<BigDecimal> queryCostaccountMechanical(@RequestParam("projectId") Long projectId,@RequestParam("time") String time);

    /**
     * 成本管理-项目部商务经理月度报告：竣工工程结算额
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryProjectreportSettlement")
    CommonResponse<BigDecimal> queryProjectreportSettlement(@RequestParam("contractId") Long contractId);
    /**
     *项目月度成本分析报告
     * 获取结算书金额
     * @param laborCostRequestVO
     * @return
     */
    @PostMapping(value = "/api/costmanage/queryLabor")
    @ResponseBody
    CommonResponse<Map<String,LaborCostVO>> queryLabor(@RequestBody LaborCostRequestVO laborCostRequestVO);

    /**
     * 查询设计类最终结算清单数量和合价
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/costmanage/queryDesignSettlement")
    @ResponseBody
    CommonResponse<List<CostManageVO>> queryDesignSettlement(@RequestParam(value = "contractId") Long contractId);

    /**
     * 查询资讯类最终结算清单数量和合价
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/api/costmanage/queryConsultotherfinal", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<CostManageVO>> queryConsultotherfinal(@RequestParam(value = "contractId") Long contractId);

    /**
     * * 成本管理-根据项目、时间、合同类型查询工程项目结算书工程清单结算所有数据
     * @param projectId
     * @param contractType
     * @param time
     * @return
     */

    @PostMapping(value = "/api/costmanage/queryStatementAll")
    CommonResponse<List<LaborCostVO>> queryStatementAll(@RequestParam String projectId,@RequestParam String contractType,@RequestParam String time);
}
