package com.ejianc.business.settlementmanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 工程分包结算书子表-收入明细表-工程量清单结算表
 *
 * @author generator
 *
 */
public class SettlementBookStatementDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long mid; // 主表id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long sort; // 序号
    private String listingCode; // 清单编码
    private String units; // 单位
    private BigDecimal quantities; // 工程量
    private BigDecimal extaxUnitprice; // 合同单价除税
    private BigDecimal intaxUnitprice; // 合同单价含税
    private BigDecimal exsettlementUnitprice; // 结算除税单价
    private BigDecimal insettlementUnitprice; // 结算含税单价
    private BigDecimal extaxAddition; // 除税合价
    private BigDecimal intaxAddition; // 含税合价
    private String remarks; // 备注
    private String partProjectName; // 分部分项工程名称
    private String source; // 来源
    private BigDecimal thisEngineeringQuantity;  //本期报量工程
    private BigDecimal thisAmountsNotax;  //本次报量金额(除税)
    private BigDecimal thisAmountsTax;  //本次报量金额(含税)

    private String tid;
    private String tpid;
    private String errorMsg;
    private String innercode;
    private String section; // 区段
    private String subitemDesc; // 子目特征描述
    private List<SettlementBookStatementDetailVO> children = new ArrayList<>();

    public String getInnercode() {
        return innercode;
    }

    public BigDecimal getThisEngineeringQuantity() {
        return thisEngineeringQuantity;
    }

    public void setThisEngineeringQuantity(BigDecimal thisEngineeringQuantity) {
        this.thisEngineeringQuantity = thisEngineeringQuantity;
    }

    public BigDecimal getThisAmountsNotax() {
        return thisAmountsNotax;
    }

    public void setThisAmountsNotax(BigDecimal thisAmountsNotax) {
        this.thisAmountsNotax = thisAmountsNotax;
    }

    public BigDecimal getThisAmountsTax() {
        return thisAmountsTax;
    }

    public void setThisAmountsTax(BigDecimal thisAmountsTax) {
        this.thisAmountsTax = thisAmountsTax;
    }

    public void setInnercode(String innercode) {
        this.innercode = innercode;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<SettlementBookStatementDetailVO> getChildren() {
        return children;
    }

    public void setChildren(List<SettlementBookStatementDetailVO> children) {
        this.children = children;
    }

    /**
     * 主表id
     */
    public Long getMid() {
        return mid;
    }

    /**
     * 主表id
     */
    public void setMid(Long mid) {
        this.mid = mid;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 序号
     */
    public Long getSort() {
        return sort;
    }

    /**
     * 序号
     */
    public void setSort(Long sort) {
        this.sort = sort;
    }
    /**
     * 清单编码
     */
    public String getListingCode() {
        return listingCode;
    }

    /**
     * 清单编码
     */
    public void setListingCode(String listingCode) {
        this.listingCode = listingCode;
    }
    /**
     * 单位
     */
    public String getUnits() {
        return units;
    }

    /**
     * 单位
     */
    public void setUnits(String units) {
        this.units = units;
    }

    public BigDecimal getQuantities() {
        return quantities;
    }

    public void setQuantities(BigDecimal quantities) {
        this.quantities = quantities;
    }

    public BigDecimal getExtaxUnitprice() {
        return extaxUnitprice;
    }

    public void setExtaxUnitprice(BigDecimal extaxUnitprice) {
        this.extaxUnitprice = extaxUnitprice;
    }

    /**
     * 合同单价含税
     */
    public BigDecimal getIntaxUnitprice() {
        return intaxUnitprice;
    }

    /**
     * 合同单价含税
     */
    public void setIntaxUnitprice(BigDecimal intaxUnitprice) {
        this.intaxUnitprice = intaxUnitprice;
    }
    /**
     * 结算除税单价
     */
    public BigDecimal getExsettlementUnitprice() {
        return exsettlementUnitprice;
    }

    /**
     * 结算除税单价
     */
    public void setExsettlementUnitprice(BigDecimal exsettlementUnitprice) {
        this.exsettlementUnitprice = exsettlementUnitprice;
    }
    /**
     * 结算含税单价
     */
    public BigDecimal getInsettlementUnitprice() {
        return insettlementUnitprice;
    }

    /**
     * 结算含税单价
     */
    public void setInsettlementUnitprice(BigDecimal insettlementUnitprice) {
        this.insettlementUnitprice = insettlementUnitprice;
    }
    /**
     * 除税合价
     */
    public BigDecimal getExtaxAddition() {
        return extaxAddition;
    }

    /**
     * 除税合价
     */
    public void setExtaxAddition(BigDecimal extaxAddition) {
        this.extaxAddition = extaxAddition;
    }
    /**
     * 含税合价
     */
    public BigDecimal getIntaxAddition() {
        return intaxAddition;
    }

    /**
     * 含税合价
     */
    public void setIntaxAddition(BigDecimal intaxAddition) {
        this.intaxAddition = intaxAddition;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getPartProjectName() {
        return partProjectName;
    }

    public void setPartProjectName(String partProjectName) {
        this.partProjectName = partProjectName;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSection() {
        return section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getSubitemDesc() {
        return subitemDesc;
    }

    public void setSubitemDesc(String subitemDesc) {
        this.subitemDesc = subitemDesc;
    }
}
