package com.ejianc.business.settlementmanage.api;

import com.ejianc.business.settlementmanage.hystrix.CostManageHystrix;
import com.ejianc.business.settlementmanage.hystrix.SettlementStateApiHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;

/**
 * @author yupengjie
 * @createDate 2023/1/12
 * @description
 */
@FeignClient(name= "ejc-settlementmanage-web", url="${common.env.feign-client-url}", path="ejc-settlementmanage-web", fallback = SettlementStateApiHystrix.class)
public interface SettlementStateApi {
    /**
     * 成本管理坐月度成本分析更新所有涉及的结算管理的单据为：
     *设计结算相关单据 ：咨询及其他结算单  设计结算单  机械租赁结算   物资采购结算  工程分包结算
     * @param projectId 项目id
     * @param state    归集状态
     * @param monthStr 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     */
    @GetMapping(value = "/api/settlementStateApi/updateSettlementState")
    CommonResponse<String> updateMidSettlementState(@RequestParam("projectId")Long projectId,
                                            @RequestParam("state")Integer state,
                                            @RequestParam("monthStr")String monthStr);
    /***
     * @Description //TODO  查询校验月度成本分析涉及的中间计量的单据是否有未归集的数据
     * 成本管理坐月度成本分析更新所有涉及的结算管理的单据为：
     *设计结算相关单据 ：咨询及其他结算单  设计结算单  机械租赁结算   物资采购结算  工程分包结算
     * @param projectId  项目id
     * @param monthStr    要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @GetMapping(value = "/api/settlementStateApi/queryIsSettlement")
    CommonResponse<String> queryIsSettlement(@RequestParam("projectId")Long projectId,
                                     @RequestParam("monthStr")String monthStr);
}
