package com.ejianc.business.settlementmanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 影响总包结算的关键事项清单分包分供
 * 
 * @author generator
 * 
 */
public class EventWorkDoneVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long mid; // 主表id
    private BigDecimal completedSettlement; // 已完成结算项
    private BigDecimal unfinishedSettlement; // 未完成结算项
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime; // 预计完成时间
    private BigDecimal unfinishedReason; // 分包结算未完成原因
    

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public BigDecimal getCompletedSettlement() {
        return completedSettlement;
    }

    public void setCompletedSettlement(BigDecimal completedSettlement) {
        this.completedSettlement = completedSettlement;
    }
    public BigDecimal getUnfinishedSettlement() {
        return unfinishedSettlement;
    }

    public void setUnfinishedSettlement(BigDecimal unfinishedSettlement) {
        this.unfinishedSettlement = unfinishedSettlement;
    }
    public Date getCompletionTime() {
        return completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }
    public BigDecimal getUnfinishedReason() {
        return unfinishedReason;
    }

    public void setUnfinishedReason(BigDecimal unfinishedReason) {
        this.unfinishedReason = unfinishedReason;
    }
    
}
