package com.ejianc.business.settlementmanage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 总包结算定案会签表-主表
 *
 * @author generator
 *
 */
public class SettlementFinalizedVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String agentName; // 经办人
    private String contractName; // 合同名称
    private String developer; // 发包人
    private java.math.BigDecimal cost; // 成本(不含上缴)
    private String structureType; // 结构类型
    private String contractScope; // 承包范围
    private Double constructionArea; // 建筑面积
    private java.math.BigDecimal settlementValue; // 结算值
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestDeadline; // 审批最迟期限
    private String latestDeadlineStr;
    private String remarks; // 备注
    private Long agentId; // 经办人id
    private Long agentDepartment; // 经办人部门
    private Long contractId; // 合同id
    private Long developerId; // 发包人id
    private String createTimeShow; // 创建时间文本显示
    private String billStateStr; // 单据状态Str
    private Long originalId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date businessDate; //业务日期


    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 经办人
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 发包人
     */
    public String getDeveloper() {
        return developer;
    }

    /**
     * 发包人
     */
    public void setDeveloper(String developer) {
        this.developer = developer;
    }
    /**
     * 成本(不含上缴)
     */
    public java.math.BigDecimal getCost() {
        return cost;
    }

    /**
     * 成本(不含上缴)
     */
    public void setCost(java.math.BigDecimal cost) {
        this.cost = cost;
    }
    /**
     * 结构类型
     */
    public String getStructureType() {
        return structureType;
    }

    /**
     * 结构类型
     */
    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }
    /**
     * 承包范围
     */
    public String getContractScope() {
        return contractScope;
    }

    /**
     * 承包范围
     */
    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }
    /**
     * 建筑面积
     */
    public Double getConstructionArea() {
        return constructionArea;
    }

    /**
     * 建筑面积
     */
    public void setConstructionArea(Double constructionArea) {
        this.constructionArea = constructionArea;
    }
    /**
     * 结算值
     */
    public java.math.BigDecimal getSettlementValue() {
        return settlementValue;
    }

    /**
     * 结算值
     */
    public void setSettlementValue(java.math.BigDecimal settlementValue) {
        this.settlementValue = settlementValue;
    }
    /**
     * 审批最迟期限
     */
    public Date getLatestDeadline() {
        return latestDeadline;
    }

    /**
     * 审批最迟期限
     */
    public void setLatestDeadline(Date latestDeadline) {
        this.latestDeadline = latestDeadline;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")

    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人部门
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getAgentDepartment() {
        return agentDepartment;
    }

    /**
     * 经办人部门
     */
    @ReferDeserialTransfer
    public void setAgentDepartment(Long agentDepartment) {
        this.agentDepartment = agentDepartment;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")

    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 发包人id
     */
    @ReferSerialTransfer(referCode="support-customer")

    public Long getDeveloperId() {
        return developerId;
    }

    /**
     * 发包人id
     */
    @ReferDeserialTransfer

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getLatestDeadlineStr() {
        return latestDeadlineStr;
    }

    public void setLatestDeadlineStr(String latestDeadlineStr) {
        this.latestDeadlineStr = latestDeadlineStr;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
}
