package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.PriceDepotParamSetHystrix;
import com.ejianc.foundation.share.vo.PriceDepotParamSetVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 价格库参数设置
 */
@FeignClient(name = "ejc-share-web", url = "${common.env.feign-client-url}", path = "ejc-share-web", fallback = PriceDepotParamSetHystrix.class)
public interface IPriceDepotParamSetApi {


    @GetMapping(value = "/api/priceDepotParamSetApi/queryPriceDepotParamSetList")
    CommonResponse<List<PriceDepotParamSetDTO>> queryPriceDepotParamSetList(@RequestParam(value = "priceDepotType") Integer priceDepotType);
}
