package com.ejianc.foundation.support.api;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.hystrix.ShareSupplierHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 供应商API
 *
 * @author CJ
 * @Description:
 * @date 2020/6/30 14:58
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareSupplierHystrix.class)
public interface IShareSupplierApi {

    /**
     * 根据供应商Id查询供应商信息
     *
     * @param id 供应商Id
     * @return
     */
    @GetMapping("/api/shareSupplierApi/queryById")
    CommonResponse<SupplierDTO> queryById(@RequestParam(value = "id") Long id);

    /**
     * 根据ids查询项目详情
     *
     * @param
     * @return
     */
    @GetMapping(value = "/api/shareSupplierApi/querySupplierByIds")
    CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value = "ids") List<Long> ids);

    @GetMapping("/api/shareSupplierApi/findOneByName")
    public CommonResponse<SupplierVO> findOneByName(@RequestParam(value = "name") String name,
            @RequestParam(value = "tenantId") Long tenantId);

    /**
     * 根据ids查询项目详情
     *
     * @param
     * @return
     */
    @GetMapping(value = "/api/shareSupplierApi/querySupplierDTOByIds")
    CommonResponse<List<SupplierDTO>> querySupplierDTOByIds(@RequestParam(value = "ids") List<Long> ids);
}
