package com.ejianc.foundation.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商类别变更-分包负责人实体
 * 
 * @author generator
 * 
 */
public class SupplierTypeChangeSubLeaderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表id
    private String name; // 姓名
    private String idNum; // 身份证号
    private String phone; // 手机号
    private Long grade; // 等级
    private String gradeName; // 等级名称
    private Long ejcUserId; // 生成的公有云租户超级管理员用户id
    private Long ejcTenantId; // 生成的公有云租户id
    private Long systemId; // 系统id 对应公有云企业id
    private Boolean coordination; // 是否协同
    private Integer inException; // 是否异常
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exceptionEndDate; // 异常结束时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastCoDate; // 最近合作时间
    private Long punishType; // 供应商状态 处置方式 红黑牌等的id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date punishDate; // 处置日期
    private String punishApplyOrg; // 处置申请单位
    private String punishApplyPerson; // 处置申请人
    private String punishOldGrade; // 处置原等级
    private String punishGrade; // 处置等级
    private String punishMemo; // 处置理由
    private String contentId; // 供货内容id
    private Long sourceId; // 来源id

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGrade() {
        return grade;
    }
    @ReferDeserialTransfer
    public void setGrade(Long grade) {
        this.grade = grade;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public Long getEjcUserId() {
        return ejcUserId;
    }

    public void setEjcUserId(Long ejcUserId) {
        this.ejcUserId = ejcUserId;
    }
    public Long getEjcTenantId() {
        return ejcTenantId;
    }

    public void setEjcTenantId(Long ejcTenantId) {
        this.ejcTenantId = ejcTenantId;
    }
    public Long getSystemId() {
        return systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public Boolean getCoordination() {
        return coordination;
    }

    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }

    public Integer getInException() {
        return inException;
    }

    public void setInException(Integer inException) {
        this.inException = inException;
    }
    public Date getExceptionEndDate() {
        return exceptionEndDate;
    }

    public void setExceptionEndDate(Date exceptionEndDate) {
        this.exceptionEndDate = exceptionEndDate;
    }
    public Date getLastCoDate() {
        return lastCoDate;
    }

    public void setLastCoDate(Date lastCoDate) {
        this.lastCoDate = lastCoDate;
    }
    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }
    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    public Date getPunishDate() {
        return punishDate;
    }

    public void setPunishDate(Date punishDate) {
        this.punishDate = punishDate;
    }
    public String getPunishApplyOrg() {
        return punishApplyOrg;
    }

    public void setPunishApplyOrg(String punishApplyOrg) {
        this.punishApplyOrg = punishApplyOrg;
    }
    public String getPunishApplyPerson() {
        return punishApplyPerson;
    }

    public void setPunishApplyPerson(String punishApplyPerson) {
        this.punishApplyPerson = punishApplyPerson;
    }
    public String getPunishOldGrade() {
        return punishOldGrade;
    }

    public void setPunishOldGrade(String punishOldGrade) {
        this.punishOldGrade = punishOldGrade;
    }
    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }
    public String getPunishMemo() {
        return punishMemo;
    }

    public void setPunishMemo(String punishMemo) {
        this.punishMemo = punishMemo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getContentId() {
        return contentId;
    }

    @ReferDeserialTransfer
    public void setContentId(String contentId) {
        this.contentId = contentId;
    }
    
}
