package com.ejianc.foundation.share.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 供应商准入--分包负责人
 * 
 * @author generator
 * 
 */
public class SubleadersVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 姓名
    private String idNum; // 身份证号
    private String phone; // 手机号
    private Long grade; // 等级
    private String gradeName; // 等级名称
    private Long pid; //  供应商id

    private Boolean coordination; // 是否协同
    private Boolean inException; // 是否异常
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exceptionEndDate; // 异常结束时间
    private Date lastCoDate; // 最近合作时间

    private Long punishType; // 供应商状态 处置方式 红黑牌等的id
    private Date punishDate; // 处置日期
    private String punishApplyOrg; // 处置申请单位
    private String punishApplyPerson; // 处置申请人
    private String punishOldGrade; // 处置原等级
    private String punishGrade; // 处置等级
    private String punishMemo; // 处置理由


    private String supplierContent; // 供货内容
    private String supplierName; // 供应商的名称
    private String supplierGrade; // 供应商的等级
    private String area; // 供应商的地区
    private String supplierCode; // 供应商的编号
    private String personal; // 供应商的 企业/个人
    private String contentId; // 劳务分包供货内容id
    private String contentIdForTrans; // 劳务分包供货内容id,用于feign数据传输   -_-!!哎
    private String leaderFormerName;//分包负责人曾用名

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bindDate;//绑定时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date unbindDate;//解绑时间
    private Integer bindState;//解绑状态 0-解绑， 1-绑定

    private String sourceType; // 来源类型（供应商类别变更-supplierTypeChange)
    private Long sourceId; // 来源id

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getBindDate() {
        return bindDate;
    }

    public void setBindDate(Date bindDate) {
        this.bindDate = bindDate;
    }

    public Date getUnbindDate() {
        return unbindDate;
    }

    public void setUnbindDate(Date unbindDate) {
        this.unbindDate = unbindDate;
    }

    public Integer getBindState() {
        return bindState;
    }

    public void setBindState(Integer bindState) {
        this.bindState = bindState;
    }

    public String getLeaderFormerName() {
        return leaderFormerName;
    }

    public void setLeaderFormerName(String leaderFormerName) {
        this.leaderFormerName = leaderFormerName;
    }

    public String getContentIdForTrans() {
        return contentIdForTrans;
    }

    public void setContentIdForTrans(String contentIdForTrans) {
        this.contentIdForTrans = contentIdForTrans;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public String getContentId() {
        return contentId;
    }

    @ReferDeserialTransfer
    public void setContentId(Object contentId) {
        if(null != contentId) {
            this.contentId = contentId.toString();
        } else {
            this.contentId = null;
        }
    }

    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSupplierContent() {
        return supplierContent;
    }

    public void setSupplierContent(String supplierContent) {
        this.supplierContent = supplierContent;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierGrade() {
        return supplierGrade;
    }

    public void setSupplierGrade(String supplierGrade) {
        this.supplierGrade = supplierGrade;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public Boolean getCoordination() {
        return coordination;
    }

    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }

    public Boolean getInException() {
        return inException;
    }

    public void setInException(Boolean inException) {
        this.inException = inException;
    }

    public Date getExceptionEndDate() {
        return exceptionEndDate;
    }

    public void setExceptionEndDate(Date exceptionEndDate) {
        this.exceptionEndDate = exceptionEndDate;
    }

    public Date getLastCoDate() {
        return lastCoDate;
    }

    public void setLastCoDate(Date lastCoDate) {
        this.lastCoDate = lastCoDate;
    }
    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }
    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }

    public Date getPunishDate() {
        return punishDate;
    }

    public void setPunishDate(Date punishDate) {
        this.punishDate = punishDate;
    }

    public String getPunishApplyOrg() {
        return punishApplyOrg;
    }

    public void setPunishApplyOrg(String punishApplyOrg) {
        this.punishApplyOrg = punishApplyOrg;
    }

    public String getPunishApplyPerson() {
        return punishApplyPerson;
    }

    public void setPunishApplyPerson(String punishApplyPerson) {
        this.punishApplyPerson = punishApplyPerson;
    }

    public String getPunishOldGrade() {
        return punishOldGrade;
    }

    public void setPunishOldGrade(String punishOldGrade) {
        this.punishOldGrade = punishOldGrade;
    }

    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }

    public String getPunishMemo() {
        return punishMemo;
    }

    public void setPunishMemo(String punishMemo) {
        this.punishMemo = punishMemo;
    }

    /**
     * 姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 姓名
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 身份证号
     */
    public String getIdNum() {
        return idNum;
    }

    /**
     * 身份证号
     */
    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }
    /**
     * 手机号
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 手机号
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }
    /**
     * 等级
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGrade() {
        return grade;
    }

    /**
     * 等级
     */
    @ReferDeserialTransfer
    public void setGrade(Long grade) {
        this.grade = grade;
    }
    /**
     * 等级名称
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 等级名称
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 主表id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 主表id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
