/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.api;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.hystrix.ProjectPoolHystrix;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback=ProjectPoolHystrix.class)
public interface IProjectPoolApi {
    @GetMapping(value={"/api/projectPool/queryProjectList"})
    public CommonResponse<List<ProjectSurveyVO>> queryProjectList(@RequestParam(value="projectStatus", required=false) String var1, @RequestParam(value="dateIn", required=false) String var2, @RequestParam(value="orgId", required=false) Long var3, @RequestParam(value="currentProvince", required=false) String var4);

    @GetMapping(value={"/api/projectPool/queryProjectPoolList"})
    public CommonResponse<JSONArray> queryProjectPoolList(@RequestParam(value="projectStatus", required=false) String var1, @RequestParam(value="dateIn", required=false) String var2, @RequestParam(value="orgId", required=false) Long var3);

    @PostMapping(value={"/api/projectPool/getProjectPoolList"})
    public CommonResponse<JSONArray> getProjectPoolList(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/projectPool/queryProjectPoolById"})
    public CommonResponse<JSONArray> queryProjectPoolById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/projectPool/queryProjectListByNameAndCodeAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndCodeAndTenantId(@RequestParam(value="name") String var1, @RequestParam(value="code") String var2, @RequestParam(value="tenantId") Long var3);

    @GetMapping(value={"/api/projectPool/queryProjectListByCodeAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByCodeAndTenantId(@RequestParam(value="code") String var1, @RequestParam(value="tenantId") Long var2);

    @GetMapping(value={"/api/projectPool/queryProjectListByNameAndTenantId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByNameAndTenantId(@RequestParam(value="name") String var1, @RequestParam(value="tenantId") Long var2);

    @GetMapping(value={"/api/projectPool/queryProjectListByProjectDepartmentId"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectListByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long var1);

    @PostMapping(value={"/api/projectPool/queryProjectIPage"})
    public CommonResponse<Page<ProjectPoolSetVO>> queryProjectIPage(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/projectPool/queryProjectIdsByorgId"})
    public CommonResponse<List<Long>> queryProjectIdsByorgId(@RequestParam(value="orgId") Long var1, @RequestParam(value="projectStatus", required=false) String var2, @RequestParam(value="dateIn", required=false) String var3);

    @GetMapping(value={"/api/projectPool/queryProjectIdsByParentProjectId"})
    public CommonResponse<List<Long>> queryProjectIdsByParentProjectId(@RequestParam(value="parentProjectId", required=false) Long var1);

    @GetMapping(value={"/api/projectPool/queryDetailById"})
    public CommonResponse<ProjectVO> queryDetailById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/projectPool/queryProjectArray"})
    public CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> var1);

    @GetMapping(value={"/api/projectPool/queryProjectByIds"})
    public CommonResponse<JSONArray> queryProjectByIds(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/projectPool/queryProjectsByIds"})
    public CommonResponse<List<ProjectPoolSetVO>> queryProjectsByIds(@RequestBody List<Long> var1);

    @GetMapping(value={"/api/projectPool/queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long var1);

    @GetMapping(value={"/api/projectPool/queryProjects"})
    public CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam var1);

    @PostMapping(value={"/api/projectPool/queryArray"})
    public CommonResponse<JSONArray> queryArray(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/projectPool/queryProjectsByOrgId"})
    public CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam(value="orgId") Long var1);

    @GetMapping(value={"/api/projectPool/queryArrayByOrgId"})
    public CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam(value="orgId") Long var1);

    @PostMapping(value={"/api/projectPool/getAllByCodes"})
    public CommonResponse<List<ProjectPoolSetVO>> getAllByCodes(@RequestBody List<String> var1);

    @GetMapping(value={"/api/projectPool/getOneByCode"})
    public CommonResponse<ProjectPoolSetVO> getOneByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/projectPool/getOneBySourceId"})
    public CommonResponse<ProjectPoolSetVO> getOneBySourceId(@RequestParam(value="sourceId") String var1);

    @PostMapping(value={"/api/projectPool/getAllBySourceIds"})
    public CommonResponse<ProjectPoolSetVO> getAllBySourceIds(@RequestBody List<String> var1);
}

