package com.ejianc.foundation.share.hystrix;

import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 项目立项rpc服务
 */
@Component
public class ProjectSetHystrix implements IProjectSetApi {


	@Override
	public CommonResponse<String> pushProjectPoolSet( byte[] supplyByte) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 项目立项撤回 删除已生成的项目信息
	 *
	 * @param id
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@Override
	public CommonResponse<String> callBackProjectPool(Long id) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * @param projectId      项目id
	 * @param businessStatus 业务状态
	 * @description: 项目业务状态回写
	 * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 * @author songlx
	 * @date: 2022/3/21
	 */
	@Override
	public CommonResponse<String> changeProjectBusinessStatus(Long projectId, String businessStatus) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * @param projectId      项目id
	 * @param projectStatus  项目状态：1、在建 2、项目中止 3、竣工 4、保修
	 * @param businessStatus 业务状态：1、开工准备 2、在建 3、停工  5、完工 6、竣工验收
	 * @param settleStatus   结算状态：1、未决算 8、决算中 9、已决算
	 * @param archiveStatus  归档状态：10、资料未归档 11、资料已归档
	 * @param capitalStatus  资金管控状态：14、开账正常 15、资金冻结 7、成本关门  17、已销账
	 * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 * @description: 更新项目各种状态，为空则不更新该状态，不为空则更新,同时更新该项目的父项目相关状态
	 * @date: 2022/8/24
	 */
	@Override
	public CommonResponse<String> changeProjectStatus(Long projectId, String projectStatus, String businessStatus, String settleStatus, String archiveStatus, String capitalStatus) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	@Override
	public CommonResponse<ProjectPoolSetVO> getProjectId(Long projectId) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

	/**
	 * 查询多条项目信息
	 * @param projectIds
	 * @return
	 */
	public CommonResponse<List<ProjectPoolDTO>> getProjectListIds(List<Long> projectIds) {
		return CommonResponse.error("网络问题，请稍后重试！");
	}

}
