package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.share.vo.ShareSupLinkerVO;
import com.ejianc.foundation.supplier.hystrix.ShareSupplierLinkerHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareSupplierLinkerHystrix.class)
public interface IShareSupplierLinkerApi {
    /**
     * 同步准入数据
     *
     * @return
     */
    @PostMapping(value = "/api/shareSupplierLinkerApi/getBySourceIds")
    public CommonResponse<List<ShareSupLinkerVO>> getBySourceIds(@RequestBody List<String> sourceIds);
}
