package com.ejianc.foundation.share.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 项目池表
 * 
 * @author generator
 * 
 */
public class ProjectPoolSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 项目编码
    private String name; // 项目名称
    private String shortName; // 项目简称
    private Long bidProjectId; // 投标工程id
    private Long orgId; // 施工单位id
    private String orgName; // 施工单位
    private boolean hasParent; // 是否有父项目
    private Long parentProjectId; // 父项目
    private String parentProjectName; // 父项目
    private Long projectDeptId; // 施工项目部
    private String projectDeptName; // 施工项目部
    private Long constructId; // 建设单位
    private String constructName; // 建设单位
    private String designer; // 设计单位
    private String supervisor; // 监理单位
    private String taxType; // 计税方式:1一般计税;2简易征收
    private Long engineeringTypeId; // 工程类别
    private Long industryType; // 行业类别
    private String projectType; // 项目分类:1总包项目；2施工项目
    private String runType; // 经营方式：1、自主经营；2、集团内分包；3、集团内项目；4、合作项目
    private String devType; // 实施方式:1、自营；2、联营
    private String fundsSource; // 资金来源：1、集团内部；2、房地产；3政府项目；4省属大企业；5社会事业；6其他
    private Long nationalId; // 国家
    private String nationalName; // 国家
    private String area; // 地区
    private String address; // 地址
    private String structureType; // 结构类型：1、全浇灌；2、框架结构；3钢结构；4砖混结构；5框架剪力墙结构
    private String useFor; // 工程用途：1、住宅；2商用；3商住混合；4仿古建筑；5市政工程；6其他
    private Long projectManagementId; // 项目经理
    private String projectManagementName; // 项目经理
    private String projectManagementPhone; // 项目经理电话
    private Long technologyId; // 技术负责人
    private String technologyName; // 技术负责人
    private Long qualityId; // 质量负责人
    private String qualityName; // 质量负责人
    private Long safeId; // 安全负责人
    private String safeName; // 安全负责人
    private String measureType; // 工程度量方式
    private String measureValue; // 度量值
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期
    private Integer planDateNum; // 计划工期
    private String memo; // 工程概况
    private String billSourceType; // 单据来源：1、自制；2、投标总结
    private Long sourceBillId; // 来源单据id
    private String sourceBillCode; // 来源单据编号
    private Long projectId; // 生成的项目档案id
    private String devTypeName; // 实施方式
    private String areaName; // 地区

    public String getDevTypeName() {
        return devTypeName;
    }

    public void setDevTypeName(String devTypeName) {
        this.devTypeName = devTypeName;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getConstructId() {
        return constructId;
    }
    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    public Long getBidProjectId() {
        return bidProjectId;
    }

    public void setBidProjectId(Long bidProjectId) {
        this.bidProjectId = bidProjectId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public boolean isHasParent() {
        return hasParent;
    }

    public void setHasParent(boolean hasParent) {
        this.hasParent = hasParent;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getParentProjectId() {
        return parentProjectId;
    }
    @ReferDeserialTransfer
    public void setParentProjectId(Long parentProjectId) {
        this.parentProjectId = parentProjectId;
    }
    public String getParentProjectName() {
        return parentProjectName;
    }

    public void setParentProjectName(String parentProjectName) {
        this.parentProjectName = parentProjectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getProjectDeptId() {
        return projectDeptId;
    }
    @ReferDeserialTransfer
    public void setProjectDeptId(Long projectDeptId) {
        this.projectDeptId = projectDeptId;
    }
    public String getProjectDeptName() {
        return projectDeptName;
    }

    public void setProjectDeptName(String projectDeptName) {
        this.projectDeptName = projectDeptName;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getTaxType() {
        return taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getIndustryType() {
        return industryType;
    }
    @ReferDeserialTransfer
    public void setIndustryType(Long industryType) {
        this.industryType = industryType;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getRunType() {
        return runType;
    }

    public void setRunType(String runType) {
        this.runType = runType;
    }
    public String getDevType() {
        return devType;
    }
    public void setDevType(String devType) {
        this.devType = devType;
    }
    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    public Long getNationalId() {
        return nationalId;
    }

    public void setNationalId(Long nationalId) {
        this.nationalId = nationalId;
    }
    public String getNationalName() {
        return nationalName;
    }

    public void setNationalName(String nationalName) {
        this.nationalName = nationalName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getStructureType() {
        return structureType;
    }

    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }
    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }
    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    public String getProjectManagementPhone() {
        return projectManagementPhone;
    }

    public void setProjectManagementPhone(String projectManagementPhone) {
        this.projectManagementPhone = projectManagementPhone;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getTechnologyId() {
        return technologyId;
    }
    @ReferDeserialTransfer
    public void setTechnologyId(Long technologyId) {
        this.technologyId = technologyId;
    }
    public String getTechnologyName() {
        return technologyName;
    }

    public void setTechnologyName(String technologyName) {
        this.technologyName = technologyName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getQualityId() {
        return qualityId;
    }
    @ReferDeserialTransfer
    public void setQualityId(Long qualityId) {
        this.qualityId = qualityId;
    }
    public String getQualityName() {
        return qualityName;
    }

    public void setQualityName(String qualityName) {
        this.qualityName = qualityName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSafeId() {
        return safeId;
    }
    @ReferDeserialTransfer
    public void setSafeId(Long safeId) {
        this.safeId = safeId;
    }
    public String getSafeName() {
        return safeName;
    }

    public void setSafeName(String safeName) {
        this.safeName = safeName;
    }
    public String getMeasureType() {
        return measureType;
    }

    public void setMeasureType(String measureType) {
        this.measureType = measureType;
    }
    public String getMeasureValue() {
        return measureValue;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }
    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }
    public Integer getPlanDateNum() {
        return planDateNum;
    }

    public void setPlanDateNum(Integer planDateNum) {
        this.planDateNum = planDateNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBillSourceType() {
        return billSourceType;
    }

    public void setBillSourceType(String billSourceType) {
        this.billSourceType = billSourceType;
    }
    public Long getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(Long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    
}
