package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ProSupplierHystrix;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


/**
 * 大企业供应商rpc服务
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ProSupplierHystrix.class)
public interface IProSupplierApi {



	@PostMapping(value = "/api/shareSupplierApi/querySupplierByNames")
	@ResponseBody
	public CommonResponse<List<SupplierDTO>> querySupplierByNames(@RequestBody List<String> names);


	@GetMapping("/api/shareSupplierApi/selectById")
	CommonResponse<SupplierDTO> selectById(@RequestParam(value = "id") Long id);

	@GetMapping("/api/shareSupplierApi/selectByUpDate")
	CommonResponse<List<SupplierDTO>> selectByUpDate(@RequestParam(value = "upDate") String upDate);

	@PostMapping(value = "/api/shareSupplierApi/queryPostSupplierByIds")
	@ResponseBody
	public CommonResponse<List<SupplierDTO>> queryPostSupplierByIds(@RequestBody Map<String,List<Long>> map);


	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送，包括物资设备供应商、劳务分包供应商 分包负责人准入使用本方法下面方法
	 *
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@PostMapping(value = "/api/shareSupplierApi/pushSupplierToShare")
	public CommonResponse<String> pushSupplierToShare(@RequestBody  byte[] supplyByte);

	/**
	 * 供应商准入推送，生成企业供应商 适用于供应商本体推送，包括物资设备供应商、劳务分包供应商 分包负责人准入使用本方法下面方法
	 * 郑州一建
	 * @return supplyByte 是SupplierVO的json字符串生成的字节数组
	 */
	@PostMapping(value = "/api/shareSupplierApi/pushSupplierToShareZzyj")
	public CommonResponse<String> pushSupplierToShareZzyj(@RequestBody  byte[] supplyByte);

	/**
	 *  判断纳税人识别号、身份证号是否重复
	 *
	 * @return
	 */
	@GetMapping(value = "/api/shareSupplierApi/judgeTaxpayerNumIsRepeat")
	public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam(value = "taxpayerNum")  String taxpayerNum, @RequestParam(value = "personal") String personal, @RequestParam(required = false, value = "supplyType")  String supplyType);


	/**
	 * 分包负责人准入推送，生成供应商企业负责人 适用于分包负责人准入推送 ；物资设备供应商、劳务分包供应商请使用上面的方法
	 *
	 * @return
	 */
	@PostMapping(value = "/api/shareSupplierApi/pushSubLeadersToShare")
	public CommonResponse<String> pushSubLeadersToShare(@RequestBody SubleadersPushVO pushVO);

	/**
	 * 供应商处置更新供应商库
	 */
	@PostMapping(value = "/api/shareSupplierApi/punishSupplier")
	public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO);

	/**
	 * 移除供应商异常标签
	 */
	@GetMapping(value = "/api/shareSupplierApi/returnSupplierToNormal")
	CommonResponse<String> returnSupplierToNormal(@RequestParam("supplierId") Long supplierId,
												  @RequestParam("gradeId") Long gradeId,
												  @RequestParam("gradeName") String gradeName);

	/**
	 * 供应商 评级更新供应商库
	 * @param supplierId 供应商id
	 * @param gradeId 评定等级id
	 * @param gradeName 评定等级名称
	 */
	@GetMapping(value = "/api/shareSupplierApi/upgradeSupplier")
	public CommonResponse<String> upgradeSupplier(@RequestParam("supplierId") Long supplierId,
												  @RequestParam("gradeId") Long gradeId,
												  @RequestParam("gradeName") String gradeName);


	/**
	 * 获取本私有化平台在 益企联公有云平台内的系统标识编码
	 */
	@GetMapping(value = "/api/shareSupplierApi/getEjcCloudSystemCode")
	public CommonResponse<String> getEjcCloudSystemCode();

	/**
	 * 根据供应商id，查询供应商信息
	 */
	@GetMapping(value = "/api/shareSupplierApi/getSupplierInfo")
	public CommonResponse<SupplierProVO> getSupplierInfo(@RequestParam("supplierId") Long supplierId);


	/**
	 * 根据供应商id，查询供应商是否真正协同成功
	 */
	@GetMapping(value = "/api/shareSupplierApi/whetherSupplierCoo")
	public CommonResponse<Boolean> whetherSupplierCoo(@RequestParam("supplierId") Long supplierId);


	/**
	 * 根据供应商id，更新供应商最近合作时间
	 */
	@GetMapping(value = "/api/shareSupplierApi/updateLastCoDate")
	public CommonResponse<String> updateLastCoDate(@RequestParam("supplierId") Long supplierId);


	/**
	 * 根据供应商税号，获取供应商信息
	 */
	@GetMapping(value = "/api/shareSupplierApi/selectByTaxpayerNum")
	public CommonResponse<SupplierDTO> selectByTaxpayerNum(@RequestParam("taxpayerNum") String taxpayerNum);

	/**
	 * 根据I8单位编码、纳税人识别号，获取供应商信息
	 */
	@GetMapping(value = "/api/shareSupplierApi/selectByUnitCodeOrTaxPayerIdentifier")
	public CommonResponse<List<SupplierDTO>> selectByUnitCodeOrTaxPayerIdentifier(@RequestBody List<String> unitCodeOrTaxPayerIdentifier);


	/**
	 * 根据供应商税号 或者 名称 校验供应商是否一致
	 * 不一致，返回false，并提示信息不一致的信息
	 * 一致，返回true
	 */
	@GetMapping(value = "/api/shareSupplierApi/checkTaxpayerNumOrNameIsSame")
	public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(@RequestParam("taxpayerNum") String taxpayerNum,@RequestParam("name") String name);

	/**
	 * 根据供应商id和分包负责人身份证号 校验分包负责人是否在该供应商下存在
	 * 不存在，返回false，并提示信息不一致的信息
	 * 存在，返回true
	 * @param supplierId 供应商id
	 * @param idCardNum  分包负责人身份证号
	 */
	@GetMapping(value = "/api/shareSupplierApi/checkSubLeaderIsExist")
	public CommonResponse<Boolean> checkSubLeaderIsExist(@RequestParam("supplierId") Long supplierId,@RequestParam("idCardNum") String idCardNum);

	/**
	 * 批量供应商处置更新供应商库
	 *
	 * @return
	 */
	@PostMapping(value = "/api/shareSupplierApi/punishSupplierBatch")
	public CommonResponse<String> punishSupplierBatch(@RequestBody List<PunishVO> punishVOs);

	/**
	 * 批量更新供应商/分包负责人等级
	 *
	 * @param updateParamsStr [{id: 供应商或分包负责人Id，type: supplier-供应商，subLeader-分包负责人, grade: 等级Id，gradeName:等级名称}]
	 * @return
	 */
	@PostMapping(value = "/api/shareSupplierApi/updateSupplierAndSubLeaderBatch")
	public CommonResponse<String> updateSupplierAndSubLeaderBatch(@RequestBody String updateParamsStr);


	/**
	 * 一建BI大屏-查对应供应商数量
	 *
	 * @return
	 */
	@GetMapping(value = "/api/shareSupplierApi/getSupplierNum")
	public CommonResponse<List<Map<String, Object>>> getSupplierNum(@RequestParam(value = "year",required = false) String year);

}
