package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ShareEquipmentHystrix;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 设备rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareEquipmentHystrix.class)
public interface IShareEquipmentApi {

    /**
     * 根据编码查询设备详情
     * @Author liyongjia
     * @param code
     * @return
     */
	@GetMapping(value = "/api/shareEquipmentApi/queryEquipmentByCode")
	CommonResponse<EquipmentVO> queryEquipmentByCode(@RequestParam(value = "code") String code);
	/**
	 * @Author xuannl
	 * @Date 2022/04/18 根据id查询详情
	 * @Param [id]
	 * @Return>
	 */
	@GetMapping(value = "/api/shareEquipmentApi/queryEquipmentItemByIds")
	CommonResponse<List<EquipmentVO>> queryEquipmentItemByIds(@RequestParam(value = "ids") List<Long> ids);


	/**
	 * 根据ids查询分类
	 *
	 * @param ids
	 * @return
	 */
	@PostMapping(value = "/api/shareEquipmentApi/queryCategoryListByIds")
	CommonResponse<List<EquipmentCategoryVO>> queryCategoryListByIds(@RequestBody List<Long> ids);
}
