package com.ejianc.foundation.support.api;

import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ShareCustomerVO;
import com.ejianc.foundation.support.hystrix.ShareCustomerHystrix;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 客户档案API
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareCustomerHystrix.class)
public interface IShareCustomerApi {

    /**
     * 根据名称查询唯一匹配的客户信息
     *
     * @param name
     * @param tenantId
     * @return
     */
    @GetMapping("/api/shareCustomerApi/findOneByName")
    CommonResponse<CustomerVO> findOneByName(@RequestParam(value = "name") String name,
                                                 @RequestParam(value = "tenantId") Long tenantId);

    /**
     * 根据客户Id查询客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/shareCustomerApi/queryById")
    CommonResponse<CustomerVO> detailById(@RequestParam(value = "id") Long id);

    /**
     * 根据客户Id列表查询客户信息
     *
     * @param ids
     * @return
     */
    @GetMapping("/api/shareCustomerApi/queryListByIds")
    CommonResponse<List<ShareCustomerVO>> detailsByIds(@RequestParam List<Long> ids);
    /**
     * 查询类型
     * @param tenantId
     * @return
     */
    @GetMapping("/api/shareCustomerApi/queryCategoryList")
    CommonResponse<List<CustomerCategoryVO>> queryCategoryList(@RequestParam(value = "tenantId") Long tenantId);


    /**
     * 根据id修改客户的累计施工合同额等
     *
     * @param
     * @return
     */
    @PostMapping("/api/shareCustomerApi/updateIncomeMny")
    CommonResponse<String> updateIncomeMny(@RequestBody CustomerIncomeInfoVO customerIncomeInfoVO);
}
