package com.ejianc.foundation.support.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.List;


/**
 * 银行账户实体
 * 
 * @author generator
 * 
 */
public class BankAccountVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 组织主键
    private String orgName; // 组织名称


    private Long supplierId; // 供应商/客户/客商/内部单位主键
    private String supplierCode; // 供应商/客户/客商/内部单位编码
    private String supplierName; // 供应商/客户/客商/内部单位名称

    private Integer supplierFlag; // 1供应商2客户3客商
    private Integer insideState; // 是否内部单位银行账户 1-是 0-否

    private String bankCode; // 银行账号
    private String bankAccount; // 户名

    private Integer defaultFlag; // 是否默认(1:是，0：否)


    private Long bankId; // 开户银行主键
    private String bankNum; // 开户银行编码
    private String bankName; // 开户银行名称
    private String bankAddress; // 开户银行地址

    private Long categoryId; // 银行类别主键
    private String categoryCode; // 银行类别编码
    private String categoryName; // 银行类别名称

    private Integer enabled; // 启用/停用(1:启用，0：停用)
    private Long enableUserId; // 启用人主键
    private String enableUserName; // 启用人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date enableTime; // 启用时间
    private Long unenableUserId; // 停用人主键
    private String unenableUserName; // 停用人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date unenableTime; // 停用时间
    private String memo; // 备注

    //错误信息
    private String warnType;

    private String defaultFlagName; // 是否默认名称

    private String enabledName;// 启用/停用名称

    private List<Long> supplierIds; // 供应商主键 查询使用

    private String lastUpdateTime;//主数据的最新时间

    public String getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }
    public List<Long> getSupplierIds() {
        return supplierIds;
    }

    public void setSupplierIds(List<Long> supplierIds) {
        this.supplierIds = supplierIds;
    }

    public Integer getSupplierFlag() {
        return supplierFlag;
    }

    public void setSupplierFlag(Integer supplierFlag) {
        this.supplierFlag = supplierFlag;
    }

    public String getBankAddress() {
        return bankAddress;
    }

    public void setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress;
    }

    public String getBankNum() {
        return bankNum;
    }

    public void setBankNum(String bankNum) {
        this.bankNum = bankNum;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }


    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getEnabledName() {
        return enabledName;
    }

    public void setEnabledName(String enabledName) {
        this.enabledName = enabledName;
    }

    public String getDefaultFlagName() {
        return defaultFlagName;
    }

    public void setDefaultFlagName(String defaultFlagName) {
        this.defaultFlagName = defaultFlagName;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    /**
     * 组织主键
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 供应商主键
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 是否默认(1:是，0：否)
     */
    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    /**
     * 是否默认(1:是，0：否)
     */
    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    /**
     * 是否内部单位银行账户 1-是 0-否
     */
    public Integer getInsideState() {
        return insideState;
    }

    /**
     * 是否内部单位银行账户 1-是 0-否
     */
    public void setInsideState(Integer insideState) {
        this.insideState = insideState;
    }
    /**
     * 账户
     */
    public String getBankCode() {
        return bankCode;
    }

    /**
     * 账户
     */
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    /**
     * 户名
     */
    public String getBankAccount() {
        return bankAccount;
    }

    /**
     * 户名
     */
    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    /**
     * 银行主键
     */
    @ReferSerialTransfer(referCode="support-bank")
    public Long getBankId() {
        return bankId;
    }

    /**
     * 银行主键
     */
    @ReferDeserialTransfer
    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
    /**
     * 开户银行
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * 开户银行
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    /**
     * 银行类别主键
     */
    @ReferSerialTransfer(referCode="support-bank-category")
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 银行类别主键
     */
    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 银行类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 银行类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 启用/停用(1:启用，0：停用)
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 启用/停用(1:启用，0：停用)
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    /**
     * 启用人主键
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEnableUserId() {
        return enableUserId;
    }

    /**
     * 启用人主键
     */
    @ReferDeserialTransfer
    public void setEnableUserId(Long enableUserId) {
        this.enableUserId = enableUserId;
    }
    /**
     * 启用人名称
     */
    public String getEnableUserName() {
        return enableUserName;
    }

    /**
     * 启用人名称
     */
    public void setEnableUserName(String enableUserName) {
        this.enableUserName = enableUserName;
    }
    /**
     * 启用时间
     */
    public java.util.Date getEnableTime() {
        return enableTime;
    }

    /**
     * 启用时间
     */
    public void setEnableTime(java.util.Date enableTime) {
        this.enableTime = enableTime;
    }
    /**
     * 停用人主键
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getUnenableUserId() {
        return unenableUserId;
    }

    /**
     * 停用人主键
     */
    @ReferDeserialTransfer
    public void setUnenableUserId(Long unenableUserId) {
        this.unenableUserId = unenableUserId;
    }
    /**
     * 停用人名称
     */
    public String getUnenableUserName() {
        return unenableUserName;
    }

    /**
     * 停用人名称
     */
    public void setUnenableUserName(String unenableUserName) {
        this.unenableUserName = unenableUserName;
    }
    /**
     * 停用时间
     */
    public java.util.Date getUnenableTime() {
        return unenableTime;
    }

    /**
     * 停用时间
     */
    public void setUnenableTime(java.util.Date unenableTime) {
        this.unenableTime = unenableTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
