package com.ejianc.foundation.share.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.List;


/**
 * 项目WBS
 * 
 * @author generator
 * 
 */
public class ProjectWbsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long projectId; // 项目主键
    private Long orgId; // 组织主键
    private String name; // 成本科目名称
    private String code; // 成本科目编码
    private String memo; // 描述
    private Long parentId; // 父id
    private String innerCode; // 内置编码
    private Integer enabled; // 0：启用 / 1：停用

    private Integer wbsType; // 1-里程碑、2-子任务、3-产品、4-构件、5-工序

    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String material; // 材质
    private Long processId; // 工序主键


    public Integer getWbsType() {
        return wbsType;
    }

    public void setWbsType(Integer wbsType) {
        this.wbsType = wbsType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    private List<Long> ids;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    /**
     * 序号
     */
    private String detailIndex;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long changeBid;
    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    @ReferSerialTransfer(referCode="standard-process")
    public Long getProcessId() {
        return processId;
    }

    @ReferDeserialTransfer
    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }
    
}
