package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.FinancialOrgHystrix;
import com.ejianc.foundation.share.vo.FinancialOrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 设备rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = FinancialOrgHystrix.class)
public interface IFinancialOrgApi {

    /**
     *
     * @Author
     * @param
     * @return
     */
	@GetMapping(value = "/api/financialOrgApi/queryFinancialOrgTree")
	CommonResponse<List<FinancialOrgVO>> queryFinancialOrgTree();

	/**
	 * 查询
	 * @param param
	 * @return
	 */
	@PostMapping("/api/financialOrgApi/queryFinancialOrg")
	@ResponseBody
	public CommonResponse<List<FinancialOrgVO>> queryFinancialOrg(@RequestBody QueryParam param);


	@GetMapping("/api/financialOrgApi/queryFinancialOrgIds")
	CommonResponse<List<Long>> queryFinancialOrgIds(@RequestParam String name);
}
