package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ShareLabsubHystrix;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 专业分包档案
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareLabsubHystrix.class)
public interface IShareLabsubApi {

	/**
	 * @Author xuannl
	 * @Date 2022/04/18 根据id查询详情
	 * @Param [id]
	 * @Return>
	 */
	@GetMapping(value = "/api/shareLabsubApi/queryLabsubItemByIds")
	CommonResponse<List<LabsubItemVO>> queryLabsubItemByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据分类id查询分类信息
	 * @Author zhangwx
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/shareLabsubApi/queryLabSubByCategoryId")
	CommonResponse<LabsubCategoryVO> queryLabSubByCategoryId(@RequestParam(value = "id") Long id);

	/**
	 * 根据分类id查询分类信息
	 * @Author zhangwx
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/shareLabsubApi/queryMajorSubByCategoryId")
	CommonResponse<ProsubCategoryVO> queryMajorSubByCategoryId(@RequestParam(value = "id") Long id);

	/**
	 * 根据ids查询分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/shareLabsubApi/queryCategoryListByIds")
	CommonResponse<List<LabsubCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids);

	/**
	 * 根据编码集合查询档案列表
	 *
	 * @param codeList
	 * @return
	 */
	@GetMapping(value = "/api/shareLabsubApi/queryItemListByCodes")
	CommonResponse<List<LabsubItemVO>> queryItemListByCodes(@RequestParam(value = "codeList") List<String> codeList);
}
