package com.ejianc.foundation.share.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.hystrix.ShareCooperateHystrix;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 物资rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareCooperateHystrix.class)
public interface IShareCooperateApi {


	/**
	 * 根据模块id 查询 协同设置列表
	 *
	 * @param moduleId
	 * @return List<CooperateVO>
	 */
	@GetMapping(value = "/api/shareCooperateApi/queryCooperateListByModuleId")
	public CommonResponse<List<CooperateVO>> queryCooperateListByModuleId(@RequestParam(value = "moduleId") Long moduleId);

	/**
	 * 根据模块单据编号 查询 协同设置
	 *
	 * @param billTypeCode
	 * @return CooperateVO
	 */
	@GetMapping(value = "/api/shareCooperateApi/queryCooperateBybillTypeCode")
	public CommonResponse<CooperateVO> queryCooperateBybillTypeCode(@RequestParam(value = "billTypeCode") String billTypeCode);


	/**
	 * 获取单据分享连接
	 *
	 * @param billId  单据Id
	 * @param supplierId 单据供应商Id
	 * @param billTypeCode 单据类型编码
	 * @param h5FrontUrl 供方单据详情h5页面路由地址
	 * @param wxFrontUrl 供方单据详情微信页面路由地址
	 * @return
	 */
	@GetMapping(value = "/api/shareCooperateApi/getShareLink")
	public CommonResponse<JSONObject> getShareLink(@RequestParam(value = "billId") Long billId,
                                                   @RequestParam(value = "billTypeCode") String billTypeCode,
                                                   @RequestParam(value = "supplierId") String supplierId,
                                                   @RequestParam(value = "h5FrontUrl") String h5FrontUrl,
                                                   @RequestParam(value = "wxFrontUrl", required = false) String wxFrontUrl);
}
