package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.ShareProsubHystrix;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 专业分包档案
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareProsubHystrix.class)
public interface IShareProsubApi {

	/**
	 * @Author xuannl
	 * @Date 2022/04/18 根据id查询详情
	 * @Param [id]
	 * @Return>
	 */
	@GetMapping(value = "/api/shareProsubApi/queryProsubItemByIds")
	CommonResponse<List<ProsubItemVO>> queryProsubItemByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据ids查询分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/shareProsubApi/queryCategoryListByIds")
	CommonResponse<List<ProsubCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids);

	/**
	 * 根据编码集合查询档案列表
	 *
	 * @param codeList
	 * @return
	 */
	@GetMapping(value = "/api/shareProsubApi/queryItemListByCodes")
	CommonResponse<List<ProsubItemVO>> queryItemListByCodes(@RequestParam(value = "codeList") List<String> codeList);
}
