package com.ejianc.foundation.share.enums;

/**
 * 材料设备模糊匹配结果枚举
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public enum MaterialFuzzyMatchEnum {
	UN_MATCH(0, "未匹配"),
	MACHED(1, "已匹配"),
	FUZZY_MATCH(2, "模糊匹配");

	private final Integer code;
	private final String desc;

	MaterialFuzzyMatchEnum(Integer code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public Integer getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}
}
