package com.ejianc.foundation.support.api;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.hystrix.ShareSupplierWebHystrix;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BankVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 供应商管理微服务API
 *
 * @author yqls
 * @Description:
 * @date 2021/11/11 14:58
 */
@FeignClient(name= "ejc-share-web", url="${common.env.feign-client-url}", path="ejc-share-web", fallback = ShareSupplierWebHystrix.class)
public interface IShareSupplierWebApi {

    /**
     * 查询所有供应商
     *
     * @return
     */
    @GetMapping(value = "/api/shareSupplierWebApi/querySupplierList")
    CommonResponse<List<SupplierVO>> querySupplierList();

    /**
     * 查询所有银行账户
     *
     * @return
     */
    @GetMapping(value = "/api/shareSupplierWebApi/queryBankAccountList")
    CommonResponse<List<BankAccountVO>> queryBankAccountList();

    /**
     * 查询所有银行档案
     *
     * @return
     */
    @GetMapping(value = "/api/shareSupplierWebApi/queryBankList")
    CommonResponse<List<BankVO>> queryBankList();

    /**
     * 根据客户id查询默认银行账户
     *
     * @return
     */
    @GetMapping("/api/shareSupplierWebApi/queryBankAccountByCustomerId")
    CommonResponse<BankAccountVO> queryBankAccountByCustomerId(@RequestParam("customerId") Long customerId);

    /**
     * 根据id查询默认银行账户
     * type  supplierId or customerId or insideOrgId
     * @return
     */
    @GetMapping("/api/shareSupplierWebApi/queryDefaultBankAccountById")
    CommonResponse<BankAccountVO> queryDefaultBankAccountById(@RequestParam("id") Long id, @RequestParam("type") String type);
}
