package com.ejianc.foundation.share.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * 项目业务状态
 * 业务状态：1、开工准备 2、正式开工 3、停工 4、复工5、完工6、竣工验收 7、成本关门 8、决算中 9、已决算
 * 10、资料未归档 11、资料已归档 12、保修中 13、保修结束 14、开账 15、资金冻结 16、资金恢复 17、已销账
 */
public enum ProjectBusinessStatusEnum {

    未开工("1", "未开工"),
    在施("2", "在施"),
    停工("3", "停工"),

    复工("4", "复工"),

    完成未验("5", "完成未验"),
    竣工("6", "竣工");


    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        for (ProjectBusinessStatusEnum enumVal : ProjectBusinessStatusEnum.values()) {
            enumMap.put(enumVal.getBusinessStatus(), enumVal.getBusinessStatusName());
        }
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }


    private String businessStatus;

    private String businessStatusName;

    ProjectBusinessStatusEnum(String businessStatus, String businessStatusName) {
        this.businessStatus = businessStatus;
        this.businessStatusName = businessStatusName;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getBusinessStatusName() {
        return businessStatusName;
    }

    public void setBusinessStatusName(String businessStatusName) {
        this.businessStatusName = businessStatusName;
    }

}
