package com.ejianc.foundation.share.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.EquipmentEntity;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

public interface IEquipmentService {

	/**
	 * 根据分类ID查询其下设备
	 *
	 * @param categoryId
	 * @return
	 */
	List<EquipmentVO> queryListByCategoryId(Long categoryId);

	/**
	 * 查询详情list
	 *
	 * @param ids
	 * @return
	 */
	List<EquipmentVO> queryItem(List<Long> ids);


	/**
	 * 查询详情
	 *
	 * @param id
	 * @return
	 */
	EquipmentVO queryDetail(Long id);

	/**
	 * 修改
	 *
	 * @param uniqueBean
	 */
	void update(EquipmentVO uniqueBean);

	/**
	 * 批量修改
	 *
	 * @param
	 */
	void amend(Long id,Long property,String propertyName);

	/**
	 * 保存
	 *
	 * @param EquipmentVo
	 */
	void save(EquipmentVO EquipmentVo);


	/**
	 * 批量保存
	 *
	 * @param EquipmentVo
	 */
	void insertBatch(List<EquipmentVO> EquipmentVo);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void delete(List<Long> ids);

	/**
	 * 查询翻页
	 *
	 * @param queryParam
	 * @return
	 */
	IPage<EquipmentEntity> queryPage(QueryParam queryParam);

	/**
	 * 查询是否已经存在
	 *
	 * @param name
	 * @param spec
	 * @param unitName
	 * @return
	 */
	EquipmentVO queryExitFlag(String name, String spec, String unitName, Long categoryId);

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	EquipmentVO queryByCode(String code);

	/**
	 * 查询列表
	 *
	 * @param queryParam
	 * @return
	 */
	List<EquipmentEntity> queryList(QueryParam queryParam);

	/**
	 * 从平台同步设备
	 */
    void insertEquipmentListFromPlatform();

    /**
     * 查询物料参照
     *
     * @param params
     * @return
     */
    IPage<EquipmentEntity> queryRefEquipmentPage(Map<String, Object> params);

    CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode);

    List<EquipmentVO> queryEquipmentListByCodes(List<String> codeList);

    void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId);
}
