package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供方
 *
 * @author guoming
 *
 */
@TableName("ejc_support_supplier")
public class SupplierEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "code")
	private String code; // 供方编码

	@TableField(value = "name")
	private String name; // 供方名称

	@TableField(value = "category_id")
	private Long categoryId; // 供方分类ID

	@TableField(value = "category_name")
	private String categoryName; // 供方分类名称

	@TableField(value = "social_credit_code")
	private String socialCreditCode; // 社会信用代码

	@TableField(value = "legal")
	private String legal; // 法定代表人

	@TableField(value = "business_scope")
	private String businessScope; // 经营范围

	@TableField(value = "enabled")
	private Integer enabled; // 启停用（1：启用 ， 0：停用）

	@TableField(value = "area")
	private String area; // 地区

	@TableField(value = "address")
	private String address; // 详细地址

	@TableField(value = "telephone")
	private String telephone; // 客户电话

	@TableField(value = "bank_name")
	private String bankName; // 账户名

	@TableField(value = "bank_account")
	private String bankAccount;// 银行账号

	@TableField(value = "bank_code")
	private String bankCode; // 开户行

	@TableField(value = "description")
	private String description; // 描述

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	@TableField(value = "system_id")
	private String systemId; // 系统id 对应公有云企业id

	@TableField(value = "tenant")
	private Long tenant; // 关联租户id（供方协同）

	@TableField(value = "tenant_name")
	private String tenantName; // 关联租户名称（供方协同）

	@TableField(value = "tenant_phone")
	private String tenantPhone; // 生成租户手机号（供方协同）

	@TableField(value = "tenant_user_name")
	private String tenantUserName; // 生成租户管理员名称（供方协同）

	/**
	 * 省份
	 */
	@TableField(value = "province")
	private String province;

	/**
	 * 市区
	 */
	@TableField(value = "city")
	private String city;

	/**
	 * 区县
	 */
	@TableField(value = "region")
	private String region;

	@TableField(value = "org_id")
	private Long orgId; // 所属组织ID

	@TableField(value = "inside_org_id")
	private Long insideOrgId; // 内部客商--来源组织id
	@TableField(value = "inside_org")
	private Boolean insideOrg; // 内外部客商 true：内部，false：外部
	@TableField(value = "org_name")
	private String orgName; // 所属组织

	@TableField(value = "enterprise_nature")
	private Long enterpriseNature; // 企业性质
	@TableField(value = "register_time")
	private java.util.Date registerTime; // 注册日期
	@TableField(value = "tax_payer_identifier")
	private String taxPayerIdentifier; // 纳税人识别号
	@TableField(value = "registered_capital")
	private BigDecimal registeredCapital; // 注册资金
	@TableField(value = "legal_phone")
	private String legalPhone; // 法人电话
	@TableField(value = "issuing_time")
	private java.util.Date issuingTime; // 发证时间
	@TableField(value = "evaluation_grade")
	private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
	@TableField(value = "supplier_flag")
	private Integer supplierFlag; // 客商属性：1供应商，2客户，3客商
	@TableField(value = "sub_flag")
	private Integer subFlag; // 是否属于分包，0-否，1-是
	@TableField(value = "blacklist_flag")
	private Integer blacklistFlag; // 是否黑名单，0-否，1-是
	@TableField(value = "redlist_flag")
	private Integer redlistFlag; // 是否红名单，0-否，1-是
	@TableField(value = "operate_id")
	private Long operateId; // 操作人id
	@TableField(value = "operate_name")
	private String operateName; // 操作人名称
	@TableField(value = "operate_time")
	private java.util.Date operateTime; // 操作时间
	@TableField(value = "operate_org_id")
	private Long operateOrgId; // 操作人所属组织id
	@TableField(value = "operate_org_name")
	private String operateOrgName; // 操作人所属组织名称
	@TableField(value = "bl_time")
	private java.util.Date blTime; // 营业执照有效期
	@TableField(value = "spl_time")
	private java.util.Date splTime; // 安全生产许可证有效期
	@TableField(value = "qc_time")
	private java.util.Date qcTime; // 资质证书有效期
	@TableField(value = "sc_time")
	private java.util.Date scTime; // 安全证有效期
	// 证件类型：lppoa-法人委托授权书，lpidc-法人身份复印件，bl-营业执照，spl-安全生产许可证，qc-资质证书，sc-安全证，other-其他证件
	@TableField(value="access_id")
	private Long accessId; // 供应商准入id


	/** 供应商准入数据 */

	@TableField(value="bill_state")
	private java.lang.Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
	@TableField(value="supply_query_type")
	private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
	@TableField(value="supply_type")
	private java.lang.String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other，周转材：revolvMaterial，咨询：consult
	@TableField(value="supply_type_name")
	private java.lang.String supplyTypeName; // 供方类别名称
	@TableField(value="personal")
	private java.lang.String personal; // 个人：p，企业：e
	@TableField(value="group_in_or_out")
	private java.lang.String groupInOrOut; // 集团内外：内in，外out
	@TableField(value="material_content_id")
	private java.lang.String materialContentId; // 物资供货内容id
	@TableField(value="material_content")
	private java.lang.String materialContent; // 物资供货内容名称
	@TableField(value="material_memo")
	private java.lang.String materialMemo; // 物资补充描述
	@TableField(value="equipment_content_id")
	private java.lang.String equipmentContentId; // 设备供货内容id
	@TableField(value="equipment_content")
	private java.lang.String equipmentContent; // 设备供货内容
	@TableField(value="equipment_memo")
	private java.lang.String equipmentMemo; // 设备补充描述
	@TableField(value="major_content_id")
	private java.lang.String majorContentId; // 专业分包供货内容id
	@TableField(value="major_content")
	private java.lang.String majorContent; // 专业分包供货内容
	@TableField(value="major_memo")
	private java.lang.String majorMemo; // 专业分包补充描述
	@TableField(value="labor_content_id")
	private java.lang.String laborContentId; // 劳务分包供货内容id
	@TableField(value="labor_content")
	private java.lang.String laborContent; // 劳务分包供货内容
	@TableField(value="labor_memo")
	private java.lang.String laborMemo; // 劳务分包补充描述
	@TableField(value="sub_content_id")
	private java.lang.String subContentId; // 分包班组供货内容id
	@TableField(value="sub_content")
	private java.lang.String subContent; // 分包班组供货内容
	@TableField(value="sub_memo")
	private java.lang.String subMemo; // 分包班组补充描述
	@TableField(value="other_content_id")
	private java.lang.String otherContentId; // 其他供货内容id
	@TableField(value="other_content")
	private java.lang.String otherContent; // 其他供货内容
	@TableField(value="other_memo")
	private java.lang.String otherMemo; // 其他补充描述
	@TableField(value="revolv_material_content_id")
	private String revolvMaterialContentId;//周转材供货内容id
	@TableField(value="revolv_material_content")
	private String revolvMaterialContent;//周转材供货内容
	@TableField(value="revolv_material_memo")
	private String revolvMaterialMemo;//周转材补充描述
	@TableField(value="consult_content_id")
	private String consultContentId;//咨询供货内容id
	@TableField(value="consult_content")
	private String consultContent;//咨询供货内容
	@TableField(value="consult_memo")
	private String consultMemo;//咨询补充描述
	@TableField(value="apply_org_name")
	private java.lang.String applyOrgName; // 申请单位
	@TableField(value="apply_org_id")
	private java.lang.Long applyOrgId; // 申请单位id
	@TableField(value="enterprise_nature_name")
	private java.lang.String enterpriseNatureName; // 企业性质名称

	@TableField(value="register_country_id")
	private java.lang.Long registerCountryId; // 注册国家id
	@TableField(value="register_country_name")
	private java.lang.String registerCountryName; // 注册国家名称

//	@TableField(value="taxpayer_num")
//	private java.lang.String taxpayerNum; // 纳税人识别号/身份证号
//	@TableField(value="legal_person")legal
//	private java.lang.String legalPerson; // 法人代表/别名
	@TableField(value="area_name")
	private java.lang.String areaName; // 所在地区
	@TableField(value="in_or_out")
	private java.lang.Integer inOrOut; // 国内外：1国内，2国外
	@TableField(value="grade_id")
	private java.lang.Long gradeId; // 供应商等级
	@TableField(value="grade_name")
	private java.lang.String gradeName; // 供应商等级
//	@TableField(value="business_range")business_scope
//	private java.lang.String businessRange; // 经营范围
	@TableField(value="memo")
	private java.lang.String memo; // 准入说明
//	@TableField(value="time_out")bl_time
//	private java.util.Date timeOut; // 有效期
	@TableField(value="coordination")
	private Boolean coordination; // 是否协同
//	@TableField(value="coordination_name")   tenant_user_name
//	private java.lang.String coordinationName; // 协同姓名
//	@TableField(value="coordination_phone")tenant_phone
//	private java.lang.String coordinationPhone; // 协同手机号
//	@TableField(value="register_date")register_time
//	private java.util.Date registerDate; // 注册日期
//	@TableField(value="register_mny")registered_capital
//	private java.math.BigDecimal registerMny; // 注册资金
	@TableField(value="turnover")
	private java.math.BigDecimal turnover; // 年营业额
	@TableField(value="in_exception")
	private java.lang.Boolean inException; // 是否异常
	@TableField(value="exception_end_date")
	private java.util.Date exceptionEndDate; // 异常结束时间
	@TableField(value="last_co_date")
	private java.util.Date lastCoDate; // 最近合作时间

	@TableField(value="punish_type")
	private java.lang.Long punishType; // 供应商状态 处置方式 红黑牌等的id
	@TableField(value="punish_date")
	private java.util.Date punishDate; // 处置日期
	@TableField(value="punish_apply_org")
	private java.lang.String punishApplyOrg; // 处置申请单位
	@TableField(value="punish_apply_person")
	private java.lang.String punishApplyPerson; // 处置申请人
	@TableField(value="punish_old_grade")
	private java.lang.String punishOldGrade; // 处置原等级
	@TableField(value="punish_grade")
	private java.lang.String punishGrade; // 处置等级
	@TableField(value="punish_memo")
	private java.lang.String punishMemo; // 处置理由
	@TableField(value="business_person")
	private String businessPerson;	//业务代表
	@TableField(value="business_phone")
	private String businessPhone;	//业务代表电话
	@TableField(value="main_business_category")
	private String mainBusinessCategory; // 主营类别
	@TableField(value="distributer_or_manufactor")
	private String distributerOrManufactor; // 厂家经销商
	@TableField(value="taxpayer_type")
	private String taxpayerType;//纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
	@TableField(value="billing_address")
	private String billingAddress;//开票地址
	@TableField(value="billing_phone")
	private String billingPhone;//开票电话
	@TableField(value="bank_account_id")
	private Long bankAccountId;//开票银行
	@TableField(value="bank_account_name")
	private String bankAccountName;//开票银行
	@TableField(value="bank_account_code")
	private String bankAccountCode;//开票银行账户
	@TableField(value="come_from")
	private String comeFrom;//供应商来源  邀请入库，自行准入
	@TableField(value="unit_i8_code")
	private String unitI8Code;//I8单位编码 云南使用

	@TableField(exist=false)
	@SubEntity(serviceName="certsService")
	private List<CertsEntity> certs = new ArrayList<>(); // 供应商准入---证书
	@TableField(exist=false)
	@SubEntity(serviceName="historyService")
	private List<HistoryEntity> history = new ArrayList<>(); // 供应商准入---历史业绩
	@TableField(exist=false)
	@SubEntity(serviceName="subleadersService")
	private List<SubleadersEntity> subLeaders = new ArrayList<>(); // 供应商准入---分包供应商

	@TableField(exist=false)
	private java.lang.Long loadTenantId; // 分包供应商 挂载的供应商租户id 公有云的租户 分包负责人推送使用

	@SubEntity(serviceName="laborService")
	@TableField(exist=false)
	private List<LaborEntity> labors = new ArrayList<>(); // 供应商准入---劳务员

	@TableField(value = "email")
	private String email;// 公司邮箱
	@TableField(value = "company_type")
	private String companyType;//企业类型：1-流通型，0-非流通型
	@TableField(value = "recommend_unit_name")
	private String recommendUnitName;//推荐单位

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getCompanyType() {
		return companyType;
	}

	public void setCompanyType(String companyType) {
		this.companyType = companyType;
	}

	public String getRecommendUnitName() {
		return recommendUnitName;
	}

	public void setRecommendUnitName(String recommendUnitName) {
		this.recommendUnitName = recommendUnitName;
	}

	public String getUnitI8Code() {
		return unitI8Code;
	}

	public void setUnitI8Code(String unitI8Code) {
		this.unitI8Code = unitI8Code;
	}

	public List<LaborEntity> getLabors() {
		return labors;
	}

	public void setLabors(List<LaborEntity> labors) {
		this.labors = labors;
	}

	public String getTaxpayerType() {
		return taxpayerType;
	}

	public void setTaxpayerType(String taxpayerType) {
		this.taxpayerType = taxpayerType;
	}

	public String getBillingAddress() {
		return billingAddress;
	}

	public void setBillingAddress(String billingAddress) {
		this.billingAddress = billingAddress;
	}

	public String getBillingPhone() {
		return billingPhone;
	}

	public void setBillingPhone(String billingPhone) {
		this.billingPhone = billingPhone;
	}

	public Long getBankAccountId() {
		return bankAccountId;
	}

	public void setBankAccountId(Long bankAccountId) {
		this.bankAccountId = bankAccountId;
	}

	public String getBankAccountName() {
		return bankAccountName;
	}

	public void setBankAccountName(String bankAccountName) {
		this.bankAccountName = bankAccountName;
	}

	public String getBankAccountCode() {
		return bankAccountCode;
	}

	public void setBankAccountCode(String bankAccountCode) {
		this.bankAccountCode = bankAccountCode;
	}

	public String getMainBusinessCategory() {
		return mainBusinessCategory;
	}

	public void setMainBusinessCategory(String mainBusinessCategory) {
		this.mainBusinessCategory = mainBusinessCategory;
	}

	public String getDistributerOrManufactor() {
		return distributerOrManufactor;
	}

	public void setDistributerOrManufactor(String distributerOrManufactor) {
		this.distributerOrManufactor = distributerOrManufactor;
	}

	public String getRevolvMaterialContentId() {
		return revolvMaterialContentId;
	}

	public void setRevolvMaterialContentId(String revolvMaterialContentId) {
		this.revolvMaterialContentId = revolvMaterialContentId;
	}

	public String getRevolvMaterialContent() {
		return revolvMaterialContent;
	}

	public void setRevolvMaterialContent(String revolvMaterialContent) {
		this.revolvMaterialContent = revolvMaterialContent;
	}

	public String getRevolvMaterialMemo() {
		return revolvMaterialMemo;
	}

	public void setRevolvMaterialMemo(String revolvMaterialMemo) {
		this.revolvMaterialMemo = revolvMaterialMemo;
	}

	public String getConsultContentId() {
		return consultContentId;
	}

	public void setConsultContentId(String consultContentId) {
		this.consultContentId = consultContentId;
	}

	public String getConsultContent() {
		return consultContent;
	}

	public void setConsultContent(String consultContent) {
		this.consultContent = consultContent;
	}

	public String getConsultMemo() {
		return consultMemo;
	}

	public void setConsultMemo(String consultMemo) {
		this.consultMemo = consultMemo;
	}

	public String getBusinessPerson() {
		return businessPerson;
	}

	public void setBusinessPerson(String businessPerson) {
		this.businessPerson = businessPerson;
	}

	public String getBusinessPhone() {
		return businessPhone;
	}

	public void setBusinessPhone(String businessPhone) {
		this.businessPhone = businessPhone;
	}

	public Long getLoadTenantId() {
		return loadTenantId;
	}

	public void setLoadTenantId(Long loadTenantId) {
		this.loadTenantId = loadTenantId;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getSupplyQueryType() {
		return supplyQueryType;
	}

	public void setSupplyQueryType(String supplyQueryType) {
		this.supplyQueryType = supplyQueryType;
	}

	public String getSupplyType() {
		return supplyType;
	}

	public void setSupplyType(String supplyType) {
		this.supplyType = supplyType;
	}

	public String getSupplyTypeName() {
		return supplyTypeName;
	}

	public void setSupplyTypeName(String supplyTypeName) {
		this.supplyTypeName = supplyTypeName;
	}

	public String getPersonal() {
		return personal;
	}

	public void setPersonal(String personal) {
		this.personal = personal;
	}

	public String getGroupInOrOut() {
		return groupInOrOut;
	}

	public void setGroupInOrOut(String groupInOrOut) {
		this.groupInOrOut = groupInOrOut;
	}

	public String getMaterialContentId() {
		return materialContentId;
	}

	public void setMaterialContentId(String materialContentId) {
		this.materialContentId = materialContentId;
	}

	public String getMaterialContent() {
		return materialContent;
	}

	public void setMaterialContent(String materialContent) {
		this.materialContent = materialContent;
	}

	public String getMaterialMemo() {
		return materialMemo;
	}

	public void setMaterialMemo(String materialMemo) {
		this.materialMemo = materialMemo;
	}

	public String getEquipmentContentId() {
		return equipmentContentId;
	}

	public void setEquipmentContentId(String equipmentContentId) {
		this.equipmentContentId = equipmentContentId;
	}

	public String getEquipmentContent() {
		return equipmentContent;
	}

	public void setEquipmentContent(String equipmentContent) {
		this.equipmentContent = equipmentContent;
	}

	public String getEquipmentMemo() {
		return equipmentMemo;
	}

	public void setEquipmentMemo(String equipmentMemo) {
		this.equipmentMemo = equipmentMemo;
	}

	public String getMajorContentId() {
		return majorContentId;
	}

	public void setMajorContentId(String majorContentId) {
		this.majorContentId = majorContentId;
	}

	public String getMajorContent() {
		return majorContent;
	}

	public void setMajorContent(String majorContent) {
		this.majorContent = majorContent;
	}

	public String getMajorMemo() {
		return majorMemo;
	}

	public void setMajorMemo(String majorMemo) {
		this.majorMemo = majorMemo;
	}

	public String getLaborContentId() {
		return laborContentId;
	}

	public void setLaborContentId(String laborContentId) {
		this.laborContentId = laborContentId;
	}

	public String getLaborContent() {
		return laborContent;
	}

	public void setLaborContent(String laborContent) {
		this.laborContent = laborContent;
	}

	public String getLaborMemo() {
		return laborMemo;
	}

	public void setLaborMemo(String laborMemo) {
		this.laborMemo = laborMemo;
	}

	public String getSubContentId() {
		return subContentId;
	}

	public void setSubContentId(String subContentId) {
		this.subContentId = subContentId;
	}

	public String getSubContent() {
		return subContent;
	}

	public void setSubContent(String subContent) {
		this.subContent = subContent;
	}

	public String getSubMemo() {
		return subMemo;
	}

	public void setSubMemo(String subMemo) {
		this.subMemo = subMemo;
	}

	public String getOtherContentId() {
		return otherContentId;
	}

	public void setOtherContentId(String otherContentId) {
		this.otherContentId = otherContentId;
	}

	public String getOtherContent() {
		return otherContent;
	}

	public void setOtherContent(String otherContent) {
		this.otherContent = otherContent;
	}

	public String getOtherMemo() {
		return otherMemo;
	}

	public void setOtherMemo(String otherMemo) {
		this.otherMemo = otherMemo;
	}

	public String getApplyOrgName() {
		return applyOrgName;
	}

	public void setApplyOrgName(String applyOrgName) {
		this.applyOrgName = applyOrgName;
	}

	public Long getApplyOrgId() {
		return applyOrgId;
	}

	public void setApplyOrgId(Long applyOrgId) {
		this.applyOrgId = applyOrgId;
	}

	public String getEnterpriseNatureName() {
		return enterpriseNatureName;
	}

	public void setEnterpriseNatureName(String enterpriseNatureName) {
		this.enterpriseNatureName = enterpriseNatureName;
	}

	public Long getRegisterCountryId() {
		return registerCountryId;
	}

	public void setRegisterCountryId(Long registerCountryId) {
		this.registerCountryId = registerCountryId;
	}

	public String getRegisterCountryName() {
		return registerCountryName;
	}

	public void setRegisterCountryName(String registerCountryName) {
		this.registerCountryName = registerCountryName;
	}


	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public Integer getInOrOut() {
		return inOrOut;
	}

	public void setInOrOut(Integer inOrOut) {
		this.inOrOut = inOrOut;
	}

	public Long getGradeId() {
		return gradeId;
	}

	public void setGradeId(Long gradeId) {
		this.gradeId = gradeId;
	}

	public String getGradeName() {
		return gradeName;
	}

	public void setGradeName(String gradeName) {
		this.gradeName = gradeName;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}


	public Boolean getCoordination() {
		return coordination;
	}

	public void setCoordination(Boolean coordination) {
		this.coordination = coordination;
	}


	public BigDecimal getTurnover() {
		return turnover;
	}

	public void setTurnover(BigDecimal turnover) {
		this.turnover = turnover;
	}

	public Long getPunishType() {
		return punishType;
	}

	public void setPunishType(Long punishType) {
		this.punishType = punishType;
	}

	public Date getPunishDate() {
		return punishDate;
	}

	public void setPunishDate(Date punishDate) {
		this.punishDate = punishDate;
	}

	public String getPunishApplyOrg() {
		return punishApplyOrg;
	}

	public void setPunishApplyOrg(String punishApplyOrg) {
		this.punishApplyOrg = punishApplyOrg;
	}

	public String getPunishApplyPerson() {
		return punishApplyPerson;
	}

	public void setPunishApplyPerson(String punishApplyPerson) {
		this.punishApplyPerson = punishApplyPerson;
	}

	public String getPunishOldGrade() {
		return punishOldGrade;
	}

	public void setPunishOldGrade(String punishOldGrade) {
		this.punishOldGrade = punishOldGrade;
	}

	public String getPunishGrade() {
		return punishGrade;
	}

	public void setPunishGrade(String punishGrade) {
		this.punishGrade = punishGrade;
	}

	public String getPunishMemo() {
		return punishMemo;
	}

	public void setPunishMemo(String punishMemo) {
		this.punishMemo = punishMemo;
	}

	public List<CertsEntity> getCerts() {
		return certs;
	}

	public void setCerts(List<CertsEntity> certs) {
		this.certs = certs;
	}

	public List<HistoryEntity> getHistory() {
		return history;
	}

	public void setHistory(List<HistoryEntity> history) {
		this.history = history;
	}

	public List<SubleadersEntity> getSubLeaders() {
		return subLeaders;
	}

	public void setSubLeaders(List<SubleadersEntity> subLeaders) {
		this.subLeaders = subLeaders;
	}

	public Boolean getInException() {
		return inException;
	}

	public void setInException(Boolean inException) {
		this.inException = inException;
	}

	public Date getExceptionEndDate() {
		return exceptionEndDate;
	}

	public void setExceptionEndDate(Date exceptionEndDate) {
		this.exceptionEndDate = exceptionEndDate;
	}

	public Date getLastCoDate() {
		return lastCoDate;
	}

	public void setLastCoDate(Date lastCoDate) {
		this.lastCoDate = lastCoDate;
	}

	public Long getAccessId() {
		return accessId;
	}

	public void setAccessId(Long accessId) {
		this.accessId = accessId;
	}

	public Integer getRedlistFlag() {
		return redlistFlag;
	}

	public void setRedlistFlag(Integer redlistFlag) {
		this.redlistFlag = redlistFlag;
	}

	public Date getBlTime() {
		return blTime;
	}

	public void setBlTime(Date blTime) {
		this.blTime = blTime;
	}

	public Date getSplTime() {
		return splTime;
	}

	public void setSplTime(Date splTime) {
		this.splTime = splTime;
	}

	public Date getQcTime() {
		return qcTime;
	}

	public void setQcTime(Date qcTime) {
		this.qcTime = qcTime;
	}

	public Date getScTime() {
		return scTime;
	}

	public void setScTime(Date scTime) {
		this.scTime = scTime;
	}

	public Long getEnterpriseNature() {
		return enterpriseNature;
	}

	public void setEnterpriseNature(Long enterpriseNature) {
		this.enterpriseNature = enterpriseNature;
	}

	public Date getRegisterTime() {
		return registerTime;
	}

	public void setRegisterTime(Date registerTime) {
		this.registerTime = registerTime;
	}

	public String getTaxPayerIdentifier() {
		return taxPayerIdentifier;
	}

	public void setTaxPayerIdentifier(String taxPayerIdentifier) {
		this.taxPayerIdentifier = taxPayerIdentifier;
	}

	public BigDecimal getRegisteredCapital() {
		return registeredCapital;
	}

	public void setRegisteredCapital(BigDecimal registeredCapital) {
		this.registeredCapital = registeredCapital;
	}

	public String getLegalPhone() {
		return legalPhone;
	}

	public void setLegalPhone(String legalPhone) {
		this.legalPhone = legalPhone;
	}

	public Date getIssuingTime() {
		return issuingTime;
	}

	public void setIssuingTime(Date issuingTime) {
		this.issuingTime = issuingTime;
	}

	public Integer getEvaluationGrade() {
		return evaluationGrade;
	}

	public void setEvaluationGrade(Integer evaluationGrade) {
		this.evaluationGrade = evaluationGrade;
	}

	public Integer getSupplierFlag() {
		return supplierFlag;
	}

	public void setSupplierFlag(Integer supplierFlag) {
		this.supplierFlag = supplierFlag;
	}

	public Integer getSubFlag() {
		return subFlag;
	}

	public void setSubFlag(Integer subFlag) {
		this.subFlag = subFlag;
	}

	public Integer getBlacklistFlag() {
		return blacklistFlag;
	}

	public void setBlacklistFlag(Integer blacklistFlag) {
		this.blacklistFlag = blacklistFlag;
	}

	public Long getOperateId() {
		return operateId;
	}

	public void setOperateId(Long operateId) {
		this.operateId = operateId;
	}

	public String getOperateName() {
		return operateName;
	}

	public void setOperateName(String operateName) {
		this.operateName = operateName;
	}

	public Date getOperateTime() {
		return operateTime;
	}

	public void setOperateTime(Date operateTime) {
		this.operateTime = operateTime;
	}

	public Long getOperateOrgId() {
		return operateOrgId;
	}

	public void setOperateOrgId(Long operateOrgId) {
		this.operateOrgId = operateOrgId;
	}

	public String getOperateOrgName() {
		return operateOrgName;
	}

	public void setOperateOrgName(String operateOrgName) {
		this.operateOrgName = operateOrgName;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public Long getTenant() {
		return tenant;
	}

	public void setTenant(Long tenant) {
		this.tenant = tenant;
	}

	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}

	public String getTenantPhone() {
		return tenantPhone;
	}

	public void setTenantPhone(String tenantPhone) {
		this.tenantPhone = tenantPhone;
	}

	public String getTenantUserName() {
		return tenantUserName;
	}

	public void setTenantUserName(String tenantUserName) {
		this.tenantUserName = tenantUserName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getInsideOrgId() {
		return insideOrgId;
	}

	public void setInsideOrgId(Long insideOrgId) {
		this.insideOrgId = insideOrgId;
	}

	public Boolean getInsideOrg() {
		return insideOrg;
	}

	public void setInsideOrg(Boolean insideOrg) {
		this.insideOrg = insideOrg;
	}

	public String getComeFrom() {
		return comeFrom;
	}

	public void setComeFrom(String comeFrom) {
		this.comeFrom = comeFrom;
	}
}
