/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.PriceDepotPowerSetEntity;
import com.ejianc.foundation.share.service.IPriceDepotPowerSetService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/priceDepotPowerSet/"})
public class PriceDepotPowerSetApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPriceDepotPowerSetService service;

    @GetMapping(value={"queryOrgList"})
    @ResponseBody
    public CommonResponse<List<Long>> queryOrgList(Long orgId) {
        String[] split;
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,orgId:" + orgId);
        ArrayList<Long> topOrg = new ArrayList<Long>();
        CommonResponse oneById = this.iOrgApi.getOneById(orgId);
        if (!oneById.isSuccess() || oneById.getData() == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO data = (OrgVO)oneById.getData();
        String innerCode = data.getInnerCode();
        for (String s : split = innerCode.split("\\|")) {
            Long org = Long.valueOf(s);
            topOrg.add(org);
        }
        this.logger.info("topOrg:" + topOrg);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"org_id", topOrg);
        List entitys = this.service.list((Wrapper)wrapper);
        HashMap entityMap = new HashMap();
        entitys.forEach(item -> entityMap.put(item.getOrgId(), item));
        int index = 1;
        Long powerTopOrg = null;
        for (int i = topOrg.size() - index; i >= 0; --i) {
            powerTopOrg = (Long)topOrg.get(i);
            PriceDepotPowerSetEntity tEntity = (PriceDepotPowerSetEntity)((Object)entityMap.get(topOrg.get(i)));
            if (null == tEntity || tEntity.getEnabled() != 1) continue;
            powerTopOrg = (Long)topOrg.get(i);
            break;
        }
        this.logger.info("\u6700\u4e0a\u7ea7\u7684orgId:" + powerTopOrg);
        List downOrgids = ((List)this.iOrgApi.findChildrenByParentId(powerTopOrg).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        downOrgids.remove(powerTopOrg);
        ArrayList excludeOrg = new ArrayList();
        HashSet excludeSet = new HashSet();
        wrapper = new QueryWrapper();
        wrapper.in((Object)"org_id", downOrgids);
        List downEntitys = this.service.list((Wrapper)wrapper);
        downEntitys.forEach(item -> {
            if (item.getEnabled() == 1) {
                excludeOrg.add(item.getOrgId());
            }
        });
        this.logger.info("\u9700\u8981\u6392\u9664\u7684org(\u4e0a\u7ea7):" + excludeOrg);
        excludeOrg.forEach(item -> {
            List collect = ((List)this.iOrgApi.findChildrenByParentId(item).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            excludeSet.addAll(collect);
        });
        this.logger.info("\u6392\u9664\u4e4b\u524d\u7684org\u6570\u91cf:" + downOrgids.size() + "," + downOrgids);
        this.logger.info("\u6392\u9664\u7684org\u6570\u91cf:" + excludeSet.size() + "," + excludeSet);
        downOrgids.removeAll(excludeSet);
        HashSet resultSet = new HashSet(downOrgids);
        resultSet.add(powerTopOrg);
        List collect = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        resultSet.addAll(collect);
        this.logger.info("\u6700\u7ec8\u8fd4\u56de\u7684org\u96c6\u5408\uff1a" + resultSet);
        return CommonResponse.success(new ArrayList(resultSet));
    }
}

